theory Abs
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "../Quotient" "../Quotient_Product"
begin

(* the next three lemmas that should be in Nominal \<dots>\<dots>must be cleaned *)
lemma ball_image: 
  shows "(\<forall>x \<in> p \<bullet> S. P x) = (\<forall>x \<in> S. P (p \<bullet> x))"
apply(auto)
apply(drule_tac x="p \<bullet> x" in bspec)
apply(simp add: mem_permute_iff)
apply(simp)
apply(drule_tac x="(- p) \<bullet> x" in bspec)
apply(rule_tac p1="p" in mem_permute_iff[THEN iffD1])
apply(simp)
apply(simp)
done

lemma fresh_star_plus:
  fixes p q::perm
  shows "\<lbrakk>a \<sharp>* p;  a \<sharp>* q\<rbrakk> \<Longrightarrow> a \<sharp>* (p + q)"
  unfolding fresh_star_def
  by (simp add: fresh_plus_perm)

lemma fresh_star_permute_iff:
  shows "(p \<bullet> a) \<sharp>* (p \<bullet> x) \<longleftrightarrow> a \<sharp>* x"
apply(simp add: fresh_star_def)
apply(simp add: ball_image)
apply(simp add: fresh_permute_iff)
done

fun
  alpha_gen 
where
  alpha_gen[simp del]:
  "alpha_gen (bs, x) R f pi (cs, y) \<longleftrightarrow> f x - bs = f y - cs \<and> (f x - bs) \<sharp>* pi \<and> R (pi \<bullet> x) y"

notation
  alpha_gen ("_ \<approx>gen _ _ _ _" [100, 100, 100, 100, 100] 100)

lemma [mono]: "R1 \<le> R2 \<Longrightarrow> alpha_gen x R1 \<le> alpha_gen x R2"
  by (cases x) (auto simp add: le_fun_def le_bool_def alpha_gen.simps)

lemma alpha_gen_refl:
  assumes a: "R x x"
  shows "(bs, x) \<approx>gen R f 0 (bs, x)"
  using a by (simp add: alpha_gen fresh_star_def fresh_zero_perm)

lemma alpha_gen_sym:
  assumes a: "(bs, x) \<approx>gen R f p (cs, y)"
  and     b: "R (p \<bullet> x) y \<Longrightarrow> R (- p \<bullet> y) x"
  shows "(cs, y) \<approx>gen R f (- p) (bs, x)"
  using a b by (simp add: alpha_gen fresh_star_def fresh_def supp_minus_perm)

lemma alpha_gen_trans:
  assumes a: "(bs, x) \<approx>gen R f p1 (cs, y)"
  and     b: "(cs, y) \<approx>gen R f p2 (ds, z)"
  and     c: "\<lbrakk>R (p1 \<bullet> x) y; R (p2 \<bullet> y) z\<rbrakk> \<Longrightarrow> R ((p2 + p1) \<bullet> x) z"
  shows "(bs, x) \<approx>gen R f (p2 + p1) (ds, z)"
  using a b c using supp_plus_perm
  apply(simp add: alpha_gen fresh_star_def fresh_def)
  apply(blast)
  done

lemma alpha_gen_eqvt:
  assumes a: "(bs, x) \<approx>gen R f q (cs, y)"
  and     b: "R (q \<bullet> x) y \<Longrightarrow> R (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     c: "p \<bullet> (f x) = f (p \<bullet> x)"
  and     d: "p \<bullet> (f y) = f (p \<bullet> y)"
  shows "(p \<bullet> bs, p \<bullet> x) \<approx>gen R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  using a b
  apply(simp add: alpha_gen c[symmetric] d[symmetric] Diff_eqvt[symmetric])
  apply(simp add: permute_eqvt[symmetric])
  apply(simp add: fresh_star_permute_iff)
  apply(clarsimp)
  done

lemma alpha_gen_compose_sym:
  assumes b: "\<exists>pi. (aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> R x2 x1) f pi (ab, s)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "\<exists>pi. (ab, s) \<approx>gen R f pi (aa, t)"
  using b apply -
  apply(erule exE)
  apply(rule_tac x="- pi" in exI)
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(rule conjI)
  apply(simp add: fresh_star_def fresh_minus_perm)
  apply(subgoal_tac "R (- pi \<bullet> s) ((- pi) \<bullet> (pi \<bullet> t))")
  apply simp
  apply(rule a)
  apply assumption
  done

lemma alpha_gen_compose_trans:
  assumes b: "\<exists>pi\<Colon>perm. (aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> (\<forall>x. R x2 x \<longrightarrow> R x1 x)) f pi (ab, ta)"
  and c: "\<exists>pi\<Colon>perm. (ab, ta) \<approx>gen R f pi (ac, sa)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "\<exists>pi\<Colon>perm. (aa, t) \<approx>gen R f pi (ac, sa)"
  using b c apply -
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(erule exE)+
  apply(erule conjE)+
  apply(rule_tac x="pia + pi" in exI)
  apply(simp add: fresh_star_plus)
  apply(drule_tac x="- pia \<bullet> sa" in spec)
  apply(drule mp)
  apply(rotate_tac 4)
  apply(drule_tac pi="- pia" in a)
  apply(simp)
  apply(rotate_tac 6)
  apply(drule_tac pi="pia" in a)
  apply(simp)
  done

lemma alpha_gen_compose_eqvt:
  assumes b: "\<exists>pia. (g d, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> R (pi \<bullet> x1) (pi \<bullet> x2)) f pia (g e, s)"
  and     c: "\<And>y. pi \<bullet> (g y) = g (pi \<bullet> y)"
  and     a: "\<And>x. pi \<bullet> (f x) = f (pi \<bullet> x)"
  shows  "\<exists>pia. (g (pi \<bullet> d), pi \<bullet> t) \<approx>gen R f pia (g (pi \<bullet> e), pi \<bullet> s)"
  using b
  apply -
  apply(erule exE)
  apply(rule_tac x="pi \<bullet> pia" in exI)
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(rule conjI)
  apply(rule_tac ?p1="- pi" in permute_eq_iff[THEN iffD1])
  apply(simp add: a[symmetric] atom_eqvt Diff_eqvt insert_eqvt set_eqvt empty_eqvt c[symmetric])
  apply(rule conjI)
  apply(rule_tac ?p1="- pi" in fresh_star_permute_iff[THEN iffD1])
  apply(simp add: a[symmetric] atom_eqvt Diff_eqvt insert_eqvt set_eqvt empty_eqvt c[symmetric])
  apply(subst permute_eqvt[symmetric])
  apply(simp)
  done

fun
  alpha_abs 
where
  "alpha_abs (bs, x) (cs, y) = (\<exists>p. (bs, x) \<approx>gen (op=) supp p (cs, y))"

notation
  alpha_abs ("_ \<approx>abs _")

lemma alpha_abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(bs, x) \<approx>abs ((a \<rightleftharpoons> b) \<bullet> bs, (a \<rightleftharpoons> b) \<bullet> x)"
  apply(simp)
  apply(rule_tac x="(a \<rightleftharpoons> b)" in exI)
  apply(simp add: alpha_gen)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(simp add: swap_set_not_in[OF a1 a2])
  apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
  using a1 a2
  apply(simp add: fresh_star_def fresh_def)
  apply(blast)
  apply(simp add: supp_swap)
  done

fun
  supp_abs_fun
where
  "supp_abs_fun (bs, x) = (supp x) - bs"

lemma supp_abs_fun_lemma:
  assumes a: "x \<approx>abs y" 
  shows "supp_abs_fun x = supp_abs_fun y"
  using a
  apply(induct rule: alpha_abs.induct)
  apply(simp add: alpha_gen)
  done
  
quotient_type 'a abs = "(atom set \<times> 'a::pt)" / "alpha_abs"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(simp_all)
  (* refl *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  (* symm *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_sym)
  apply(assumption)
  apply(clarsimp)
  (* trans *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_trans)
  apply(assumption)
  apply(assumption)
  apply(simp)
  done

quotient_definition
  "Abs::atom set \<Rightarrow> ('a::pt) \<Rightarrow> 'a abs"
is
  "Pair::atom set \<Rightarrow> ('a::pt) \<Rightarrow> (atom set \<times> 'a)"

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> alpha_abs) Pair Pair"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  done

lemma [quot_respect]:
  shows "((op =) ===> alpha_abs ===> alpha_abs) permute permute"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_eqvt)
  apply(assumption)
  apply(simp_all add: supp_eqvt)
  done

lemma [quot_respect]:
  shows "(alpha_abs ===> (op =)) supp_abs_fun supp_abs_fun"
  apply(simp add: supp_abs_fun_lemma)
  done

lemma abs_induct:
  "\<lbrakk>\<And>as (x::'a::pt). P (Abs as x)\<rbrakk> \<Longrightarrow> P t"
  apply(lifting prod.induct[where 'a="atom set" and 'b="'a"])
  done

(* TEST case *)
lemmas abs_induct2 = prod.induct[where 'a="atom set" and 'b="'a::pt", quot_lifted]
thm abs_induct abs_induct2

instantiation abs :: (pt) pt
begin

quotient_definition
  "permute_abs::perm \<Rightarrow> ('a::pt abs) \<Rightarrow> 'a abs"
is
  "permute:: perm \<Rightarrow> (atom set \<times> 'a::pt) \<Rightarrow> (atom set \<times> 'a::pt)"

lemma permute_ABS [simp]:
  fixes x::"'a::pt"  (* ??? has to be 'a \<dots> 'b does not work *)
  shows "(p \<bullet> (Abs as x)) = Abs (p \<bullet> as) (p \<bullet> x)"
  by (lifting permute_prod.simps(1)[where 'a="atom set" and 'b="'a"])

instance
  apply(default)
  apply(induct_tac [!] x rule: abs_induct)
  apply(simp_all)
  done

end

quotient_definition
  "supp_Abs_fun :: ('a::pt) abs \<Rightarrow> atom \<Rightarrow> bool"
is
  "supp_abs_fun"

lemma supp_Abs_fun_simp:
  shows "supp_Abs_fun (Abs bs x) = (supp x) - bs"
  by (lifting supp_abs_fun.simps(1))

lemma supp_Abs_fun_eqvt [eqvt]:
  shows "(p \<bullet> supp_Abs_fun x) = supp_Abs_fun (p \<bullet> x)"
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs_fun_simp supp_eqvt Diff_eqvt)
  done

lemma supp_Abs_fun_fresh:
  shows "a \<sharp> Abs bs x \<Longrightarrow> a \<sharp> supp_Abs_fun (Abs bs x)"
  apply(rule fresh_fun_eqvt_app)
  apply(simp add: eqvts_raw)
  apply(simp)
  done

lemma Abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(Abs bs x) = (Abs ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
  using a1 a2 by (lifting alpha_abs_swap)

lemma Abs_supports:
  shows "((supp x) - as) supports (Abs as x)"
  unfolding supports_def
  apply(clarify)
  apply(simp (no_asm))
  apply(subst Abs_swap[symmetric])
  apply(simp_all)
  done

lemma supp_Abs_subset1:
  fixes x::"'a::fs"
  shows "(supp x) - as \<subseteq> supp (Abs as x)"
  apply(simp add: supp_conv_fresh)
  apply(auto)
  apply(drule_tac supp_Abs_fun_fresh)
  apply(simp only: supp_Abs_fun_simp)
  apply(simp add: fresh_def)
  apply(simp add: supp_finite_atom_set finite_supp)
  done

lemma supp_Abs_subset2:
  fixes x::"'a::fs"
  shows "supp (Abs as x) \<subseteq> (supp x) - as"
  apply(rule supp_is_subset)
  apply(rule Abs_supports)
  apply(simp add: finite_supp)
  done

lemma supp_Abs:
  fixes x::"'a::fs"
  shows "supp (Abs as x) = (supp x) - as"
  apply(rule_tac subset_antisym)
  apply(rule supp_Abs_subset2)
  apply(rule supp_Abs_subset1)
  done

instance abs :: (fs) fs
  apply(default)
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs)
  apply(simp add: finite_supp)
  done

lemma Abs_fresh_iff:
  fixes x::"'a::fs"
  shows "a \<sharp> Abs bs x \<longleftrightarrow> a \<in> bs \<or> (a \<notin> bs \<and> a \<sharp> x)"
  apply(simp add: fresh_def)
  apply(simp add: supp_Abs)
  apply(auto)
  done

lemma Abs_eq_iff:
  shows "Abs bs x = Abs cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
  by (lifting alpha_abs.simps(1))



(* 
  below is a construction site for showing that in the
  single-binder case, the old and new alpha equivalence 
  coincide
*)

fun
  alpha1
where
  "alpha1 (a, x) (b, y) \<longleftrightarrow> (a = b \<and> x = y) \<or> (a \<noteq> b \<and> x = (a \<rightleftharpoons> b) \<bullet> y \<and> a \<sharp> y)"

notation 
  alpha1 ("_ \<approx>abs1 _")

thm swap_set_not_in

lemma qq:
  fixes S::"atom set"
  assumes a: "supp p \<inter> S = {}"
  shows "p \<bullet> S = S"
using a
apply(simp add: supp_perm permute_set_eq)
apply(auto)
apply(simp only: disjoint_iff_not_equal)
apply(simp)
apply (metis permute_atom_def_raw)
apply(rule_tac x="(- p) \<bullet> x" in exI)
apply(simp)
apply(simp only: disjoint_iff_not_equal)
apply(simp)
apply(metis permute_minus_cancel)
done

lemma alpha_abs_swap:
  assumes a1: "(supp x - bs) \<sharp>* p"
  and     a2: "(supp x - bs) \<sharp>* p"
  shows "(bs, x) \<approx>abs (p \<bullet> bs, p \<bullet> x)"
  apply(simp)
  apply(rule_tac x="p" in exI)
  apply(simp add: alpha_gen)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(rule conjI)
  apply(rule sym)
  apply(rule qq)
  using a1 a2
  apply(auto)[1]
  oops



lemma
  assumes a: "(a, x) \<approx>abs1 (b, y)" "sort_of a = sort_of b"
  shows "({a}, x) \<approx>abs ({b}, y)"
using a
apply(simp)
apply(erule disjE)
apply(simp)
apply(rule exI)
apply(rule alpha_gen_refl)
apply(simp)
apply(rule_tac x="(a \<rightleftharpoons> b)" in  exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_def)
apply(rule conjI)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in  permute_eq_iff[THEN iffD1])
apply(rule trans)
apply(simp add: Diff_eqvt supp_eqvt)
apply(subst swap_set_not_in)
back
apply(simp)
apply(simp)
apply(simp add: permute_set_eq)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in fresh_star_permute_iff[THEN iffD1])
apply(simp add: permute_self)
apply(simp add: Diff_eqvt supp_eqvt)
apply(simp add: permute_set_eq)
apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
apply(simp add: fresh_star_def fresh_def)
apply(blast)
apply(simp add: supp_swap)
done

thm supp_perm

lemma perm_induct_test:
  fixes P :: "perm => bool"
  assumes zero: "P 0"
  assumes swap: "\<And>a b. \<lbrakk>sort_of a = sort_of b; a \<noteq> b\<rbrakk> \<Longrightarrow> P (a \<rightleftharpoons> b)"
  assumes plus: "\<And>p1 p2. \<lbrakk>supp (p1 + p2) = (supp p1 \<union> supp p2); P p1; P p2\<rbrakk> \<Longrightarrow> P (p1 + p2)"
  shows "P p"
sorry

lemma tt1:
  assumes a: "finite (supp p)"
  shows "(supp x) \<sharp>* p \<Longrightarrow> p \<bullet> x = x"
using a
unfolding fresh_star_def fresh_def
apply(induct F\<equiv>"supp p" arbitrary: p rule: finite.induct)
apply(simp add: supp_perm)
defer
apply(case_tac "a \<in> A")
apply(simp add: insert_absorb)
apply(subgoal_tac "A = supp p - {a}")
prefer 2
apply(blast)
apply(case_tac "p \<bullet> a = a")
apply(simp add: supp_perm)
apply(drule_tac x="p + (((- p) \<bullet> a) \<rightleftharpoons> a)" in meta_spec)
apply(simp)
apply(drule meta_mp)
apply(rule subset_antisym)
apply(rule subsetI)
apply(simp)
apply(simp add: supp_perm)
apply(case_tac "xa = p \<bullet> a")
apply(simp)
apply(case_tac "p \<bullet> a = (- p) \<bullet> a")
apply(simp)
defer
apply(simp)
oops

lemma tt:
  "(supp x) \<sharp>* p \<Longrightarrow> p \<bullet> x = x"
apply(induct p rule: perm_induct_test)
apply(simp)
apply(rule swap_fresh_fresh)
apply(case_tac "a \<in> supp x")
apply(simp add: fresh_star_def)
apply(drule_tac x="a" in bspec)
apply(simp)
apply(simp add: fresh_def)
apply(simp add: supp_swap)
apply(simp add: fresh_def)
apply(case_tac "b \<in> supp x")
apply(simp add: fresh_star_def)
apply(drule_tac x="b" in bspec)
apply(simp)
apply(simp add: fresh_def)
apply(simp add: supp_swap)
apply(simp add: fresh_def)
apply(simp)
apply(drule meta_mp)
apply(simp add: fresh_star_def fresh_def)
apply(drule meta_mp)
apply(simp add: fresh_star_def fresh_def)
apply(simp)
done

lemma yy:
  assumes "S1 - {x} = S2 - {x}" "x \<in> S1" "x \<in> S2"
  shows "S1 = S2"
using assms
apply (metis insert_Diff_single insert_absorb)
done


lemma
  assumes a: "({a}, x) \<approx>abs ({b}, y)" "sort_of a = sort_of b"
  shows "(a, x) \<approx>abs1 (b, y)"
using a
apply(case_tac "a = b")
apply(simp)
oops


end

