theory Test
imports "Parser"
begin

atom_decl name

ML {* val _ = recursive := false  *}

text {* example 3 from Terms.thy *}

nominal_datatype trm3 =
  Vr3 "name"
| Ap3 "trm3" "trm3"
| Lm3 x::"name" t::"trm3"        bind x in t
| Lt3 r::"rassigns3" t::"trm3"   bind "bv3 r" in t
and rassigns3 =
  ANil
| ACons "name" "trm3" "rassigns3"
binder
  bv3
where
  "bv3 ANil = {}"
| "bv3 (ACons x t as) = {atom x} \<union> (bv3 as)"

thm trm3_rassigns3.fv
thm trm3_rassigns3.eq_iff
thm trm3_rassigns3.bn
thm trm3_rassigns3.perm
thm trm3_rassigns3.induct
thm trm3_rassigns3.distinct
thm trm3_rassigns3.fv[simplified trm3_rassigns3.supp]

(* example 5 from Terms.thy *)

nominal_datatype trm5 =
  Vr5 "name"
| Ap5 "trm5" "trm5"
| Lt5 l::"lts" t::"trm5"  bind "bv5 l" in t
and lts =
  Lnil
| Lcons "name" "trm5" "lts"
binder
  bv5
where
  "bv5 Lnil = {}"
| "bv5 (Lcons n t ltl) = {atom n} \<union> (bv5 ltl)"

thm trm5_lts.fv
thm trm5_lts.eq_iff
thm trm5_lts.bn
thm trm5_lts.perm
thm trm5_lts.induct
thm trm5_lts.distinct
thm trm5_lts.fv[simplified trm5_lts.supp]

(* example 3 from Peter Sewell's bestiary *)

nominal_datatype exp =
  VarP "name"
| AppP "exp" "exp"
| LamP x::"name" e::"exp" bind x in e
| LetP x::"name" p::"pat3" e1::"exp" e2::"exp" bind x in e2, bind "bp'' p" in e1
and pat3 =
  PVar "name"
| PUnit
| PPair "pat3" "pat3"
binder
  bp'' :: "pat3 \<Rightarrow> atom set"
where
  "bp'' (PVar x) = {atom x}"
| "bp'' (PUnit) = {}"
| "bp'' (PPair p1 p2) = bp'' p1 \<union> bp'' p2"

thm exp_pat3.fv
thm exp_pat3.eq_iff
thm exp_pat3.bn
thm exp_pat3.perm
thm exp_pat3.induct
thm exp_pat3.distinct
thm exp_pat3.fv[simplified exp_pat3.supp]

(* example 6 from Peter Sewell's bestiary *)
nominal_datatype exp6 =
  EVar name
| EPair exp6 exp6
| ELetRec x::name p::pat6 e1::exp6 e2::exp6 bind x in e1, bind x in e2, bind "bp6 p" in e1
and pat6 =
  PVar' name
| PUnit'
| PPair' pat6 pat6
binder
  bp6 :: "pat6 \<Rightarrow> atom set"
where
  "bp6 (PVar' x) = {atom x}"
| "bp6 (PUnit') = {}"
| "bp6 (PPair' p1 p2) = bp6 p1 \<union> bp6 p2"

thm exp6_pat6.fv
thm exp6_pat6.eq_iff
thm exp6_pat6.bn
thm exp6_pat6.perm
thm exp6_pat6.induct
thm exp6_pat6.distinct


(* THE REST ARE NOT SUPPOSED TO WORK YET *)

(* example 7 from Peter Sewell's bestiary *)
(* dest_Const raised
nominal_datatype exp7 =
  EVar' name
| EUnit'
| EPair' exp7 exp7
| ELetRec' l::lrbs e::exp7 bind "b7s l" in e, bind "b7s l" in l
and lrb =
  Assign' name exp7
and lrbs =
  Single' lrb
| More' lrb lrbs
binder
  b7 :: "lrb \<Rightarrow> atom set" and
  b7s :: "lrbs \<Rightarrow> atom set"
where
  "b7 (Assign x e) = {atom x}"
| "b7s (Single a) = b7 a"
| "b7s (More a as) = (b7 a) \<union> (b7s as)"
thm alpha_exp7_raw_alpha_lrb_raw_alpha_lrbs_raw.intros
*)

(* example 8 from Peter Sewell's bestiary *)
(*
*** fv_bn: recursive argument, but wrong datatype.
*** At command "nominal_datatype".
nominal_datatype exp8 =
  EVar' name
| EUnit'
| EPair' exp8 exp8
| ELetRec' l::lrbs8 e::exp8 bind "b_lrbs8 l" in e, bind "b_lrbs8 l" in l
and fnclause =
  K' x::name p::pat8 e::exp8 bind "b_pat p" in e
and fnclauses =
  S' fnclause
| ORs' fnclause fnclauses
and lrb8 =
  Clause' fnclauses
and lrbs8 =
  Single' lrb8
| More' lrb8 lrbs8
and pat8 =
  PVar'' name
| PUnit''
| PPair'' pat8 pat8
binder
  b_lrbs8 :: "lrbs8 \<Rightarrow> atom set" and
  b_pat :: "pat8 \<Rightarrow> atom set" and
  b_fnclauses :: "fnclauses \<Rightarrow> atom set" and
  b_fnclause :: "fnclause \<Rightarrow> atom set" and
  b_lrb8 :: "lrb8 \<Rightarrow> atom set"
where
  "b_lrbs8 (Single' l) = b_lrb8 l"
| "b_lrbs8 (More' l ls) = b_lrb8 l \<union> b_lrbs8 ls"
| "b_pat (PVar'' x) = {atom x}"
| "b_pat (PUnit'') = {}"
| "b_pat (PPair'' p1 p2) = b_pat p1 \<union> b_pat p2"
| "b_fnclauses (S' fc) = (b_fnclause fc)"
| "b_fnclauses (ORs' fc fcs) = (b_fnclause fc) \<union> (b_fnclauses fcs)"
| "b_lrb8 (Clause' fcs) = (b_fnclauses fcs)"
| "b_fnclause (K' x pat exp8) = {atom x}"
thm alpha_exp8_raw_alpha_fnclause_raw_alpha_fnclauses_raw_alpha_lrb8_raw_alpha_lrbs8_raw_alpha_pat8_raw.intros
*)
(* example 4 from Terms.thy *)
(* fv_eqvt does not work, we need to repaire defined permute functions
   defined fv and defined alpha... *)
(* lists-datastructure does not work yet
nominal_datatype trm4 =
  Vr4 "name"
| Ap4 "trm4" "trm4 list"
| Lm4 x::"name" t::"trm4"  bind x in t

thm alpha_trm4_raw_alpha_trm4_raw_list.intros[no_vars]
thm fv_trm4_raw_fv_trm4_raw_list.simps[no_vars]
*)
(* core haskell *)
atom_decl var
atom_decl tvar

(* there are types, coercion types and regular types *)
(* list-data-structure
nominal_datatype tkind =
  KStar
| KFun "tkind" "tkind"
and ckind =
  CKEq "ty" "ty"
and ty =
  TVar "tvar"
| TC "string"
| TApp "ty" "ty"
| TFun "string" "ty list"
| TAll tv::"tvar" "tkind" T::"ty"  bind tv in T
| TEq "ty" "ty" "ty"
and co =
  CC "string"
| CApp "co" "co"
| CFun "string" "co list"
| CAll tv::"tvar" "ckind" C::"co"  bind tv in C
| CEq "co" "co" "co"
| CSym "co"
| CCir "co" "co"
| CLeft "co"
| CRight "co"
| CSim "co"
| CRightc "co"
| CLeftc "co"
| CCoe "co" "co"

abbreviation
  "atoms A \<equiv> atom ` A"

nominal_datatype trm =
  Var "var"
| C "string"
| LAM tv::"tvar" "kind" t::"trm"   bind tv in t
| APP "trm" "ty"
| Lam v::"var" "ty" t::"trm"       bind v in t
| App "trm" "trm"
| Let x::"var" "ty" "trm" t::"trm" bind x in t
| Case "trm" "assoc list"
| Cast "trm" "ty"                   --"ty is supposed to be a coercion type only"
and assoc =
  A p::"pat" t::"trm" bind "bv p" in t
and pat =
  K "string" "(tvar \<times> kind) list" "(var \<times> ty) list"
binder
 bv :: "pat \<Rightarrow> atom set"
where
 "bv (K s ts vs) = (atoms (set (map fst ts))) \<union> (atoms (set (map fst vs)))"
*)

(* example 8 from Terms.thy *)

(* Binding in a term under a bn, needs to fail *)
(*
nominal_datatype foo8 =
  Foo0 "name"
| Foo1 b::"bar8" f::"foo8" bind "bv8 b" in f --"check fo error if this is called foo"
and bar8 =
  Bar0 "name"
| Bar1 "name" s::"name" b::"bar8" bind s in b
binder
  bv8
where
  "bv8 (Bar0 x) = {}"
| "bv8 (Bar1 v x b) = {atom v}"
*)

(* example 9 from Peter Sewell's bestiary *)
(* run out of steam at the moment *)

end



