theory QuotProd
imports QuotMain
begin

fun
  prod_rel
where
  "prod_rel R1 R2 = (\<lambda>(a,b) (c,d). R1 a c \<and> R2 b d)"

declare [[map * = (prod_fun, prod_rel)]]


lemma prod_equivp[quot_equiv]:
  assumes a: "equivp R1"
  assumes b: "equivp R2"
  shows "equivp (prod_rel R1 R2)"
unfolding equivp_reflp_symp_transp reflp_def symp_def transp_def
apply(auto simp add: equivp_reflp[OF a] equivp_reflp[OF b])
apply(simp only: equivp_symp[OF a])
apply(simp only: equivp_symp[OF b])
using equivp_transp[OF a] apply blast
using equivp_transp[OF b] apply blast
done

lemma prod_quotient[quot_thm]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "Quotient (prod_rel R1 R2) (prod_fun Abs1 Abs2) (prod_fun Rep1 Rep2)"
unfolding Quotient_def
using q1 q2
apply (simp add: Quotient_abs_rep Quotient_abs_rep Quotient_rel_rep Quotient_rel_rep)
using Quotient_rel[OF q1] Quotient_rel[OF q2] 
by blast

lemma pair_rsp[quot_respect]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(R1 ===> R2 ===> prod_rel R1 R2) Pair Pair"
by simp

lemma pair_prs[quot_preserve]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(Rep1 ---> Rep2 ---> (prod_fun Abs1 Abs2)) Pair = Pair"
apply(simp add: expand_fun_eq)
apply(simp add: Quotient_abs_rep[OF q1] Quotient_abs_rep[OF q2])
done

lemma fst_rsp[quot_respect]:
  assumes "Quotient R1 Abs1 Rep1"
  assumes "Quotient R2 Abs2 Rep2"
  shows "(prod_rel R1 R2 ===> R1) fst fst"
  by simp

lemma fst_prs[quot_preserve]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(prod_fun Rep1 Rep2 ---> Abs1) fst = fst"
apply(simp add: expand_fun_eq)
apply(simp add: Quotient_abs_rep[OF q1])
done

lemma snd_rsp[quot_respect]:
  assumes "Quotient R1 Abs1 Rep1"
  assumes "Quotient R2 Abs2 Rep2"
  shows "(prod_rel R1 R2 ===> R2) snd snd"
  by simp
  
lemma snd_prs[quot_preserve]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(prod_fun Rep1 Rep2 ---> Abs2) snd = snd"
apply(simp add: expand_fun_eq)
apply(simp add: Quotient_abs_rep[OF q2])
done

lemma prod_fun_id[id_simps]: 
  shows "prod_fun id id \<equiv> id"
  by (rule eq_reflection) 
     (simp add: prod_fun_def)

lemma prod_rel_eq[id_simps]: 
  shows "prod_rel (op =) (op =) \<equiv> (op =)"
  apply (rule eq_reflection)
  apply (rule ext)+
  apply auto
  done

end
