theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 20]]

nominal_datatype trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind_set x in t
| Let a::"assg" t::"trm"  bind_set "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind_set x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"

(* can lift *)

thm distinct
thm trm_raw_assg_raw.inducts
thm fv_defs
thm perm_simps
thm perm_laws
thm trm_raw_assg_raw.size(9 - 16)

(* cannot lift yet *)
thm eq_iff
thm eq_iff_simps

ML {*
  val thms_d = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms distinct}
*}

ML {* 
  val thms_i = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw_assg_raw.inducts}
*}

ML {*
  val thms_f = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms fv_defs}
*}

ML {* 
  val thms_i = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw_assg_raw.size(9 - 16)}
*}

ML {*
  val thms_p = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms perm_simps}
*}

ML {*
  val thms_f = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms perm_laws}
*}

ML {*
  Local_Theory.exit_global;
  Class.instantiation;
  Class.prove_instantiation_exit_result;
  Named_Target.theory_init;
  op |->
*}
  
done
|> ...
  |-> (fn x => Class.prove_instantiation_exit_result phi tac x)
  |-> (fn y => ...)



section {* NOT *} 


ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolded alphas prod_fv.simps prod_rel.simps prod_alpha_def]}
*}

ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolding alphas]}
*}


(*
instance trm :: size ..
instance assg :: size ..

lemma "(size (Var x)) = 0"
apply(descending)
apply(rule trm_raw_assg_raw.size(9 - 16))
apply(simp)
*)

ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolding alphas]}
*}


thm perm_defs
thm perm_simps

lemma supp_fv:
  "supp t = fv_trm t"
  "supp b = fv_bn b"
apply(induct t and b rule: i1)
apply(simp_all add: f1)
apply(simp_all add: supp_def)
apply(simp_all add: b1)
sorry

consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}

(* TEMPORARY
thm trm_assg.fv[simplified trm_assg.supp(1-2)]
*)

end



