theory LetRecB
imports "../Nominal2"
begin

atom_decl name

nominal_datatype let_rec:
 trm =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"     bind x in t
| Let_Rec bp::"bp" t::"trm"  bind "bn bp" in bp t
and bp =
  Bp "name" "trm"
binder
  bn::"bp \<Rightarrow> atom list"
where
  "bn (Bp x t) = [atom x]"

thm let_rec.distinct
thm let_rec.induct
thm let_rec.exhaust
thm let_rec.fv_defs
thm let_rec.bn_defs
thm let_rec.perm_simps
thm let_rec.eq_iff
thm let_rec.fv_bn_eqvt
thm let_rec.size_eqvt


lemma Abs_lst_fcb2:
  fixes as bs :: "'a :: fs"
    and x y :: "'b :: fs"
    and c::"'c::fs"
  assumes eq: "[ba as]lst. x = [ba bs]lst. y"
  and fcb1: "(set (ba as)) \<sharp>* f as x c"
  and fresh1: "set (ba as) \<sharp>* c"
  and fresh2: "set (ba bs) \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f as x c) = f (p \<bullet> as) (p \<bullet> x) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f bs y c) = f (p \<bullet> bs) (p \<bullet> y) c"
  and props: "eqvt ba" "inj ba"
  shows "f as x c = f bs y c"
proof -
  have "supp (as, x, c) supports (f as x c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm1 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin1: "finite (supp (f as x c))"
    by (auto intro: supports_finite simp add: finite_supp)
  have "supp (bs, y, c) supports (f bs y c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm2 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin2: "finite (supp (f bs y c))"
    by (auto intro: supports_finite simp add: finite_supp)
  obtain q::"perm" where 
    fr1: "(q \<bullet> (set (ba as))) \<sharp>* (x, c, f as x c, f bs y c)" and 
    fr2: "supp q \<sharp>* ([ba as]lst. x)" and 
    inc: "supp q \<subseteq> (set (ba as)) \<union> q \<bullet> (set (ba as))"
    using at_set_avoiding3[where xs="set (ba as)" and c="(x, c, f as x c, f bs y c)" and x="[ba as]lst. x"]  
      fin1 fin2
    by (auto simp add: supp_Pair finite_supp Abs_fresh_star dest: fresh_star_supp_conv)
  have "[q \<bullet> (ba as)]lst. (q \<bullet> x) = q \<bullet> ([ba as]lst. x)" by simp
  also have "\<dots> = [ba as]lst. x"
    by (simp only: fr2 perm_supp_eq)
  finally have "[q \<bullet> (ba as)]lst. (q \<bullet> x) = [ba bs]lst. y" using eq by simp
  then obtain r::perm where 
    qq1: "q \<bullet> x = r \<bullet> y" and 
    qq2: "q \<bullet> (ba as) = r \<bullet> (ba bs)" and 
    qq3: "supp r \<subseteq> (q \<bullet> (set (ba as))) \<union> set (ba bs)"
    apply(drule_tac sym)
    apply(simp only: Abs_eq_iff2 alphas)
    apply(erule exE)
    apply(erule conjE)+
    apply(drule_tac x="p" in meta_spec)
    apply(simp add: set_eqvt)
    apply(blast)
    done
  have qq4: "q \<bullet> as = r \<bullet> bs" using qq2 props unfolding eqvt_def inj_on_def
    apply(perm_simp)
    apply(simp)
    done
  have "(set (ba as)) \<sharp>* f as x c" by (rule fcb1)
  then have "q \<bullet> ((set (ba as)) \<sharp>* f as x c)"
    by (simp add: permute_bool_def)
  then have "set (q \<bullet> (ba as)) \<sharp>* f (q \<bullet> as) (q \<bullet> x) c"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm1)
    using inc fresh1 fr1
    apply(auto simp add: fresh_star_def fresh_Pair)
    done
  then have "set (r \<bullet> (ba bs)) \<sharp>* f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq2 qq4
    by simp
  then have "r \<bullet> ((set (ba bs)) \<sharp>* f bs y c)"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm2[symmetric])
    using qq3 fresh2 fr1
    apply(auto simp add: set_eqvt fresh_star_def fresh_Pair)
    done
  then have fcb2: "(set (ba bs)) \<sharp>* f bs y c" by (simp add: permute_bool_def)
  have "f as x c = q \<bullet> (f as x c)"
    apply(rule perm_supp_eq[symmetric])
    using inc fcb1 fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (q \<bullet> as) (q \<bullet> x) c" 
    apply(rule perm1)
    using inc fresh1 fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq4 by simp
  also have "\<dots> = r \<bullet> (f bs y c)"
    apply(rule perm2[symmetric])
    using qq3 fresh2 fr1 by (auto simp add: fresh_star_def)
  also have "... = f bs y c"
    apply(rule perm_supp_eq)
    using qq3 fr1 fcb2 by (auto simp add: fresh_star_def)
  finally show ?thesis by simp
qed


lemma max_eqvt[eqvt]: "p \<bullet> (max (a :: _ :: pure) b) = max (p \<bullet> a) (p \<bullet> b)"
  by (simp add: permute_pure)

nominal_primrec
    height_trm :: "trm \<Rightarrow> nat"
and height_bp :: "bp \<Rightarrow> nat"
where
  "height_trm (Var x) = 1"
| "height_trm (App l r) = max (height_trm l) (height_trm r)"
| "height_trm (Lam v b) = 1 + (height_trm b)"
| "height_trm (Let_Rec bp b) = max (height_bp bp) (height_trm b)"
| "height_bp (Bp v t) = height_trm t"
  --"eqvt"
  apply (simp only: eqvt_def height_trm_height_bp_graph_def)
  apply (rule, perm_simp, rule, rule TrueI)
  --"completeness"
  apply (case_tac x)
  apply (case_tac a rule: let_rec.exhaust(1))
  apply (auto)[4]
  apply (case_tac b rule: let_rec.exhaust(2))
  apply blast
  apply(simp_all)
  apply (erule_tac c="()" in Abs_lst_fcb2)
  apply (simp_all add: fresh_star_def pure_fresh)[3]
  apply (simp add: eqvt_at_def)
  apply (simp add: eqvt_at_def)
  apply(simp add: eqvt_def)
  apply(perm_simp)
  apply(simp)
  apply(simp add: inj_on_def)
  --"The following could be done by nominal"
  apply (simp add: meta_eq_to_obj_eq[OF height_trm_def, symmetric, unfolded fun_eq_iff])
  apply (simp add: meta_eq_to_obj_eq[OF height_bp_def, symmetric, unfolded fun_eq_iff])
  apply (subgoal_tac "eqvt_at height_bp bp")
  apply (subgoal_tac "eqvt_at height_bp bpa")
  apply (subgoal_tac "eqvt_at height_trm b")
  apply (subgoal_tac "eqvt_at height_trm ba")
  apply (thin_tac "eqvt_at height_trm_height_bp_sumC (Inr bp)")
  apply (thin_tac "eqvt_at height_trm_height_bp_sumC (Inr bpa)")
  apply (thin_tac "eqvt_at height_trm_height_bp_sumC (Inl b)")
  apply (thin_tac "eqvt_at height_trm_height_bp_sumC (Inl ba)")
  defer
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_bp_def)
  apply (simp add: eqvt_at_def height_bp_def)
  apply (subgoal_tac "height_bp bp = height_bp bpa")
  apply (subgoal_tac "height_trm b = height_trm ba")
  apply simp
  apply (subgoal_tac "(\<lambda>as x c. height_trm (snd (bp, b))) as x c = (\<lambda>as x c. height_trm (snd (bpa, ba))) as x c")
  apply simp
  apply (erule_tac c="()" in Abs_lst_fcb2)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: eqvt_at_def)
  apply (simp add: eqvt_at_def)
  defer defer
  apply (subgoal_tac "(\<lambda>as x c. height_bp (fst (bp, b))) as x c = (\<lambda>as x c. height_bp (fst (bpa, ba))) as x c")
  apply simp
  apply (erule_tac c="()" in Abs_lst_fcb2)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: fresh_star_def pure_fresh)
  apply (simp add: eqvt_at_def)
  apply (simp add: eqvt_at_def)
--""
  apply(simp_all add: eqvt_def inj_on_def)
  apply(perm_simp)
  apply(simp)
  apply(perm_simp)
  apply(simp)
  done

termination by lexicographic_order

end



