theory QuotSum
imports QuotMain
begin

fun
  sum_rel
where
  "sum_rel R1 R2 (Inl a1) (Inl b1) = R1 a1 b1"
| "sum_rel R1 R2 (Inl a1) (Inr b2) = False"
| "sum_rel R1 R2 (Inr a2) (Inl b1) = False"
| "sum_rel R1 R2 (Inr a2) (Inr b2) = R2 a2 b2"

fun
  sum_map
where
  "sum_map f1 f2 (Inl a) = Inl (f1 a)"
| "sum_map f1 f2 (Inr a) = Inr (f2 a)"

declare [[map "+" = (sum_map, sum_rel)]]


lemma sum_equivp[quot_equiv]:
  assumes a: "equivp R1"
  assumes b: "equivp R2"
  shows "equivp (sum_rel R1 R2)"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(auto)
  apply(case_tac [!] x)
  apply(simp_all add: equivp_reflp[OF a] equivp_reflp[OF b])
  apply(case_tac [!] y)
  apply(simp_all add: equivp_symp[OF a] equivp_symp[OF b])
  apply(case_tac [!] z)
  apply(simp_all)
  apply(rule equivp_transp[OF a])
  apply(assumption)+
  apply(rule equivp_transp[OF b])
  apply(assumption)+
  done

(*
lemma sum_fun_fun:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows  "sum_rel R1 R2 r s =
          (sum_rel R1 R2 r r \<and> sum_rel R1 R2 s s \<and> sum_map Abs1 Abs2 r = sum_map Abs1 Abs2 s)"
  using q1 q2
  apply(case_tac r)
  apply(case_tac s)
  apply(simp_all)
  prefer 2
  apply(case_tac s)
  apply(auto)
  unfolding Quotient_def 
  apply metis+
  done
*)

lemma sum_quotient[quot_thm]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "Quotient (sum_rel R1 R2) (sum_map Abs1 Abs2) (sum_map Rep1 Rep2)"
  unfolding Quotient_def
  apply(auto)
  apply(case_tac a)
  apply(simp_all add: Quotient_abs_rep[OF q1] Quotient_rel_rep[OF q1]
                      Quotient_abs_rep[OF q2] Quotient_rel_rep[OF q2])
  apply(case_tac a)
  apply(simp_all add: Quotient_abs_rep[OF q1] Quotient_rel_rep[OF q1]
                      Quotient_abs_rep[OF q2] Quotient_rel_rep[OF q2])
  apply(case_tac [!] r)
  apply(case_tac [!] s)
  apply(simp_all)
  using q1 q2
  unfolding Quotient_def
  apply(blast)+
  done

lemma sum_map_id[id_simps]:
  shows "sum_map id id = id"
  apply (rule ext)
  apply (case_tac x)
  apply (auto)
  done

lemma sum_rel_eq[id_simps]:
  "(sum_rel op = op =) = op ="
  apply (rule ext)+
  apply (case_tac x)
  apply auto
  apply (case_tac xa)
  apply auto
  apply (case_tac xa)
  apply auto
  done

end
