theory Lambda
imports "../NewParser"
begin

atom_decl name

nominal_datatype lam =
  Var "name"
| App "lam" "lam"
| Lam x::"name" l::"lam"  bind_set x in l

thm lam.fv
thm lam.supp
lemmas supp_fn' = lam.fv[simplified lam.supp]

declare lam.perm[eqvt]

declare permute_lam_raw.simps[eqvt]
declare alpha_gen_eqvt[eqvt]
equivariance alpha_lam_raw

section {* Strong Induction Principles*}

(*
  Old way of establishing strong induction
  principles by chosing a fresh name.
*)
lemma
  fixes c::"'a::fs"
  assumes a1: "\<And>name c. P c (Var name)"
  and     a2: "\<And>lam1 lam2 c. \<lbrakk>\<And>d. P d lam1; \<And>d. P d lam2\<rbrakk> \<Longrightarrow> P c (App lam1 lam2)"
  and     a3: "\<And>name lam c. \<lbrakk>atom name \<sharp> c; \<And>d. P d lam\<rbrakk> \<Longrightarrow> P c (Lam name lam)"
  shows "P c lam"
proof -
  have "\<And>p. P c (p \<bullet> lam)"
    apply(induct lam arbitrary: c rule: lam.induct)
    apply(perm_simp)
    apply(rule a1)
    apply(perm_simp)
    apply(rule a2)
    apply(assumption)
    apply(assumption)
    apply(subgoal_tac "\<exists>new::name. (atom new) \<sharp> (c, Lam (p \<bullet> name) (p \<bullet> lam))")
    defer
    apply(simp add: fresh_def)
    apply(rule_tac X="supp (c, Lam (p \<bullet> name) (p \<bullet> lam))" in obtain_at_base)
    apply(simp add: supp_Pair finite_supp)
    apply(blast)
    apply(erule exE)
    apply(rule_tac t="p \<bullet> Lam name lam" and 
                   s="(((p \<bullet> name) \<leftrightarrow> new) + p) \<bullet> Lam name lam" in subst)
    apply(simp del: lam.perm)
    apply(subst lam.perm)
    apply(subst (2) lam.perm)
    apply(rule flip_fresh_fresh)
    apply(simp add: fresh_def)
    apply(simp only: supp_fn')
    apply(simp)
    apply(simp add: fresh_Pair)
    apply(simp)
    apply(rule a3)
    apply(simp add: fresh_Pair)
    apply(drule_tac x="((p \<bullet> name) \<leftrightarrow> new) + p" in meta_spec)
    apply(simp)
    done
  then have "P c (0 \<bullet> lam)" by blast
  then show "P c lam" by simp
qed

(* 
  New way of establishing strong induction
  principles by using a appropriate permutation.
*)
lemma
  fixes c::"'a::fs"
  assumes a1: "\<And>name c. P c (Var name)"
  and     a2: "\<And>lam1 lam2 c. \<lbrakk>\<And>d. P d lam1; \<And>d. P d lam2\<rbrakk> \<Longrightarrow> P c (App lam1 lam2)"
  and     a3: "\<And>name lam c. \<lbrakk>atom name \<sharp> c; \<And>d. P d lam\<rbrakk> \<Longrightarrow> P c (Lam name lam)"
  shows "P c lam"
proof -
  have "\<And>p. P c (p \<bullet> lam)"
    apply(induct lam arbitrary: c rule: lam.induct)
    apply(perm_simp)
    apply(rule a1)
    apply(perm_simp)
    apply(rule a2)
    apply(assumption)
    apply(assumption)
    apply(subgoal_tac "\<exists>q. (q \<bullet> {p \<bullet> atom name}) \<sharp>* c \<and> supp (p \<bullet> Lam name lam) \<sharp>* q")
    apply(erule exE)
    apply(rule_tac t="p \<bullet> Lam name lam" and 
                   s="q \<bullet> p \<bullet> Lam name lam" in subst)
    defer
    apply(simp)
    apply(rule a3)
    apply(simp add: eqvts fresh_star_def)
    apply(drule_tac x="q + p" in meta_spec)
    apply(simp)
    apply(rule at_set_avoiding2)
    apply(simp add: finite_supp)
    apply(simp add: finite_supp)
    apply(simp add: finite_supp)
    apply(perm_simp)
    apply(simp add: fresh_star_def fresh_def supp_fn')
    apply(rule supp_perm_eq)
    apply(simp)
    done
  then have "P c (0 \<bullet> lam)" by blast
  then show "P c lam" by simp
qed

section {* Typing *}

nominal_datatype ty =
  TVar string
| TFun ty ty

notation
 TFun ("_ \<rightarrow> _") 

declare ty.perm[eqvt]

inductive
  valid :: "(name \<times> ty) list \<Rightarrow> bool"
where
  "valid []"
| "\<lbrakk>atom x \<sharp> Gamma; valid Gamma\<rbrakk> \<Longrightarrow> valid ((x, T)#Gamma)"

inductive
  typing :: "(name\<times>ty) list \<Rightarrow> lam \<Rightarrow> ty \<Rightarrow> bool" ("_ \<turnstile> _ : _" [60,60,60] 60) 
where
    t_Var[intro]: "\<lbrakk>valid \<Gamma>; (x, T) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> Var x : T"
  | t_App[intro]: "\<lbrakk>\<Gamma> \<turnstile> t1 : T1 \<rightarrow> T2; \<Gamma> \<turnstile> t2 : T1\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> App t1 t2 : T2"
  | t_Lam[intro]: "\<lbrakk>atom x \<sharp> \<Gamma>; (x, T1) # \<Gamma> \<turnstile> t : T2\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> Lam x t : T1 \<rightarrow> T2"

equivariance valid
equivariance typing

thm valid.eqvt
thm typing.eqvt
thm eqvts
thm eqvts_raw

thm typing.induct[of "\<Gamma>" "t" "T", no_vars]

lemma
  fixes c::"'a::fs"
  assumes a: "\<Gamma> \<turnstile> t : T" 
  and a1: "\<And>\<Gamma> x T c. \<lbrakk>valid \<Gamma>; (x, T) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> P c \<Gamma> (Var x) T"
  and a2: "\<And>\<Gamma> t1 T1 T2 t2 c. \<lbrakk>\<Gamma> \<turnstile> t1 : T1 \<rightarrow> T2; \<And>d. P d \<Gamma> t1 T1 \<rightarrow> T2; \<Gamma> \<turnstile> t2 : T1; \<And>d. P d \<Gamma> t2 T1\<rbrakk> 
           \<Longrightarrow> P c \<Gamma> (App t1 t2) T2"
  and a3: "\<And>x \<Gamma> T1 t T2 c. \<lbrakk>atom x \<sharp> c; atom x \<sharp> \<Gamma>; (x, T1) # \<Gamma> \<turnstile> t : T2; \<And>d. P d ((x, T1) # \<Gamma>) t T2\<rbrakk> 
           \<Longrightarrow> P c \<Gamma> (Lam x t) T1 \<rightarrow> T2"
  shows "P c \<Gamma> t T"
proof -
  from a have "\<And>p c. P c (p \<bullet> \<Gamma>) (p \<bullet> t) (p \<bullet> T)"
  proof (induct)
    case (t_Var \<Gamma> x T p c)
    then show ?case
      apply -
      apply(perm_strict_simp)
      apply(rule a1)
      apply(drule_tac p="p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(rotate_tac 1)
      apply(drule_tac p="p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      done
  next
    case (t_App \<Gamma> t1 T1 T2 t2 p c)
    then show ?case
      apply -
      apply(perm_strict_simp)
      apply(rule a2)
      apply(drule_tac p="p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(assumption)
      apply(rotate_tac 2)
      apply(drule_tac p="p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(assumption)
      done
  next
    case (t_Lam x \<Gamma> T1 t T2 p c)
    then show ?case
      apply -
      apply(subgoal_tac "\<exists>q. (q \<bullet> {p \<bullet> atom x}) \<sharp>* c \<and> 
        supp (p \<bullet> \<Gamma>, p \<bullet> Lam x t, p \<bullet> (T1 \<rightarrow> T2)) \<sharp>* q")
      apply(erule exE)
      apply(rule_tac t="p \<bullet> \<Gamma>" and  s="(q + p) \<bullet> \<Gamma>" in subst)
      apply(simp only: permute_plus)
      apply(rule supp_perm_eq)
      apply(simp add: supp_Pair fresh_star_union)
      apply(rule_tac t="p \<bullet> Lam x t" and  s="(q + p) \<bullet> Lam x t" in subst)
      apply(simp only: permute_plus)
      apply(rule supp_perm_eq)
      apply(simp add: supp_Pair fresh_star_union)
      apply(rule_tac t="p \<bullet> (T1 \<rightarrow> T2)" and  s="(q + p) \<bullet> (T1 \<rightarrow> T2)" in subst)
      apply(simp only: permute_plus)
      apply(rule supp_perm_eq)
      apply(simp add: supp_Pair fresh_star_union)
      apply(simp (no_asm) only: eqvts)
      apply(rule a3)
      apply(simp only: eqvts permute_plus)
      apply(simp add: fresh_star_def)
      apply(drule_tac p="q + p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(rotate_tac 1)
      apply(drule_tac p="q + p" in permute_boolI)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(drule_tac x="d" in meta_spec)
      apply(drule_tac x="q + p" in meta_spec)
      apply(perm_strict_simp add: permute_minus_cancel)
      apply(assumption)
      apply(rule at_set_avoiding2)
      apply(simp add: finite_supp)
      apply(simp add: finite_supp)
      apply(simp add: finite_supp)
      apply(rule_tac p="-p" in permute_boolE)
      apply(perm_strict_simp add: permute_minus_cancel)
	(* supplied by the user *)
      apply(simp add: fresh_star_prod)
      apply(simp add: fresh_star_def)
      sorry
  qed
  then have "P c (0 \<bullet> \<Gamma>) (0 \<bullet> t) (0 \<bullet> T)" .
  then show "P c \<Gamma> t T" by simp
qed







inductive
  tt :: "('a \<Rightarrow> 'a \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> 'a \<Rightarrow> bool)"  
  for r :: "('a \<Rightarrow> 'a \<Rightarrow> bool)"
where
    aa: "tt r a a"
  | bb: "tt r a b ==> tt r a c"

(* PROBLEM: derived eqvt-theorem does not conform with [eqvt]
equivariance tt
*)


inductive
 alpha_lam_raw'
where
  a1: "name = namea \<Longrightarrow> alpha_lam_raw' (Var_raw name) (Var_raw namea)"
| a2: "\<lbrakk>alpha_lam_raw' lam_raw1 lam_raw1a; alpha_lam_raw' lam_raw2 lam_raw2a\<rbrakk> \<Longrightarrow>
   alpha_lam_raw' (App_raw lam_raw1 lam_raw2) (App_raw lam_raw1a lam_raw2a)"
| a3: "\<exists>pi. ({atom name}, lam_raw) \<approx>gen alpha_lam_raw' fv_lam_raw pi ({atom namea}, lam_rawa) \<Longrightarrow>
   alpha_lam_raw' (Lam_raw name lam_raw) (Lam_raw namea lam_rawa)"

declare permute_lam_raw.simps[eqvt]
declare alpha_gen_eqvt[eqvt]
equivariance alpha_lam_raw'

thm eqvts_raw

section {* size function *}

lemma size_eqvt_raw:
  fixes t::"lam_raw"
  shows "size (pi \<bullet> t)  = size t"
  apply (induct rule: lam_raw.inducts)
  apply simp_all
  done

instantiation lam :: size 
begin

quotient_definition
  "size_lam :: lam \<Rightarrow> nat"
is
  "size :: lam_raw \<Rightarrow> nat"

lemma size_rsp:
  "alpha_lam_raw x y \<Longrightarrow> size x = size y"
  apply (induct rule: alpha_lam_raw.inducts)
  apply (simp_all only: lam_raw.size)
  apply (simp_all only: alphas)
  apply clarify
  apply (simp_all only: size_eqvt_raw)
  done

lemma [quot_respect]:
  "(alpha_lam_raw ===> op =) size size"
  by (simp_all add: size_rsp)

lemma [quot_preserve]:
  "(rep_lam ---> id) size = size"
  by (simp_all add: size_lam_def)

instance
  by default

end

lemmas size_lam[simp] = 
  lam_raw.size(4)[quot_lifted]
  lam_raw.size(5)[quot_lifted]
  lam_raw.size(6)[quot_lifted]

(* is this needed? *)
lemma [measure_function]: 
  "is_measure (size::lam\<Rightarrow>nat)" 
  by (rule is_measure_trivial)

section {* Matching *}

definition
  MATCH :: "('c::pt \<Rightarrow> (bool * 'a::pt * 'b::pt)) \<Rightarrow> 'b \<Rightarrow> 'a \<Rightarrow> 'b"
where
  "MATCH M d x \<equiv> if (\<exists>!r. \<exists>q. M q = (True, x, r)) then (THE r. \<exists>q. M q = (True, x, r)) else d"

(*
lemma MATCH_eqvt:
  shows "p \<bullet> (MATCH M d x) = MATCH (p \<bullet> M) (p \<bullet> d) (p \<bullet> x)"
unfolding MATCH_def
apply(perm_simp the_eqvt)
apply (tactic {* Nominal_Permeq.eqvt_tac @{context} 1 *})
apply(simp)
thm eqvts_raw 
apply(subst if_eqvt)
apply(subst ex1_eqvt)
apply(subst permute_fun_def)
apply(subst ex_eqvt)
apply(subst permute_fun_def)
apply(subst eq_eqvt)
apply(subst permute_fun_app_eq[where f="M"])
apply(simp only: permute_minus_cancel)
apply(subst permute_prod.simps)
apply(subst permute_prod.simps)
apply(simp only: permute_minus_cancel)
apply(simp only: permute_bool_def)
apply(simp)
apply(subst ex1_eqvt)
apply(subst permute_fun_def)
apply(subst ex_eqvt)
apply(subst permute_fun_def)
apply(subst eq_eqvt)

apply(simp only: eqvts)
apply(simp)
apply(subgoal_tac "(p \<bullet> (\<exists>!r. \<exists>q. M q = (True, x, r))) = (\<exists>!r. \<exists>q. (p \<bullet> M) q = (True, p \<bullet> x, r))")
apply(drule sym)
apply(simp)
apply(rule impI)
apply(simp add: perm_bool)
apply(rule trans)
apply(rule pt_the_eqvt[OF pta at])
apply(assumption)
apply(simp add: pt_ex_eqvt[OF pt at])
apply(simp add: pt_eq_eqvt[OF ptb at])
apply(rule cheat)
apply(rule trans)
apply(rule pt_ex1_eqvt)
apply(rule pta)
apply(rule at)
apply(simp add: pt_ex_eqvt[OF pt at])
apply(simp add: pt_eq_eqvt[OF ptb at])
apply(subst pt_pi_rev[OF pta at])
apply(subst pt_fun_app_eq[OF pt at])
apply(subst pt_pi_rev[OF pt at])
apply(simp)
done

lemma MATCH_cng:
  assumes a: "M1 = M2" "d1 = d2"
  shows "MATCH M1 d1 x = MATCH M2 d2 x"
using a by simp

lemma MATCH_eq:
  assumes a: "t = l x" "G x" "\<And>x'. t = l x' \<Longrightarrow> G x' \<Longrightarrow> r x' = r x"
  shows "MATCH (\<lambda>x. (G x, l x, r x)) d t = r x"
using a
unfolding MATCH_def
apply(subst if_P)
apply(rule_tac a="r x" in ex1I)
apply(rule_tac x="x" in exI)
apply(blast)
apply(erule exE)
apply(drule_tac x="q" in meta_spec)
apply(auto)[1]
apply(rule the_equality)
apply(blast)
apply(erule exE)
apply(drule_tac x="q" in meta_spec)
apply(auto)[1]
done

lemma MATCH_eq2:
  assumes a: "t = l x1 x2" "G x1 x2" "\<And>x1' x2'. t = l x1' x2' \<Longrightarrow> G x1' x2' \<Longrightarrow> r x1' x2' = r x1 x2"
  shows "MATCH (\<lambda>(x1,x2). (G x1 x2, l x1 x2, r x1 x2)) d t = r x1 x2"
sorry

lemma MATCH_neq:
  assumes a: "\<And>x. t = l x \<Longrightarrow> G x \<Longrightarrow> False"
  shows "MATCH (\<lambda>x. (G x, l x, r x)) d t = d"
using a
unfolding MATCH_def
apply(subst if_not_P)
apply(blast)
apply(rule refl)
done

lemma MATCH_neq2:
  assumes a: "\<And>x1 x2. t = l x1 x2 \<Longrightarrow> G x1 x2 \<Longrightarrow> False"
  shows "MATCH (\<lambda>(x1,x2). (G x1 x2, l x1 x2, r x1 x2)) d t = d"
using a
unfolding MATCH_def
apply(subst if_not_P)
apply(auto)
done
*)

ML {*
fun mk_avoids ctxt params name set =
  let
    val (_, ctxt') = ProofContext.add_fixes
      (map (fn (s, T) => (Binding.name s, SOME T, NoSyn)) params) ctxt;
    fun mk s =
      let
        val t = Syntax.read_term ctxt' s;
        val t' = list_abs_free (params, t) |>
          funpow (length params) (fn Abs (_, _, t) => t)
      in (t', HOLogic.dest_setT (fastype_of t)) end
      handle TERM _ =>
        error ("Expression " ^ quote s ^ " to be avoided in case " ^
          quote name ^ " is not a set type");
    fun add_set p [] = [p]
      | add_set (t, T) ((u, U) :: ps) =
          if T = U then
            let val S = HOLogic.mk_setT T
            in (Const (@{const_name sup}, S --> S --> S) $ u $ t, T) :: ps
            end
          else (u, U) :: add_set (t, T) ps
  in
    (mk #> add_set) set 
  end;
*}


ML {* 
  writeln (commas (map (Syntax.string_of_term @{context} o fst) 
    (mk_avoids @{context} [] "t_Var" "{x}" []))) 
*}


ML {*

fun prove_strong_ind (pred_name, avoids) ctxt = 
  Proof.theorem NONE (K I) [] ctxt

local structure P = OuterParse and K = OuterKeyword in

val _ =
  OuterSyntax.local_theory_to_proof "nominal_inductive"
    "proves strong induction theorem for inductive predicate involving nominal datatypes" K.thy_goal
      (P.xname -- (Scan.optional (P.$$$ "avoids" |-- P.enum1 "|" (P.name --
        (P.$$$ ":" |-- P.and_list1 P.term))) []) >>  prove_strong_ind)

end;

*}

(*
nominal_inductive typing
*)


end



