theory NewParser
imports "../Nominal-General/Nominal2_Base" 
        "../Nominal-General/Nominal2_Eqvt" 
        "../Nominal-General/Nominal2_Supp" 
        "Perm" "NewFv" "NewAlpha" "Tacs" "Equivp" "Lift"
begin

section{* Interface for nominal_datatype *}


ML {* 
(* nominal datatype parser *)
local
  structure P = OuterParse;
  structure S = Scan

  fun triple1 ((x, y), z) = (x, y, z)
  fun triple2 (x, (y, z)) = (x, y, z)
  fun tuple ((x, y, z), u) = (x, y, z, u)
  fun tswap (((x, y), z), u) = (x, y, u, z)
in

val _ = OuterKeyword.keyword "bind"
val _ = OuterKeyword.keyword "bind_set"
val _ = OuterKeyword.keyword "bind_res"

val anno_typ = S.option (P.name --| P.$$$ "::") -- P.typ

val bind_mode = P.$$$ "bind" || P.$$$ "bind_set" || P.$$$ "bind_res"

val bind_clauses = 
  P.enum "," (bind_mode -- S.repeat1 P.term -- (P.$$$ "in" |-- S.repeat1 P.name) >> triple1)

val cnstr_parser =
  P.binding -- S.repeat anno_typ -- bind_clauses -- P.opt_mixfix >> tswap

(* datatype parser *)
val dt_parser =
  (P.type_args -- P.binding -- P.opt_mixfix >> triple1) -- 
    (P.$$$ "=" |-- P.enum1 "|" cnstr_parser) >> tuple

(* binding function parser *)
val bnfun_parser = 
  S.optional (P.$$$ "binder" |-- P.fixes -- SpecParse.where_alt_specs) ([], [])

(* main parser *)
val main_parser =
  P.and_list1 dt_parser -- bnfun_parser >> triple2

end
*}

ML {*
fun get_cnstrs dts =
  map (fn (_, _, _, constrs) => constrs) dts

fun get_typed_cnstrs dts =
  flat (map (fn (_, bn, _, constrs) => 
   (map (fn (bn', _, _) => (Binding.name_of bn, Binding.name_of bn')) constrs)) dts)

fun get_cnstr_strs dts =
  map (fn (bn, _, _) => Binding.name_of bn) (flat (get_cnstrs dts))

fun get_bn_fun_strs bn_funs =
  map (fn (bn_fun, _, _) => Binding.name_of bn_fun) bn_funs
*}

ML {* 
fun add_primrec_wrapper funs eqs lthy = 
  if null funs then (([], []), lthy)
  else 
   let 
     val eqs' = map (fn (_, eq) => (Attrib.empty_binding, eq)) eqs
     val funs' = map (fn (bn, ty, mx) => (bn, SOME ty, mx)) funs
   in 
     Primrec.add_primrec funs' eqs' lthy
   end
*}

ML {*
fun add_datatype_wrapper dt_names dts =
let
  val conf = Datatype.default_config
in
  Local_Theory.theory_result (Datatype.add_datatype conf dt_names dts)
end
*}


text {* Infrastructure for adding "_raw" to types and terms *}

ML {*
fun add_raw s = s ^ "_raw"
fun add_raws ss = map add_raw ss
fun raw_bind bn = Binding.suffix_name "_raw" bn

fun replace_str ss s = 
  case (AList.lookup (op=) ss s) of 
     SOME s' => s'
   | NONE => s

fun replace_typ ty_ss (Type (a, Ts)) = Type (replace_str ty_ss a, map (replace_typ ty_ss) Ts)
  | replace_typ ty_ss T = T  

fun raw_dts ty_ss dts =
let
  fun raw_dts_aux1 (bind, tys, mx) =
    (raw_bind bind, map (replace_typ ty_ss) tys, mx)

  fun raw_dts_aux2 (ty_args, bind, mx, constrs) =
    (ty_args, raw_bind bind, mx, map raw_dts_aux1 constrs)
in
  map raw_dts_aux2 dts
end

fun replace_aterm trm_ss (Const (a, T)) = Const (replace_str trm_ss a, T)
  | replace_aterm trm_ss (Free (a, T)) = Free (replace_str trm_ss a, T)
  | replace_aterm trm_ss trm = trm

fun replace_term trm_ss ty_ss trm =
  trm |> Term.map_aterms (replace_aterm trm_ss) |> map_types (replace_typ ty_ss) 
*}

ML {*
fun rawify_dts dt_names dts dts_env =
let
  val raw_dts = raw_dts dts_env dts
  val raw_dt_names = add_raws dt_names
in
  (raw_dt_names, raw_dts)
end 
*}

ML {*
fun rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs =
let
  val bn_funs' = map (fn (bn, ty, mx) => 
    (raw_bind bn, replace_typ dts_env ty, mx)) bn_funs
  
  val bn_eqs' = map (fn (attr, trm) => 
    (attr, replace_term (cnstrs_env @ bn_fun_env) dts_env trm)) bn_eqs
in
  (bn_funs', bn_eqs') 
end 
*}

ML {* 
fun rawify_bclauses dts_env cnstrs_env bn_fun_env bclauses =
let
  fun rawify_bnds bnds = 
    map (apfst (Option.map (replace_term (cnstrs_env @ bn_fun_env) dts_env))) bnds

  fun rawify_bclause (BEmy n) = BEmy n
    | rawify_bclause (BLst (bnds, bdys)) = BLst (rawify_bnds bnds, bdys)
    | rawify_bclause (BSet (bnds, bdys)) = BSet (rawify_bnds bnds, bdys)
    | rawify_bclause (BRes (bnds, bdys)) = BRes (rawify_bnds bnds, bdys)
in
  map (map (map rawify_bclause)) bclauses
end
*}

(* strip_bn_fun takes a bn function defined by the user as a union or
   append of elements and returns those elements together with bn functions
   applied *)
ML {*
fun strip_bn_fun t =
  case t of
    Const (@{const_name sup}, _) $ l $ r => strip_bn_fun l @ strip_bn_fun r
  | Const (@{const_name append}, _) $ l $ r => strip_bn_fun l @ strip_bn_fun r
  | Const (@{const_name insert}, _) $ (Const (@{const_name atom}, _) $ Bound i) $ y =>
      (i, NONE) :: strip_bn_fun y
  | Const (@{const_name Cons}, _) $ (Const (@{const_name atom}, _) $ Bound i) $ y =>
      (i, NONE) :: strip_bn_fun y
  | Const (@{const_name bot}, _) => []
  | Const (@{const_name Nil}, _) => []
  | (f as Free _) $ Bound i => [(i, SOME f)]
  | _ => error ("Unsupported binding function: " ^ (PolyML.makestring t))
*}

ML {*
fun find [] _ = error ("cannot find element")
  | find ((x, z)::xs) y = if (Long_Name.base_name x) = y then z else find xs y
*}

ML {*
fun prep_bn dt_names dts eqs = 
let
  fun aux eq = 
  let
    val (lhs, rhs) = eq
      |> strip_qnt_body "all" 
      |> HOLogic.dest_Trueprop
      |> HOLogic.dest_eq
    val (bn_fun, [cnstr]) = strip_comb lhs
    val (_, ty) = dest_Free bn_fun
    val (ty_name, _) = dest_Type (domain_type ty)
    val dt_index = find_index (fn x => x = ty_name) dt_names
    val (cnstr_head, cnstr_args) = strip_comb cnstr
    val rhs_elements = strip_bn_fun rhs
    val included = map (apfst (fn i => length (cnstr_args) - i - 1)) rhs_elements
  in
    (dt_index, (bn_fun, (cnstr_head, included)))
  end 
  fun order dts i ts = 
  let
    val dt = nth dts i
    val cts = map (fn (x, _, _) => Binding.name_of x) ((fn (_, _, _, x) => x) dt)
    val ts' = map (fn (x, y) => (fst (dest_Const x), y)) ts
  in
    map (find ts') cts
  end

  val unordered = AList.group (op=) (map aux eqs)
  val unordered' = map (fn (x, y) =>  (x, AList.group (op=) y)) unordered
  val ordered = map (fn (x, y) => (x, map (fn (v, z) => (v, order dts x z)) y)) unordered' 
in
  ordered
end
*}


ML {*
fun raw_nominal_decls dts bn_funs bn_eqs binds lthy =
let
  val thy = ProofContext.theory_of lthy
  val thy_name = Context.theory_name thy

  val dt_names = map (fn (_, s, _, _) => Binding.name_of s) dts
  val dt_full_names = map (Long_Name.qualify thy_name) dt_names 
  val dt_full_names' = add_raws dt_full_names
  val dts_env = dt_full_names ~~ dt_full_names'

  val cnstrs = get_cnstr_strs dts
  val cnstrs_ty = get_typed_cnstrs dts
  val cnstrs_full_names = map (Long_Name.qualify thy_name) cnstrs
  val cnstrs_full_names' = map (fn (x, y) => Long_Name.qualify thy_name 
    (Long_Name.qualify (add_raw x) (add_raw y))) cnstrs_ty
  val cnstrs_env = cnstrs_full_names ~~ cnstrs_full_names'

  val bn_fun_strs = get_bn_fun_strs bn_funs
  val bn_fun_strs' = add_raws bn_fun_strs
  val bn_fun_env = bn_fun_strs ~~ bn_fun_strs'
  val bn_fun_full_env = map (pairself (Long_Name.qualify thy_name)) 
    (bn_fun_strs ~~ bn_fun_strs')
  
  val (raw_dt_names, raw_dts) = rawify_dts dt_names dts dts_env

  val (raw_bn_funs, raw_bn_eqs) = rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs 
   
  val raw_bclauses = rawify_bclauses dts_env cnstrs_env bn_fun_full_env binds 

  val raw_bns = prep_bn dt_full_names' raw_dts (map snd raw_bn_eqs)
in
  lthy 
  |> add_datatype_wrapper raw_dt_names raw_dts 
  ||>> add_primrec_wrapper raw_bn_funs raw_bn_eqs
  ||>> pair raw_bclauses
  ||>> pair raw_bns
end
*}

lemma equivp_hack: "equivp x"
sorry
ML {*
fun equivp_hack ctxt rel =
let
  val thy = ProofContext.theory_of ctxt
  val ty = domain_type (fastype_of rel)
  val cty = ctyp_of thy ty
  val ct = cterm_of thy rel
in
  Drule.instantiate' [SOME cty] [SOME ct] @{thm equivp_hack}
end
*}

ML {* val cheat_alpha_eqvt = Unsynchronized.ref false *}
ML {* val cheat_equivp = Unsynchronized.ref false *}
ML {* val cheat_fv_rsp = Unsynchronized.ref false *}
ML {* val cheat_alpha_bn_rsp = Unsynchronized.ref false *}
ML {* val cheat_supp_eq = Unsynchronized.ref false *}

ML {*
fun remove_loop t =
  let val _ = HOLogic.dest_eq (HOLogic.dest_Trueprop (prop_of t)) in t end
  handle TERM _ => @{thm eqTrueI} OF [t]
*}

text {* 
  nominal_datatype2 does the following things in order:

Parser.thy/raw_nominal_decls
  1) define the raw datatype
  2) define the raw binding functions 

Perm.thy/define_raw_perms
  3) define permutations of the raw datatype and show that the raw type is 
     in the pt typeclass
      
Lift.thy/define_fv_alpha_export, Fv.thy/define_fv & define_alpha
  4) define fv and fv_bn
  5) define alpha and alpha_bn

Perm.thy/distinct_rel
  6) prove alpha_distincts (C1 x \<notsimeq> C2 y ...)             (Proof by cases; simp)

Tacs.thy/build_rel_inj
  6) prove alpha_eq_iff    (C1 x = C2 y \<leftrightarrow> P x y ...)
     (left-to-right by intro rule, right-to-left by cases; simp)
Equivp.thy/prove_eqvt
  7) prove bn_eqvt (common induction on the raw datatype)
  8) prove fv_eqvt (common induction on the raw datatype with help of above)
Rsp.thy/build_alpha_eqvts
  9) prove alpha_eqvt and alpha_bn_eqvt
     (common alpha-induction, unfolding alpha_gen, permute of #* and =)
Equivp.thy/build_alpha_refl & Equivp.thy/build_equivps
 10) prove that alpha and alpha_bn are equivalence relations
     (common induction and application of 'compose' lemmas)
Lift.thy/define_quotient_types
 11) define quotient types
Rsp.thy/build_fvbv_rsps
 12) prove bn respects     (common induction and simp with alpha_gen)
Rsp.thy/prove_const_rsp
 13) prove fv respects     (common induction and simp with alpha_gen)
 14) prove permute respects    (unfolds to alpha_eqvt)
Rsp.thy/prove_alpha_bn_rsp
 15) prove alpha_bn respects
     (alpha_induct then cases then sym and trans of the relations)
Rsp.thy/prove_alpha_alphabn
 16) show that alpha implies alpha_bn (by unduction, needed in following step)
Rsp.thy/prove_const_rsp
 17) prove respects for all datatype constructors
     (unfold eq_iff and alpha_gen; introduce zero permutations; simp)
Perm.thy/quotient_lift_consts_export
 18) define lifted constructors, fv, bn, alpha_bn, permutations
Perm.thy/define_lifted_perms
 19) lift permutation zero and add properties to show that quotient type is in the pt typeclass
Lift.thy/lift_thm
 20) lift permutation simplifications
 21) lift induction
 22) lift fv
 23) lift bn
 24) lift eq_iff
 25) lift alpha_distincts
 26) lift fv and bn eqvts
Equivp.thy/prove_supports
 27) prove that union of arguments supports constructors
Equivp.thy/prove_fs
 28) show that the lifted type is in fs typeclass     (* by q_induct, supports *)
Equivp.thy/supp_eq
 29) prove supp = fv
*}


ML {*
fun nominal_datatype2 dts bn_funs bn_eqs bclauses lthy =
let
  (* definition of the raw datatype and raw bn-functions *)
  val ((((raw_dt_names, (raw_bn_funs_loc, raw_bn_eqs_loc)), raw_bclauses), raw_bns), lthy1) =
    raw_nominal_decls dts bn_funs bn_eqs bclauses lthy

  val dtinfo = Datatype.the_info (ProofContext.theory_of lthy1) (hd raw_dt_names);
  val {descr, sorts, ...} = dtinfo;
  val raw_tys = map (fn (i, _) => nth_dtyp descr sorts i) descr;
  val all_typs = map (fn i => Datatype_Aux.typ_of_dtyp descr sorts (Datatype_Aux.DtRec i)) (map fst descr)

  val all_full_tnames = map (fn (_, (n, _, _)) => n) descr;
  val dtinfos = map (Datatype.the_info (ProofContext.theory_of lthy1)) all_full_tnames;
  val inject = flat (map #inject dtinfos);
  val distincts = flat (map #distinct dtinfos);
  val rel_dtinfos = List.take (dtinfos, (length dts));
  val rel_distinct = map #distinct rel_dtinfos;
  val induct = #induct dtinfo;
  val exhausts = map #exhaust dtinfos;

  (* definitions of raw permutations *)
  val ((raw_perm_def, raw_perm_simps, perms), lthy2) =
    Local_Theory.theory_result (define_raw_perms dtinfo (length dts)) lthy1;

  val morphism_2_0 = ProofContext.export_morphism lthy2 lthy
  fun export_fun f (t, l) = (f t, map (map (apsnd (Option.map f))) l);
  val raw_bns_exp = map (apsnd (map (export_fun (Morphism.term morphism_2_0)))) raw_bns;
  val bn_funs_decls = flat (map (fn (ith, l) => map (fn (bn, data) => (bn, ith, data)) l) raw_bns_exp);
  val raw_bn_eqs = ProofContext.export lthy2 lthy raw_bn_eqs_loc
  val thy = Local_Theory.exit_global lthy2;
  val thy_name = Context.theory_name thy

  val lthy3 = Theory_Target.init NONE thy;
  val raw_bn_funs = map (fn (f, _, _) => f) bn_funs_decls;

  (* definition of raw fv_functions *)
  val ((fv, fvbn), fv_def, lthy3a) = define_raw_fv dtinfo bn_funs_decls raw_bclauses lthy3;
  
  (* definition of raw alphas *)
  val (((alpha_ts, alpha_intros), (alpha_cases, alpha_induct)), lthy4) =
    define_raw_alpha dtinfo bn_funs_decls raw_bclauses fv lthy3a;
  val (alpha_ts_nobn, alpha_ts_bn) = chop (length fv) alpha_ts
  
  val dts_names = map (fn (i, (s, _, _)) => (s, i)) (#descr dtinfo);
  val bn_tys = map (domain_type o fastype_of) raw_bn_funs;
  val bn_nos = map (dtyp_no_of_typ dts_names) bn_tys;
  val bns = raw_bn_funs ~~ bn_nos;
  val rel_dists = flat (map (distinct_rel lthy4 alpha_cases)
    (rel_distinct ~~ alpha_ts_nobn));
  val rel_dists_bn = flat (map (distinct_rel lthy4 alpha_cases)
    ((map (fn i => nth rel_distinct i) bn_nos) ~~ alpha_ts_bn))
  
  (* definition of raw_alpha_eq_iff  lemmas *)
  val alpha_eq_iff = build_rel_inj alpha_intros (inject @ distincts) alpha_cases lthy4
  val alpha_eq_iff_simp = map remove_loop alpha_eq_iff;
  val _ = map tracing (map PolyML.makestring alpha_eq_iff_simp);

  (* proving equivariance lemmas *)
  val _ = warning "Proving equivariance";
  val (bv_eqvt, lthy5) = prove_eqvt raw_tys induct (raw_bn_eqs @ raw_perm_def) (map fst bns) lthy4
  val (fv_eqvt, lthy6) = prove_eqvt raw_tys induct (fv_def @ raw_perm_def) (fv @ fvbn) lthy5
  fun alpha_eqvt_tac' _ =
    if !cheat_alpha_eqvt then Skip_Proof.cheat_tac thy
    else alpha_eqvt_tac alpha_induct (raw_perm_def @ alpha_eq_iff_simp) lthy6 1
  val alpha_eqvt = build_alpha_eqvts alpha_ts alpha_eqvt_tac' lthy6;

  (* provind alpha equivalence *)
  val _ = warning "Proving equivalence";
  val fv_alpha_all = combine_fv_alpha_bns (fv, fvbn) (alpha_ts_nobn, alpha_ts_bn) bn_nos;
  val reflps = build_alpha_refl fv_alpha_all alpha_ts induct alpha_eq_iff_simp lthy6;
  val alpha_equivp =
    if !cheat_equivp then map (equivp_hack lthy6) alpha_ts
    else build_equivps alpha_ts reflps alpha_induct
      inject alpha_eq_iff_simp distincts alpha_cases alpha_eqvt lthy6;
  val qty_binds = map (fn (_, b, _, _) => b) dts;
  val qty_names = map Name.of_binding qty_binds;
  val qty_full_names = map (Long_Name.qualify thy_name) qty_names
  val (qtys, lthy7) = define_quotient_types qty_binds all_typs alpha_ts_nobn alpha_equivp lthy6;
  val const_names = map Name.of_binding (flat (map (fn (_, _, _, t) => map (fn (b, _, _) => b) t) dts));
  val raw_consts =
    flat (map (fn (i, (_, _, l)) =>
      map (fn (cname, dts) =>
        Const (cname, map (Datatype_Aux.typ_of_dtyp descr sorts) dts --->
          Datatype_Aux.typ_of_dtyp descr sorts (Datatype_Aux.DtRec i))) l) descr);
  val (consts, const_defs, lthy8) = quotient_lift_consts_export qtys (const_names ~~ raw_consts) lthy7;
  val _ = warning "Proving respects";
  val bns_rsp_pre' = build_fvbv_rsps alpha_ts alpha_induct raw_bn_eqs (map fst bns) lthy8;
  val (bns_rsp_pre, lthy9) = fold_map (
    fn (bn_t, _) => prove_const_rsp qtys Binding.empty [bn_t] (fn _ =>
       resolve_tac bns_rsp_pre' 1)) bns lthy8;
  val bns_rsp = flat (map snd bns_rsp_pre);

  fun fv_rsp_tac _ = if !cheat_fv_rsp then Skip_Proof.cheat_tac thy
    else fvbv_rsp_tac alpha_induct fv_def lthy8 1;
  val fv_rsps = prove_fv_rsp fv_alpha_all alpha_ts fv_rsp_tac lthy9;
  val (fv_rsp_pre, lthy10) = fold_map
    (fn fv => fn ctxt => prove_const_rsp qtys Binding.empty [fv]
    (fn _ => asm_simp_tac (HOL_ss addsimps fv_rsps) 1) ctxt) (fv @ fvbn) lthy9;
  val fv_rsp = flat (map snd fv_rsp_pre);
  val (perms_rsp, lthy11) = prove_const_rsp qtys Binding.empty perms
    (fn _ => asm_simp_tac (HOL_ss addsimps alpha_eqvt) 1) lthy10;
  fun alpha_bn_rsp_tac _ = if !cheat_alpha_bn_rsp then Skip_Proof.cheat_tac thy
    else
      let val alpha_bn_rsp_pre = prove_alpha_bn_rsp alpha_ts alpha_induct (alpha_eq_iff_simp @ rel_dists @ rel_dists_bn) alpha_equivp exhausts alpha_ts_bn lthy11 in asm_simp_tac (HOL_ss addsimps alpha_bn_rsp_pre) 1 end;
  val (alpha_bn_rsps, lthy11a) = fold_map (fn cnst => prove_const_rsp qtys Binding.empty [cnst]
    alpha_bn_rsp_tac) alpha_ts_bn lthy11
  fun const_rsp_tac _ =
    let val alpha_alphabn = prove_alpha_alphabn alpha_ts alpha_induct alpha_eq_iff_simp alpha_ts_bn lthy11a
      in constr_rsp_tac alpha_eq_iff_simp (fv_rsp @ bns_rsp @ reflps @ alpha_alphabn) 1 end
  val (const_rsps, lthy12) = fold_map (fn cnst => prove_const_rsp qtys Binding.empty [cnst]
    const_rsp_tac) raw_consts lthy11a
    val qfv_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) (fv @ fvbn)
  val (qfv_ts, qfv_defs, lthy12a) = quotient_lift_consts_export qtys (qfv_names ~~ (fv @ fvbn)) lthy12;
  val (qfv_ts_nobn, qfv_ts_bn) = chop (length perms) qfv_ts;
  val qbn_names = map (fn (b, _ , _) => Name.of_binding b) bn_funs
  val (qbn_ts, qbn_defs, lthy12b) = quotient_lift_consts_export qtys (qbn_names ~~ raw_bn_funs) lthy12a;
  val qalpha_bn_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) alpha_ts_bn
  val (qalpha_ts_bn, qalphabn_defs, lthy12c) = 
    quotient_lift_consts_export qtys (qalpha_bn_names ~~ alpha_ts_bn) lthy12b;
  val _ = warning "Lifting permutations";
  val thy = Local_Theory.exit_global lthy12c;
  val perm_names = map (fn x => "permute_" ^ x) qty_names
  val thy' = define_lifted_perms qtys qty_full_names (perm_names ~~ perms) raw_perm_simps thy;
  val lthy13 = Theory_Target.init NONE thy';
  val q_name = space_implode "_" qty_names;
  fun suffix_bind s = Binding.qualify true q_name (Binding.name s);
  val _ = warning "Lifting induction";
  val constr_names = map (Long_Name.base_name o fst o dest_Const) consts;
  val q_induct = Rule_Cases.name constr_names (lift_thm qtys lthy13 induct);
  fun note_suffix s th ctxt =
    snd (Local_Theory.note ((suffix_bind s, []), th) ctxt);
  fun note_simp_suffix s th ctxt =
    snd (Local_Theory.note ((suffix_bind s, [Attrib.internal (K Simplifier.simp_add)]), th) ctxt);
  val (_, lthy14) = Local_Theory.note ((suffix_bind "induct",
    [Attrib.internal (K (Rule_Cases.case_names constr_names))]), 
    [Rule_Cases.name constr_names q_induct]) lthy13;
  val q_inducts = Project_Rule.projects lthy13 (1 upto (length fv)) q_induct
  val (_, lthy14a) = Local_Theory.note ((suffix_bind "inducts", []), q_inducts) lthy14;
  val q_perm = map (lift_thm qtys lthy14) raw_perm_def;
  val lthy15 = note_simp_suffix "perm" q_perm lthy14a;
  val q_fv = map (lift_thm qtys lthy15) fv_def;
  val lthy16 = note_simp_suffix "fv" q_fv lthy15;
  val q_bn = map (lift_thm qtys lthy16) raw_bn_eqs;
  val lthy17 = note_simp_suffix "bn" q_bn lthy16;
  val _ = warning "Lifting eq-iff";
  (*val _ = map tracing (map PolyML.makestring alpha_eq_iff);*)
  val eq_iff_unfolded0 = map (Local_Defs.unfold lthy17 @{thms alphas3}) alpha_eq_iff_simp
  val eq_iff_unfolded1 = map (Local_Defs.unfold lthy17 @{thms alphas2}) eq_iff_unfolded0
  val eq_iff_unfolded2 = map (Local_Defs.unfold lthy17 @{thms alphas} ) eq_iff_unfolded1
  val q_eq_iff_pre0 = map (lift_thm qtys lthy17) eq_iff_unfolded2;
  val q_eq_iff_pre1 = map (Local_Defs.fold lthy17 @{thms alphas3}) q_eq_iff_pre0
  val q_eq_iff_pre2 = map (Local_Defs.fold lthy17 @{thms alphas2}) q_eq_iff_pre1
  val q_eq_iff = map (Local_Defs.fold lthy17 @{thms alphas}) q_eq_iff_pre2
  val (_, lthy18) = Local_Theory.note ((suffix_bind "eq_iff", []), q_eq_iff) lthy17;
  val q_dis = map (lift_thm qtys lthy18) rel_dists;
  val lthy19 = note_simp_suffix "distinct" q_dis lthy18;
  val q_eqvt = map (lift_thm qtys lthy19) (bv_eqvt @ fv_eqvt);
  val (_, lthy20) = Local_Theory.note ((Binding.empty,
    [Attrib.internal (fn _ => Nominal_ThmDecls.eqvt_add)]), q_eqvt) lthy19;
  val _ = warning "Supports";
  val supports = map (prove_supports lthy20 q_perm) consts;
  val fin_supp = HOLogic.conj_elims (prove_fs lthy20 q_induct supports qtys);
  val thy3 = Local_Theory.exit_global lthy20;
  val _ = warning "Instantiating FS";
  val lthy21 = Theory_Target.instantiation (qty_full_names, [], @{sort fs}) thy3;
  fun tac _ = Class.intro_classes_tac [] THEN (ALLGOALS (resolve_tac fin_supp))
  val lthy22 = Class.prove_instantiation_instance tac lthy21
  val fv_alpha_all = combine_fv_alpha_bns (qfv_ts_nobn, qfv_ts_bn) (alpha_ts_nobn, qalpha_ts_bn) bn_nos;
  val (names, supp_eq_t) = supp_eq fv_alpha_all;
  val _ = warning "Support Equations";
  fun supp_eq_tac' _ = if !cheat_supp_eq then Skip_Proof.cheat_tac thy else
    supp_eq_tac q_induct q_fv q_perm q_eq_iff lthy22 1;
  val q_supp = HOLogic.conj_elims (Goal.prove lthy22 names [] supp_eq_t supp_eq_tac') handle e =>
    let val _ = warning ("Support eqs failed") in [] end;
  val lthy23 = note_suffix "supp" q_supp lthy22;
in
  (0, lthy23)
end
*}

section {* Preparing and parsing of the specification *}

ML {* 
(* parsing the datatypes and declaring *)
(* constructors in the local theory    *)
fun prepare_dts dt_strs lthy = 
let
  val thy = ProofContext.theory_of lthy
  
  fun mk_type full_tname tvrs =
    Type (full_tname, map (fn a => TVar ((a, 0), [])) tvrs)

  fun prep_cnstr full_tname tvs (cname, anno_tys, mx, _) =
  let
    val tys = map (Syntax.read_typ lthy o snd) anno_tys
    val ty = mk_type full_tname tvs
  in
    ((cname, tys ---> ty, mx), (cname, tys, mx))
  end
  
  fun prep_dt (tvs, tname, mx, cnstrs) = 
  let
    val full_tname = Sign.full_name thy tname
    val (cnstrs', cnstrs'') = 
      split_list (map (prep_cnstr full_tname tvs) cnstrs)
  in
    (cnstrs', (tvs, tname, mx, cnstrs''))
  end 

  val (cnstrs, dts) = split_list (map prep_dt dt_strs)
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i (flat cnstrs))
  |> pair dts
end
*}

ML {*
(* parsing the binding function specification and *)
(* declaring the functions in the local theory    *)
fun prepare_bn_funs bn_fun_strs bn_eq_strs lthy =
let
  val ((bn_funs, bn_eqs), _) = 
    Specification.read_spec bn_fun_strs bn_eq_strs lthy

  fun prep_bn_fun ((bn, T), mx) = (bn, T, mx) 
  
  val bn_funs' = map prep_bn_fun bn_funs
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i bn_funs')
  |> pair (bn_funs', bn_eqs) 
end 
*}

text {* associates every SOME with the index in the list; drops NONEs *}
ML {*
fun indexify xs =
let
  fun mapp _ [] = []
    | mapp i (NONE :: xs) = mapp (i + 1) xs
    | mapp i (SOME x :: xs) = (x, i) :: mapp (i + 1) xs
in 
  mapp 0 xs 
end

fun index_lookup xs x =
  case AList.lookup (op=) xs x of
    SOME x => x
  | NONE => error ("Cannot find " ^ x ^ " as argument annotation.");
*}

ML {*
fun prepare_bclauses dt_strs lthy = 
let
  val annos_bclauses =
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, bns) => (map fst antys, bns)))

  fun prep_binder env bn_str =
    case (Syntax.read_term lthy bn_str) of
      Free (x, _) => (NONE, index_lookup env x)
    | Const (a, T) $ Free (x, _) => (SOME (Const (a, T)), index_lookup env x)
    | _ => error ("The term " ^ bn_str ^ " is not allowed as binding function.")
 
  fun prep_body env bn_str = index_lookup env bn_str

  fun prep_mode "bind"     = BLst 
    | prep_mode "bind_set" = BSet 
    | prep_mode "bind_res" = BRes 

  fun prep_bclause env (mode, binders, bodies) = 
  let
    val binders' = map (prep_binder env) binders
    val bodies' = map (prep_body env) bodies
  in  
    prep_mode mode (binders', bodies')
  end

  fun prep_bclauses (annos, bclause_strs) = 
  let
    val env = indexify annos (* for every label, associate the index *)
  in
    map (prep_bclause env) bclause_strs
  end
in
  map (map prep_bclauses) annos_bclauses
end
*}

text {* 
  adds an empty binding clause for every argument
  that is not already part of a binding clause
*}

ML {*
fun included i bcs = 
let
  fun incl (BEmy j) = i = j
    | incl (BLst (bns, bds)) = (i mem (map snd bns)) orelse (i mem bds) 
    | incl (BSet (bns, bds)) = (i mem (map snd bns)) orelse (i mem bds) 
    | incl (BRes (bns, bds)) = (i mem (map snd bns)) orelse (i mem bds) 
in
  exists incl bcs 
end
*}

ML {* 
fun complete dt_strs bclauses = 
let
  val args = 
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, _) => length antys))

  fun complt n bcs = 
  let
    fun add bcs i = (if included i bcs then [] else [BEmy i]) 
  in
    bcs @ (flat (map_range (add bcs) n))
  end
in
  map2 (map2 complt) args bclauses
end
*}

ML {*
fun nominal_datatype2_cmd (dt_strs, bn_fun_strs, bn_eq_strs) lthy = 
let
  fun prep_typ (tvs, tname, mx, _) = (tname, length tvs, mx)
  val lthy0 = 
    Local_Theory.theory (Sign.add_types (map prep_typ dt_strs)) lthy
  val (dts, lthy1) = prepare_dts dt_strs lthy0
  val ((bn_funs, bn_eqs), lthy2) = prepare_bn_funs bn_fun_strs bn_eq_strs lthy1
  val bclauses = prepare_bclauses dt_strs lthy2
  val bclauses' = complete dt_strs bclauses 
in
  nominal_datatype2 dts bn_funs bn_eqs bclauses' lthy |> snd
end


(* Command Keyword *)

val _ = OuterSyntax.local_theory "nominal_datatype" "test" OuterKeyword.thy_decl
  (main_parser >> nominal_datatype2_cmd)
*}

(*atom_decl name

nominal_datatype lam =
  Var name
| App lam lam
| Lam x::name t::lam  bind_set x in t
| Let p::pt t::lam bind_set "bn p" in t
and pt =
  P1 name
| P2 pt pt
binder
 bn::"pt \<Rightarrow> atom set"
where
  "bn (P1 x) = {atom x}"
| "bn (P2 p1 p2) = bn p1 \<union> bn p2"

thm lam_pt.bn
thm lam_pt.fv[simplified lam_pt.supp(1-2)]
thm lam_pt.eq_iff
thm lam_pt.induct
thm lam_pt.perm

nominal_datatype exp =
  EVar name
| EUnit
| EPair q1::exp q2::exp
| ELetRec l::lrbs e::exp     bind "b_lrbs l" in e l

and fnclause =
  K x::name p::pat f::exp    bind_res "b_pat p" in f

and fnclauses =
  S fnclause
| ORs fnclause fnclauses

and lrb =
  Clause fnclauses

and lrbs =
  Single lrb
| More lrb lrbs

and pat =
  PVar name
| PUnit
| PPair pat pat

binder
  b_lrbs      :: "lrbs \<Rightarrow> atom list" and
  b_pat       :: "pat \<Rightarrow> atom set" and
  b_fnclauses :: "fnclauses \<Rightarrow> atom list" and
  b_fnclause  :: "fnclause \<Rightarrow> atom list" and
  b_lrb       :: "lrb \<Rightarrow> atom list"

where
  "b_lrbs (Single l) = b_lrb l"
| "b_lrbs (More l ls) = append (b_lrb l) (b_lrbs ls)"
| "b_pat (PVar x) = {atom x}"
| "b_pat (PUnit) = {}"
| "b_pat (PPair p1 p2) = b_pat p1 \<union> b_pat p2"
| "b_fnclauses (S fc) = (b_fnclause fc)"
| "b_fnclauses (ORs fc fcs) = append (b_fnclause fc) (b_fnclauses fcs)"
| "b_lrb (Clause fcs) = (b_fnclauses fcs)"
| "b_fnclause (K x pat exp) = [atom x]"

thm exp_fnclause_fnclauses_lrb_lrbs_pat.bn
thm exp_fnclause_fnclauses_lrb_lrbs_pat.fv
thm exp_fnclause_fnclauses_lrb_lrbs_pat.eq_iff
thm exp_fnclause_fnclauses_lrb_lrbs_pat.induct
thm exp_fnclause_fnclauses_lrb_lrbs_pat.perm

nominal_datatype ty =
  Vr "name"
| Fn "ty" "ty"
and tys =
  Al xs::"name fset" t::"ty" bind_res xs in t

thm ty_tys.fv[simplified ty_tys.supp]
thm ty_tys.eq_iff

*)

(* some further tests *)

(*
nominal_datatype ty2 =
  Vr2 "name"
| Fn2 "ty2" "ty2"

nominal_datatype tys2 =
  All2 xs::"name fset" ty::"ty2" bind_res xs in ty

nominal_datatype lam2 =
  Var2 "name"
| App2 "lam2" "lam2 list"
| Lam2 x::"name" t::"lam2" bind x in t
*)



end



