theory Abs
imports "Nominal2_Atoms" 
        "Nominal2_Eqvt" 
        "Nominal2_Supp" 
        "Nominal2_FSet"
        "../Quotient" 
        "../Quotient_Product" 
begin

fun
  alpha_gen 
where
  alpha_gen[simp del]:
  "alpha_gen (bs, x) R f pi (cs, y) \<longleftrightarrow> 
     f x - bs = f y - cs \<and> 
     (f x - bs) \<sharp>* pi \<and> 
     R (pi \<bullet> x) y \<and>
     pi \<bullet> bs = cs"

fun
  alpha_res
where
  alpha_res[simp del]:
  "alpha_res (bs, x) R f pi (cs, y) \<longleftrightarrow> 
     f x - bs = f y - cs \<and> 
     (f x - bs) \<sharp>* pi \<and> 
     R (pi \<bullet> x) y"

fun
  alpha_lst
where
  alpha_lst[simp del]:
  "alpha_lst (bs, x) R f pi (cs, y) \<longleftrightarrow> 
     f x - set bs = f y - set cs \<and> 
     (f x - set bs) \<sharp>* pi \<and> 
     R (pi \<bullet> x) y \<and>
     pi \<bullet> bs = cs"

lemmas alphas = alpha_gen.simps alpha_res.simps alpha_lst.simps

notation
  alpha_gen ("_ \<approx>gen _ _ _ _" [100, 100, 100, 100, 100] 100) and
  alpha_res ("_ \<approx>res _ _ _ _" [100, 100, 100, 100, 100] 100) and
  alpha_lst ("_ \<approx>lst _ _ _ _" [100, 100, 100, 100, 100] 100) 

(* monos *)
lemma [mono]: 
  shows "R1 \<le> R2 \<Longrightarrow> alpha_gen bs R1 \<le> alpha_gen bs R2"
  and   "R1 \<le> R2 \<Longrightarrow> alpha_res bs R1 \<le> alpha_res bs R2"
  and   "R1 \<le> R2 \<Longrightarrow> alpha_lst cs R1 \<le> alpha_lst cs R2"
  by (case_tac [!] bs, case_tac [!] cs) 
     (auto simp add: le_fun_def le_bool_def alphas)

lemma alpha_gen_refl:
  assumes a: "R x x"
  shows "(bs, x) \<approx>gen R f 0 (bs, x)"
  and   "(bs, x) \<approx>res R f 0 (bs, x)"
  and   "(cs, x) \<approx>lst R f 0 (cs, x)"
  using a 
  unfolding alphas
  unfolding fresh_star_def
  by (simp_all add: fresh_zero_perm)

lemma alpha_gen_sym:
  assumes a: "R (p \<bullet> x) y \<Longrightarrow> R (- p \<bullet> y) x"
  shows "(bs, x) \<approx>gen R f p (cs, y) \<Longrightarrow> (cs, y) \<approx>gen R f (- p) (bs, x)"
  and   "(bs, x) \<approx>res R f p (cs, y) \<Longrightarrow> (cs, y) \<approx>res R f (- p) (bs, x)"
  and   "(ds, x) \<approx>lst R f p (es, y) \<Longrightarrow> (es, y) \<approx>lst R f (- p) (ds, x)"
  using a
  unfolding alphas
  unfolding fresh_star_def
  by (auto simp add:  fresh_minus_perm)

lemma alpha_gen_trans:
  assumes a: "\<lbrakk>R (p \<bullet> x) y; R (q \<bullet> y) z\<rbrakk> \<Longrightarrow> R ((q + p) \<bullet> x) z"
  shows "\<lbrakk>(bs, x) \<approx>gen R f p (cs, y); (cs, y) \<approx>gen R f q (ds, z)\<rbrakk> \<Longrightarrow> (bs, x) \<approx>gen R f (q + p) (ds, z)"
  and   "\<lbrakk>(bs, x) \<approx>res R f p (cs, y); (cs, y) \<approx>res R f q (ds, z)\<rbrakk> \<Longrightarrow> (bs, x) \<approx>res R f (q + p) (ds, z)"
  and   "\<lbrakk>(es, x) \<approx>lst R f p (gs, y); (gs, y) \<approx>lst R f q (hs, z)\<rbrakk> \<Longrightarrow> (es, x) \<approx>lst R f (q + p) (hs, z)"
  using a 
  unfolding alphas
  unfolding fresh_star_def
  by (simp_all add: fresh_plus_perm)

lemma alpha_gen_eqvt:
  assumes a: "R (q \<bullet> x) y \<Longrightarrow> R (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     b: "p \<bullet> (f x) = f (p \<bullet> x)"
  and     c: "p \<bullet> (f y) = f (p \<bullet> y)"
  shows "(bs, x) \<approx>gen R f q (cs, y) \<Longrightarrow> (p \<bullet> bs, p \<bullet> x) \<approx>gen R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  and   "(bs, x) \<approx>res R f q (cs, y) \<Longrightarrow> (p \<bullet> bs, p \<bullet> x) \<approx>res R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  and   "(ds, x) \<approx>lst R f q (es, y) \<Longrightarrow> (p \<bullet> ds, p \<bullet> x) \<approx>lst R f (p \<bullet> q) (p \<bullet> es, p \<bullet> y)" 
  unfolding alphas
  unfolding set_eqvt[symmetric]
  unfolding b[symmetric] c[symmetric]
  unfolding Diff_eqvt[symmetric]
  unfolding permute_eqvt[symmetric]
  using a
  by (auto simp add: fresh_star_permute_iff)

fun
  alpha_abs 
where
  "alpha_abs (bs, x) (cs, y) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op=) supp p (cs, y))"

notation
  alpha_abs ("_ \<approx>abs _")

lemma alpha_abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(bs, x) \<approx>abs ((a \<rightleftharpoons> b) \<bullet> bs, (a \<rightleftharpoons> b) \<bullet> x)"
  using a1 a2
  unfolding Diff_iff
  unfolding alpha_abs.simps
  unfolding alphas
  unfolding supp_eqvt[symmetric] Diff_eqvt[symmetric]
  unfolding fresh_star_def fresh_def
  unfolding swap_set_not_in[OF a1 a2] 
  by (rule_tac x="(a \<rightleftharpoons> b)" in exI)
     (auto simp add: supp_perm swap_atom)

fun
  supp_abs_fun
where
  "supp_abs_fun (bs, x) = (supp x) - bs"


lemma supp_abs_fun_lemma:
  assumes a: "x \<approx>abs y" 
  shows "supp_abs_fun x = supp_abs_fun y"
  using a
  apply(induct rule: alpha_abs.induct)
  apply(simp add: alpha_gen)
  done
  

quotient_type 'a abs_gen = "(atom set \<times> 'a::pt)" / "alpha_abs"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(simp_all)
  (* refl *)
  apply(clarify)
  apply(rule_tac x="0" in exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  (* symm *)
  apply(clarify)
  apply(rule_tac x="- p" in exI)
  apply(rule alpha_gen_sym)
  apply(clarsimp)
  apply(assumption)
  (* trans *)
  apply(clarify)
  apply(rule_tac x="pa + p" in exI)
  apply(rule alpha_gen_trans)
  apply(auto)
  done

quotient_definition
  "Abs::atom set \<Rightarrow> ('a::pt) \<Rightarrow> 'a abs_gen"
is
  "Pair::atom set \<Rightarrow> ('a::pt) \<Rightarrow> (atom set \<times> 'a)"

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> alpha_abs) Pair Pair"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  done

lemma [quot_respect]:
  shows "((op =) ===> alpha_abs ===> alpha_abs) permute permute"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_eqvt)
  apply(simp_all add: supp_eqvt)
  done

lemma [quot_respect]:
  shows "(alpha_abs ===> (op =)) supp_abs_fun supp_abs_fun"
  apply(simp add: supp_abs_fun_lemma)
  done

lemma abs_induct:
  "\<lbrakk>\<And>as (x::'a::pt). P (Abs as x)\<rbrakk> \<Longrightarrow> P t"
  apply(lifting prod.induct[where 'a="atom set" and 'b="'a"])
  done

(* TEST case *)
lemmas abs_induct2 = prod.induct[where 'a="atom set" and 'b="'a::pt", quot_lifted]
thm abs_induct abs_induct2

instantiation abs_gen :: (pt) pt
begin

quotient_definition
  "permute_abs_gen::perm \<Rightarrow> ('a::pt abs_gen) \<Rightarrow> 'a abs_gen"
is
  "permute:: perm \<Rightarrow> (atom set \<times> 'a::pt) \<Rightarrow> (atom set \<times> 'a::pt)"

(* ??? has to be 'a \<dots> 'b does not work *)
lemma permute_ABS [simp]:
  fixes x::"'a::pt"  
  shows "(p \<bullet> (Abs as x)) = Abs (p \<bullet> as) (p \<bullet> x)"
  thm permute_prod.simps
  by (lifting permute_prod.simps(1)[where 'a="atom set" and 'b="'a"])

instance
  apply(default)
  apply(induct_tac [!] x rule: abs_induct)
  apply(simp_all)
  done

end

quotient_definition
  "supp_Abs_fun :: ('a::pt) abs_gen \<Rightarrow> atom \<Rightarrow> bool"
is
  "supp_abs_fun"

lemma supp_Abs_fun_simp:
  shows "supp_Abs_fun (Abs bs x) = (supp x) - bs"
  by (lifting supp_abs_fun.simps(1))

lemma supp_Abs_fun_eqvt [eqvt]:
  shows "(p \<bullet> supp_Abs_fun x) = supp_Abs_fun (p \<bullet> x)"
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs_fun_simp supp_eqvt Diff_eqvt)
  done

lemma supp_Abs_fun_fresh:
  shows "a \<sharp> Abs bs x \<Longrightarrow> a \<sharp> supp_Abs_fun (Abs bs x)"
  apply(rule fresh_fun_eqvt_app)
  apply(simp add: eqvts_raw)
  apply(simp)
  done

lemma Abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(Abs bs x) = (Abs ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
  using a1 a2 by (lifting alpha_abs_swap)

lemma Abs_supports:
  shows "((supp x) - as) supports (Abs as x)"
  unfolding supports_def
  apply(clarify)
  apply(simp (no_asm))
  apply(subst Abs_swap[symmetric])
  apply(simp_all)
  done

lemma finite_supp_Abs_subset1:
  assumes "finite (supp x)"
  shows "(supp x) - as \<subseteq> supp (Abs as x)"
  apply(simp add: supp_conv_fresh)
  apply(auto)
  apply(drule_tac supp_Abs_fun_fresh)
  apply(simp only: supp_Abs_fun_simp)
  apply(simp add: fresh_def)
  apply(simp add: supp_finite_atom_set assms)
  done

lemma finite_supp_Abs_subset2:
  assumes "finite (supp x)"
  shows "supp (Abs as x) \<subseteq> (supp x) - as"
  apply(rule supp_is_subset)
  apply(rule Abs_supports)
  apply(simp add: assms)
  done

lemma finite_supp_Abs:
  assumes "finite (supp x)"
  shows "supp (Abs as x) = (supp x) - as"
  apply(rule_tac subset_antisym)
  apply(rule finite_supp_Abs_subset2[OF assms])
  apply(rule finite_supp_Abs_subset1[OF assms])
  done

lemma supp_Abs:
  fixes x::"'a::fs"
  shows "supp (Abs as x) = (supp x) - as"
  apply(rule finite_supp_Abs)
  apply(simp add: finite_supp)
  done

instance abs_gen :: (fs) fs
  apply(default)
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs)
  apply(simp add: finite_supp)
  done

lemma Abs_fresh_iff:
  fixes x::"'a::fs"
  shows "a \<sharp> Abs bs x \<longleftrightarrow> a \<in> bs \<or> (a \<notin> bs \<and> a \<sharp> x)"
  apply(simp add: fresh_def)
  apply(simp add: supp_Abs)
  apply(auto)
  done

lemma Abs_eq_iff:
  shows "Abs bs x = Abs cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
  by (lifting alpha_abs.simps(1))



(* 
  below is a construction site for showing that in the
  single-binder case, the old and new alpha equivalence 
  coincide
*)

fun
  alpha1
where
  "alpha1 (a, x) (b, y) \<longleftrightarrow> (a = b \<and> x = y) \<or> (a \<noteq> b \<and> x = (a \<rightleftharpoons> b) \<bullet> y \<and> a \<sharp> y)"

notation 
  alpha1 ("_ \<approx>abs1 _")

fun
  alpha2
where
  "alpha2 (a, x) (b, y) \<longleftrightarrow> (\<exists>c. c \<sharp> (a,b,x,y) \<and> ((c \<rightleftharpoons> a) \<bullet> x) = ((c \<rightleftharpoons> b) \<bullet> y))"

notation 
  alpha2 ("_ \<approx>abs2 _")

lemma alpha_old_new:
  assumes a: "(a, x) \<approx>abs1 (b, y)" "sort_of a = sort_of b"
  shows "({a}, x) \<approx>abs ({b}, y)"
using a
apply(simp)
apply(erule disjE)
apply(simp)
apply(rule exI)
apply(rule alpha_gen_refl)
apply(simp)
apply(rule_tac x="(a \<rightleftharpoons> b)" in  exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_def)
apply(rule conjI)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in  permute_eq_iff[THEN iffD1])
apply(rule trans)
apply(simp add: Diff_eqvt supp_eqvt)
apply(subst swap_set_not_in)
back
apply(simp)
apply(simp)
apply(simp add: permute_set_eq)
apply(rule conjI)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in fresh_star_permute_iff[THEN iffD1])
apply(simp add: permute_self)
apply(simp add: Diff_eqvt supp_eqvt)
apply(simp add: permute_set_eq)
apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
apply(simp add: fresh_star_def fresh_def)
apply(blast)
apply(simp add: supp_swap)
apply(simp add: eqvts)
done


lemma perm_induct_test:
  fixes P :: "perm => bool"
  assumes fin: "finite (supp p)" 
  assumes zero: "P 0"
  assumes swap: "\<And>a b. \<lbrakk>sort_of a = sort_of b; a \<noteq> b\<rbrakk> \<Longrightarrow> P (a \<rightleftharpoons> b)"
  assumes plus: "\<And>p1 p2. \<lbrakk>supp p1 \<inter> supp p2 = {}; P p1; P p2\<rbrakk> \<Longrightarrow> P (p1 + p2)"
  shows "P p"
using fin
apply(induct F\<equiv>"supp p" arbitrary: p rule: finite_induct)
oops

lemma ii:
  assumes "\<forall>x \<in> A. p \<bullet> x = x"
  shows "p \<bullet> A = A"
using assms
apply(auto)
apply (metis Collect_def Collect_mem_eq Int_absorb assms eqvt_bound inf_Int_eq mem_def mem_permute_iff)
apply (metis Collect_def Collect_mem_eq Int_absorb assms eqvt_apply eqvt_bound eqvt_lambda inf_Int_eq mem_def mem_permute_iff permute_minus_cancel(2) permute_pure)
done



lemma alpha_abs_Pair:
  shows "(bs, (x1, x2)) \<approx>gen (\<lambda>(x1,x2) (y1,y2). x1=y1 \<and> x2=y2) (\<lambda>(x,y). supp x \<union> supp y) p (cs, (y1, y2))
         \<longleftrightarrow> ((bs, x1) \<approx>gen (op=) supp p (cs, y1) \<and> (bs, x2) \<approx>gen (op=) supp p (cs, y2))"         
  apply(simp add: alpha_gen)
  apply(simp add: fresh_star_def)
  apply(simp add: ball_Un Un_Diff)
  apply(rule iffI)
  apply(simp)
  defer
  apply(simp)
  apply(rule conjI)
  apply(clarify)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(rule sym)
  apply(rule ii)
  apply(simp add: fresh_def supp_perm)
  apply(clarify)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(simp add: fresh_def supp_perm)
  apply(rule sym)
  apply(rule ii)
  apply(simp)
  done


lemma yy:
  assumes "S1 - {x} = S2 - {x}" "x \<in> S1" "x \<in> S2"
  shows "S1 = S2"
using assms
apply (metis insert_Diff_single insert_absorb)
done

lemma kk:
  assumes a: "p \<bullet> x = y"
  shows "\<forall>a \<in> supp x. (p \<bullet> a) \<in> supp y"
using a
apply(auto)
apply(rule_tac p="- p" in permute_boolE)
apply(simp add: mem_eqvt supp_eqvt)
done

lemma ww:
  assumes "a \<notin> supp x" "b \<in> supp x" "a \<noteq> b" "sort_of a = sort_of b"
  shows "((a \<rightleftharpoons> b) \<bullet> x) \<noteq> x"
apply(subgoal_tac "(supp x) supports x")
apply(simp add: supports_def)
using assms
apply -
apply(drule_tac x="a" in spec)
defer
apply(rule supp_supports)
apply(auto)
apply(rotate_tac 1)
apply(drule_tac p="(a \<rightleftharpoons> b)" in permute_boolI)
apply(simp add: mem_eqvt supp_eqvt)
done

lemma alpha_abs_sym:
  assumes a: "({a}, x) \<approx>abs ({b}, y)"
  shows "({b}, y) \<approx>abs ({a}, x)"
using a
apply(simp)
apply(erule exE)
apply(rule_tac x="- p" in exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_star_def fresh_minus_perm)
apply (metis permute_minus_cancel(2))
done

lemma alpha_abs_trans:
  assumes a: "({a1}, x1) \<approx>abs ({a2}, x2)"
  assumes b: "({a2}, x2) \<approx>abs ({a3}, x3)"
  shows "({a1}, x1) \<approx>abs ({a3}, x3)"
using a b
apply(simp)
apply(erule exE)+
apply(rule_tac x="pa + p" in exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_star_def fresh_plus_perm)
done

lemma alpha_equal:
  assumes a: "({a}, x) \<approx>abs ({a}, y)" 
  shows "(a, x) \<approx>abs1 (a, y)"
using a
apply(simp)
apply(erule exE)
apply(simp add: alpha_gen)
apply(erule conjE)+
apply(case_tac "a \<notin> supp x")
apply(simp)
apply(subgoal_tac "supp x \<sharp>* p")
apply(drule supp_perm_eq)
apply(simp)
apply(simp)
apply(simp)
apply(case_tac "a \<notin> supp y")
apply(simp)
apply(drule supp_perm_eq)
apply(clarify)
apply(simp (no_asm_use))
apply(simp)
apply(simp)
apply(drule yy)
apply(simp)
apply(simp)
apply(simp)
apply(case_tac "a \<sharp> p")
apply(subgoal_tac "supp y \<sharp>* p")
apply(drule supp_perm_eq)
apply(clarify)
apply(simp (no_asm_use))
apply(metis)
apply(auto simp add: fresh_star_def)[1]
apply(frule_tac kk)
apply(drule_tac x="a" in bspec)
apply(simp)
apply(simp add: fresh_def)
apply(simp add: supp_perm)
apply(subgoal_tac "((p \<bullet> a) \<sharp> p)")
apply(simp add: fresh_def supp_perm)
apply(simp add: fresh_star_def)
done

lemma alpha_unequal:
  assumes a: "({a}, x) \<approx>abs ({b}, y)" "sort_of a = sort_of b" "a \<noteq> b"
  shows "(a, x) \<approx>abs1 (b, y)"
using a
apply -
apply(subgoal_tac "a \<notin> supp x - {a}")
apply(subgoal_tac "b \<notin> supp x - {a}")
defer
apply(simp add: alpha_gen)
apply(simp)
apply(drule_tac alpha_abs_swap)
apply(assumption)
apply(simp only: insert_eqvt empty_eqvt swap_atom_simps)
apply(drule alpha_abs_sym)
apply(rotate_tac 4)
apply(drule_tac alpha_abs_trans)
apply(assumption)
apply(drule alpha_equal)
apply(simp)
apply(rule_tac p="(a \<rightleftharpoons> b)" in permute_boolE)
apply(simp add: fresh_eqvt)
apply(simp add: fresh_def)
done

lemma alpha_new_old:
  assumes a: "({a}, x) \<approx>abs ({b}, y)" "sort_of a = sort_of b" 
  shows "(a, x) \<approx>abs1 (b, y)"
using a
apply(case_tac "a=b")
apply(simp only: alpha_equal)
apply(drule alpha_unequal)
apply(simp)
apply(simp)
apply(simp)
done

(* support of concrete atom sets *)

lemma supp_atom_image:
  fixes as::"'a::at_base set"
  shows "supp (atom ` as) = supp as"
apply(simp add: supp_def)
apply(simp add: image_eqvt)
apply(simp add: atom_eqvt_raw)
apply(simp add: atom_image_cong)
done

lemma swap_atom_image_fresh: "\<lbrakk>a \<sharp> atom ` (fn :: ('a :: at_base set)); b \<sharp> atom ` fn\<rbrakk> \<Longrightarrow> (a \<rightleftharpoons> b) \<bullet> fn = fn"
  apply (simp add: fresh_def)
  apply (simp add: supp_atom_image)
  apply (fold fresh_def)
  apply (simp add: swap_fresh_fresh)
  done

(* TODO: The following lemmas can be moved somewhere... *)
lemma split_rsp2[quot_respect]: "((R1 ===> R2 ===> prod_rel R1 R2 ===> op =) ===>
  prod_rel R1 R2 ===> prod_rel R1 R2 ===> op =) split split"
  by auto

lemma split_prs2[quot_preserve]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  and q2: "Quotient R2 Abs2 Rep2"
  shows "((Abs1 ---> Abs2 ---> prod_fun Abs1 Abs2 ---> id) ---> prod_fun Rep1 Rep2 ---> prod_fun Rep1 Rep2 ---> id) split = split"
  by (simp add: expand_fun_eq Quotient_abs_rep[OF q1] Quotient_abs_rep[OF q2])

lemma alpha_gen2:
  "(bs, x1, x2) \<approx>gen (\<lambda>(x1, y1) (x2, y2). R1 x1 x2 \<and> R2 y1 y2) (\<lambda>(a, b). f1 a \<union> f2 b) pi (cs, y1, y2) =
  (f1 x1 \<union> f2 x2 - bs = f1 y1 \<union> f2 y2 - cs \<and> (f1 x1 \<union> f2 x2 - bs) \<sharp>* pi \<and> R1 (pi \<bullet> x1) y1 \<and> R2 (pi \<bullet> x2) y2
  \<and> pi \<bullet> bs = cs)"
by (simp add: alpha_gen)


lemma alpha_gen_compose_sym:
  fixes pi
  assumes b: "(aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> R x2 x1) f pi (ab, s)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "(ab, s) \<approx>gen R f (- pi) (aa, t)"
  using b apply -
  apply(simp add: alpha_gen)
  apply(erule conjE)+
  apply(rule conjI)
  apply(simp add: fresh_star_def fresh_minus_perm)
  apply(subgoal_tac "R (- pi \<bullet> s) ((- pi) \<bullet> (pi \<bullet> t))")
  apply simp
  apply(clarify)
  apply(simp)
  apply(rule a)
  apply assumption
  done

lemma alpha_gen_compose_sym2:
  assumes a: "(aa, t1, t2) \<approx>gen (\<lambda>(x11, x12) (x21, x22).
  (R1 x11 x21 \<and> R1 x21 x11) \<and> R2 x12 x22 \<and> R2 x22 x12) (\<lambda>(b, a). fb b \<union> fa a) pi (ab, s1, s2)"
  and r1: "\<And>pi t s. R1 t s \<Longrightarrow> R1 (pi \<bullet> t) (pi \<bullet> s)"
  and r2: "\<And>pi t s. R2 t s \<Longrightarrow> R2 (pi \<bullet> t) (pi \<bullet> s)"
  shows "(ab, s1, s2) \<approx>gen (\<lambda>(a, b) (d, c). R1 a d \<and> R2 b c) (\<lambda>(b, a). fb b \<union> fa a) (- pi) (aa, t1, t2)"
  using a
  apply(simp add: alpha_gen)
  apply clarify
  apply (rule conjI)
  apply(simp add: fresh_star_def fresh_minus_perm)
  apply (rule conjI)
  apply (rotate_tac 3)
  apply (drule_tac pi="- pi" in r1)
  apply simp
  apply (rule conjI)
  apply (rotate_tac -1)
  apply (drule_tac pi="- pi" in r2)
  apply simp_all
  done

lemma alpha_gen_compose_trans:
  fixes pi pia
  assumes b: "(aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> (\<forall>x. R x2 x \<longrightarrow> R x1 x)) f pi (ab, ta)"
  and c: "(ab, ta) \<approx>gen R f pia (ac, sa)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "(aa, t) \<approx>gen R f (pia + pi) (ac, sa)"
  using b c apply -
  apply(simp add: alpha_gen)
  apply(erule conjE)+
  apply(simp add: fresh_star_plus)
  apply(drule_tac x="- pia \<bullet> sa" in spec)
  apply(drule mp)
  apply(rotate_tac 5)
  apply(drule_tac pi="- pia" in a)
  apply(simp)
  apply(rotate_tac 7)
  apply(drule_tac pi="pia" in a)
  apply(simp)
  done

lemma alpha_gen_compose_trans2:
  fixes pi pia
  assumes b: "(aa, (t1, t2)) \<approx>gen
    (\<lambda>(b, a) (d, c). R1 b d \<and> (\<forall>z. R1 d z \<longrightarrow> R1 b z) \<and> R2 a c \<and> (\<forall>z. R2 c z \<longrightarrow> R2 a z))
    (\<lambda>(b, a). fv_a b \<union> fv_b a) pi (ab, (ta1, ta2))"
  and c: "(ab, (ta1, ta2)) \<approx>gen (\<lambda>(b, a) (d, c). R1 b d \<and> R2 a c) (\<lambda>(b, a). fv_a b \<union> fv_b a)
    pia (ac, (sa1, sa2))"
  and r1: "\<And>pi t s. R1 t s \<Longrightarrow> R1 (pi \<bullet> t) (pi \<bullet> s)"
  and r2: "\<And>pi t s. R2 t s \<Longrightarrow> R2 (pi \<bullet> t) (pi \<bullet> s)"
  shows "(aa, (t1, t2)) \<approx>gen (\<lambda>(b, a) (d, c). R1 b d \<and> R2 a c) (\<lambda>(b, a). fv_a b \<union> fv_b a)
    (pia + pi) (ac, (sa1, sa2))"
  using b c apply -
  apply(simp add: alpha_gen2)
  apply(simp add: alpha_gen)
  apply(erule conjE)+
  apply(simp add: fresh_star_plus)
  apply(drule_tac x="- pia \<bullet> sa1" in spec)
  apply(drule mp)
  apply(rotate_tac 5)
  apply(drule_tac pi="- pia" in r1)
  apply(simp)
  apply(rotate_tac -1)
  apply(drule_tac pi="pia" in r1)
  apply(simp)
  apply(drule_tac x="- pia \<bullet> sa2" in spec)
  apply(drule mp)
  apply(rotate_tac 6)
  apply(drule_tac pi="- pia" in r2)
  apply(simp)
  apply(rotate_tac -1)
  apply(drule_tac pi="pia" in r2)
  apply(simp)
  done

end

