theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 21]]

nominal_datatype singlelet: trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind x in t
| Let a::"assg" t::"trm"  bind (set) "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind (set) x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"


thm distinct
thm induct
thm exhaust
thm fv_defs
thm bn_defs
thm perm_simps
thm eq_iff
thm fv_bn_eqvt
thm size_eqvt





lemma supp_fv:
  "supp t = fv_trm t"
  "supp b = fv_bn b"
apply(induct t and b rule: i1)
apply(simp_all add: f1)
apply(simp_all add: supp_def)
apply(simp_all add: b1)
sorry

consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}

(* TEMPORARY
thm trm_assg.fv[simplified trm_assg.supp(1-2)]
*)

end



