theory Classical
imports "../Nominal2"
begin

(* example from Urban's PhD *)

atom_decl name
atom_decl coname

nominal_datatype trm =
  Ax "name" "coname"
| Cut c::"coname" t1::"trm" n::"name" t2::"trm"             bind n in t1, bind c in t2  
     ("Cut <_>._ '(_')._" [100,100,100,100] 100)
| NotR n::"name" t::"trm" "coname"                            bind n in t
     ("NotR '(_')._ _" [100,100,100] 100)
| NotL c::"coname" t::"trm" "name"                            bind c in t   
     ("NotL <_>._ _" [100,100,100] 100)
| AndR c1::"coname" t1::"trm" c2::"coname" t2::"trm" "coname" bind c1 in t1, bind c2 in t2
     ("AndR <_>._ <_>._ _" [100,100,100,100,100] 100)
| AndL1 n::"name" t::"trm" "name"                             bind n in t
     ("AndL1 '(_')._ _" [100,100,100] 100)
| AndL2 n::"name" t::"trm" "name"                             bind n in t
     ("AndL2 '(_')._ _" [100,100,100] 100)
| OrR1 c::"coname" t::"trm" "coname"                          bind c in t             
     ("OrR1 <_>._ _" [100,100,100] 100)
| OrR2 c::"coname" t::"trm" "coname"                          bind c in t     
     ("OrR2 <_>._ _" [100,100,100] 100)
| OrL n1::"name" t1::"trm" n2::"name" t2::"trm" "name"        bind n1 in t1, bind n2 in t2       
     ("OrL '(_')._ '(_')._ _" [100,100,100,100,100] 100)
| ImpL c::"coname" t1::"trm" n::"name" t2::"trm" "name"       bind c in t1, bind n in t2
     ("ImpL <_>._ '(_')._ _" [100,100,100,100,100] 100)
| ImpR c::"coname" n::"name" t::"trm" "coname"                bind n c in t
     ("ImpR '(_').<_>._ _" [100,100,100,100] 100)

thm trm.distinct
thm trm.induct
thm trm.exhaust
thm trm.strong_exhaust
thm trm.strong_exhaust[simplified]
thm trm.fv_defs
thm trm.bn_defs
thm trm.perm_simps
thm trm.eq_iff
thm trm.fv_bn_eqvt
thm trm.size_eqvt
thm trm.supp
thm trm.supp[simplified]

nominal_primrec (* (invariant "\<lambda>(_, e, d) y. atom e \<sharp> y \<and> atom d \<sharp> y") *)
  crename :: "trm \<Rightarrow> coname \<Rightarrow> coname \<Rightarrow> trm"  ("_[_\<turnstile>c>_]" [100,100,100] 100) 
where
  "(Ax x a)[d\<turnstile>c>e] = (if a=d then Ax x e else Ax x a)" 
| "atom a \<sharp> (d, e) \<Longrightarrow> (Cut <a>.M (x).N)[d\<turnstile>c>e] = Cut <a>.(M[d\<turnstile>c>e]) (x).(N[d\<turnstile>c>e])" 
| "(NotR (x).M a)[d\<turnstile>c>e] = (if a=d then NotR (x).(M[d\<turnstile>c>e]) e else NotR (x).(M[d\<turnstile>c>e]) a)" 
| "atom a \<sharp> (d, e) \<Longrightarrow> (NotL <a>.M x)[d\<turnstile>c>e] = (NotL <a>.(M[d\<turnstile>c>e]) x)" 
| "\<lbrakk>atom a \<sharp> (d, e); atom b \<sharp> (d, e)\<rbrakk> \<Longrightarrow> (AndR <a>.M <b>.N c)[d\<turnstile>c>e] = 
          (if c=d then AndR <a>.(M[d\<turnstile>c>e]) <b>.(N[d \<turnstile>c>e]) e else AndR <a>.(M[d\<turnstile>c>e]) <b>.(N[d\<turnstile>c>e]) c)" 
| "(AndL1 (x).M y)[d\<turnstile>c>e] = AndL1 (x).(M[d\<turnstile>c>e]) y"
| "(AndL2 (x).M y)[d\<turnstile>c>e] = AndL2 (x).(M[d\<turnstile>c>e]) y"
| "atom a \<sharp> (d, e) \<Longrightarrow> (OrR1 <a>.M b)[d\<turnstile>c>e] = 
          (if b=d then OrR1 <a>.(M[d\<turnstile>c>e]) e else OrR1 <a>.(M[d\<turnstile>c>e]) b)"
| "atom a \<sharp> (d, e) \<Longrightarrow> (OrR2 <a>.M b)[d\<turnstile>c>e] = 
          (if b=d then OrR2 <a>.(M[d\<turnstile>c>e]) e else OrR2 <a>.(M[d\<turnstile>c>e]) b)"
| "(OrL (x).M (y).N z)[d\<turnstile>c>e] = OrL (x).(M[d\<turnstile>c>e]) (y).(N[d\<turnstile>c>e]) z"
| "atom a \<sharp> (d, e) \<Longrightarrow> (ImpR (x).<a>.M b)[d\<turnstile>c>e] = 
          (if b=d then ImpR (x).<a>.(M[d\<turnstile>c>e]) e else ImpR (x).<a>.(M[d\<turnstile>c>e]) b)"
| "atom a \<sharp> (d, e) \<Longrightarrow> (ImpL <a>.M (x).N y)[d\<turnstile>c>e] = ImpL <a>.(M[d\<turnstile>c>e]) (x).(N[d\<turnstile>c>e]) y"
  apply(simp only: eqvt_def)
  apply(simp only: crename_graph_def)
  apply (rule, perm_simp, rule)
  (*apply(erule crename_graph.induct)
  apply(simp add: trm.fresh)*)
  apply(rule TrueI)
  -- "covered all cases"
  apply(case_tac x)
  apply(rule_tac y="a" and c="(b, c)" in trm.strong_exhaust)
  apply(simp)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)  
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(blast)  
  apply(simp add: fresh_star_def)
  apply(blast)
  apply(simp add: fresh_star_def)
  apply(metis)
  apply(simp add: fresh_star_def)
  apply(metis)  
  apply(simp add: fresh_star_def)
  apply(metis)
  -- "compatibility"
  apply(simp_all)
  apply(rule conjI)
  apply(erule conjE)+
  apply(erule Abs_lst1_fcb)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: Abs_fresh_iff)
  apply(erule fresh_eqvt_at)
  apply(simp add: finite_supp)
  apply(simp add: fresh_Pair fresh_at_base(1))
  apply(drule sym)
  apply(drule sym)
  apply(drule sym)
  apply(drule sym)
  apply(simp add: eqvt_at_def swap_fresh_fresh)
  oops

end



