theory ExPS3
imports "../NewParser"
begin

(* example 3 from Peter Sewell's bestiary *)

atom_decl name

ML {* val _ = cheat_alpha_eqvt := true *}
ML {* val _ = cheat_equivp := true *}
ML {* val _ = cheat_alpha_bn_rsp := true *}

nominal_datatype exp =
  VarP "name"
| AppP "exp" "exp"
| LamP x::"name" e::"exp" bind_set x in e
| LetP x::"name" p::"pat3" e1::"exp" e2::"exp" bind_set x in e2, bind_set "bp p" in e1
and pat3 =
  PVar "name"
| PUnit
| PPair "pat3" "pat3"
binder
  bp :: "pat3 \<Rightarrow> atom set"
where
  "bp (PVar x) = {atom x}"
| "bp (PUnit) = {}"
| "bp (PPair p1 p2) = bp p1 \<union> bp p2"

thm exp_pat3.fv
thm exp_pat3.eq_iff
thm exp_pat3.bn
thm exp_pat3.perm
thm exp_pat3.induct
thm exp_pat3.distinct
thm exp_pat3.fv
thm exp_pat3.supp(1-2)

end



