(*<*)
theory Slides9
imports "~~/src/HOL/Library/LaTeXsugar" "Nominal"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)


text_raw {*
  %% shallow, deep, and recursive binders
  %%
  %%\renewcommand{\slidecaption}{Cambridge, 8.~June 2010}
  %%\renewcommand{\slidecaption}{Uppsala, 3.~March 2011}
  \renewcommand{\slidecaption}{Leicester, 23.~November 2011}
  \newcommand{\soutt}[1]{\tikz[baseline=(X.base), inner sep=-0.1pt, outer sep=0pt]
  \node [cross out,red, ultra thick, draw] (X) {\textcolor{black}{#1}};}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{%
  \begin{tabular}{@ {\hspace{-3mm}}c@ {}}
  \\
  \LARGE General Binding Structures\\[-1mm] 
  \LARGE in Nominal Isabelle 2\\
  \end{tabular}}
  \begin{center}
  Christian Urban
  \end{center}
  \begin{center}
  joint work with {\bf Cezary Kaliszyk}\\[0mm] 
  \end{center}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}Binding in Old Nominal\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item the old Nominal Isabelle provided a reasoning infrastructure for single binders\medskip
  
  \begin{center}
  Lam [a].(Var a)
  \end{center}\bigskip

  \item<2-> but representing 

  \begin{center}
  $\forall\{a_1,\ldots,a_n\}.\; T$ 
  \end{center}\medskip

  with single binders and reasoning about it is a \alert{\bf major} pain; 
  take my word for it!
  \end{itemize}

  \only<1>{
  \begin{textblock}{6}(1.5,11)
  \small
  for example\\
  \begin{tabular}{l@ {\hspace{2mm}}l}
   & a $\fresh$ Lam [a]. t\\
   & Lam [a]. (Var a) \alert{$=$} Lam [b]. (Var b)\\
   & Barendregt-style reasoning about bound variables\\
   & (variable convention can lead to faulty reasoning)
  \end{tabular}
  \end{textblock}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{}

  \begin{tabular}{c@ {\hspace{2mm}}c}
  \\[6mm]
  \begin{tabular}{c}
  \includegraphics[scale=0.11]{harper.jpg}\\[-2mm]
  {\footnotesize Bob Harper}\\[-2.5mm]
  {\footnotesize (CMU)}
  \end{tabular}
  \begin{tabular}{c}
  \includegraphics[scale=0.37]{pfenning.jpg}\\[-2mm]
  {\footnotesize Frank Pfenning}\\[-2.5mm]
  {\footnotesize (CMU)}
  \end{tabular} &

  \begin{tabular}{p{6cm}}
  \raggedright
  \color{gray}{published a proof in\\ {\bf ACM Transactions on Computational Logic}, 2005,
  $\sim$31pp}
  \end{tabular}\\

  \pause
  \\[0mm]
  
  \begin{tabular}{c}
  \includegraphics[scale=0.36]{appel.jpg}\\[-2mm] 
  {\footnotesize Andrew Appel}\\[-2.5mm]
  {\footnotesize (Princeton)}
  \end{tabular} &

  \begin{tabular}{p{6cm}}
  \raggedright
  \color{gray}{relied on their proof in a\\ {\bf security} critical application}
  \end{tabular}
  \end{tabular}\medskip\pause

  \small
  \begin{minipage}{1.0\textwidth}
  (I also found an {\bf error} in my Ph.D.-thesis about cut-elimination
  examined by Henk Barendregt and Andy Pitts.)
  \end{minipage}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\begin{tabular}{c}Binding in Old Nominal\end{tabular}}

  \begin{itemize}
  \item<1-> but representing 

  \begin{center}
  $\forall\{a_1,\ldots,a_n\}.\; T$ 
  \end{center}\medskip

  with single binders and reasoning about it was a \alert{\bf major} pain; 
  take my word for it!
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-6>
  \frametitle{New Types in HOL}

   \begin{center}
  \begin{tikzpicture}[scale=1.5]
  %%%\draw[step=2mm] (-4,-1) grid (4,1);
  
  \onslide<2-4,6>{\draw[very thick] (0.7,0.4) circle (4.25mm);}
  \onslide<1-4,6>{\draw[rounded corners=1mm, very thick] ( 0.0,-0.8) rectangle ( 1.8, 0.9);}
  \onslide<3-5,6>{\draw[rounded corners=1mm, very thick] (-1.95,0.85) rectangle (-2.85,-0.05);}
  
  \onslide<3-4,6>{\draw (-2.0, 0.845) --  (0.7,0.845);}
  \onslide<3-4,6>{\draw (-2.0,-0.045)  -- (0.7,-0.045);}

  \onslide<4-4,6>{\alert{\draw ( 0.7, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-\\[-1mm]classes\end{tabular}};}}
  \onslide<4-5,6>{\alert{\draw (-2.4, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-eq.\\[-1mm]terms\end{tabular}};}}
  \onslide<1-4,6>{\draw (1.8, 0.48) node[right=-0.1mm]
    {\footnotesize\begin{tabular}{@ {}l@ {}}existing\\[-1mm] type\\ \onslide<4-4,6>{\alert{(sets of raw terms)}}\end{tabular}};}
  \onslide<2-4,6>{\draw (0.9, -0.35) node {\footnotesize\begin{tabular}{@ {}l@ {}}non-empty\\[-1mm]subset\end{tabular}};}
  \onslide<3-5,6>{\draw (-3.25, 0.55) node {\footnotesize\begin{tabular}{@ {}l@ {}}new\\[-1mm]type\end{tabular}};}
  
  \onslide<3-4,6>{\draw[<->, very thick] (-1.8, 0.3) -- (-0.1,0.3);}
  \onslide<3-4,6>{\draw (-0.95, 0.3) node[above=0mm] {\footnotesize{}isomorphism};}

  \onslide<6>{\draw[->, line width=2mm, red] (-1.0,-0.4) -- (0.35,0.16);}
  \end{tikzpicture}
  \end{center}
  
  \begin{center}
  \textcolor{red}{\large\bf\onslide<6>{define $\alpha$-equivalence}}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>
  \frametitle{\begin{tabular}{c}Binding Sets of Names\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item binding sets of names has some interesting properties:\medskip
  
  \begin{center}
  \begin{tabular}{l}
  \textcolor{blue}{$\forall\{x, y\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{y, x\}.\, y \rightarrow x$}
  \bigskip\smallskip\\

  \onslide<2->{%
  \textcolor{blue}{$\forall\{x, y\}.\, x \rightarrow y \;\;\not\approx_\alpha\;\; \forall\{z\}.\, z \rightarrow z$}
  }\bigskip\smallskip\\

  \onslide<3->{%
  \textcolor{blue}{$\forall\{x\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{x, \alert{z}\}.\, x \rightarrow y$}
  }\medskip\\
  \onslide<3->{\hspace{4cm}\small provided $z$ is fresh for the type}
  \end{tabular}
  \end{center}
  \end{itemize}
  
  \begin{textblock}{8}(2,14.5)
  \footnotesize $^*$ $x$, $y$, $z$ are assumed to be distinct
  \end{textblock}

  \only<4>{
  \begin{textblock}{6}(2.5,4)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize\color{darkgray}
  \begin{minipage}{8cm}\raggedright
  For type-schemes the order of bound names does not matter, and
  $\alpha$-equivalence is preserved under \alert{vacuous} binders.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Other Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item alpha-equivalence being preserved under vacuous binders is \underline{not} always
  wanted:\bigskip\bigskip\normalsize
  
  \textcolor{blue}{\begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;x = 3\;\text{and}\;y = 2\;\text{in}\;x - y\;\text{end}$\medskip\\
  \onslide<2->{$\;\;\;\only<2>{\approx_\alpha}\only<3>{\alert{\not\approx_\alpha}}
   \text{let}\;y = 2\;\text{and}\;x = 3\only<3->{\alert{\;\text{and}
    \;z = \text{loop}}}\;\text{in}\;x - y\;\text{end}$}
  \end{tabular}}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}\LARGE{}Even Another Binding Mode\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item sometimes one wants to abstract more than one name, but the order \underline{does} matter\bigskip
  
  \begin{center}
  \textcolor{blue}{\begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;(x, y) = (3, 2)\;\text{in}\;x - y\;\text{end}$\medskip\\
  $\;\;\;\not\approx_\alpha
   \text{let}\;(y, x) = (3, 2)\;\text{in}\;x - y\;\text{end}$
  \end{tabular}}
  \end{center}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}\LARGE{}Three Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item the order does not matter and alpha-equivelence is preserved under
  vacuous binders \textcolor{gray}{(restriction)}\medskip
  
  \item the order does not matter, but the cardinality of the binders 
  must be the same \textcolor{gray}{(abstraction)}\medskip

  \item the order does matter \textcolor{gray}{(iterated single binders)}
  \end{itemize}

  \onslide<2->{
  \begin{center}
  \isacommand{bind (set+)}\hspace{6mm}
  \isacommand{bind (set)}\hspace{6mm}
  \isacommand{bind}
  \end{center}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Specification of Binding\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam \only<2->{x::}name \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} x \isacommand{in} t}\\
  \hspace{5mm}$|$ Let \only<2->{as::}assns \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} bn(as) \isacommand{in} t}\\
  \multicolumn{2}{l}{\isacommand{and} assns $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assns}\\
  \multicolumn{2}{l}{\onslide<3->{\isacommand{binder} bn \isacommand{where}}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ []}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}$|$ bn(ACons a t as) $=$ [a] @ bn(as)}}\\
  \end{tabular}



  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2,4-8>
  \frametitle{\begin{tabular}{c}Alpha-Equivalence\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets first look at pairs\bigskip\medskip

  \textcolor{blue}{\begin{tabular}{@ {\hspace{1cm}}l}
  $(as, x) \onslide<2->{\approx\!}\makebox[5mm][l]{\only<2-6>{${}_{\text{set}}$}%
           \only<7>{${}_{\text{\alert{list}}}$}%
           \only<8>{${}_{\text{\alert{set+}}}$}}%
           \,\onslide<2->{(bs,y)}$
  \end{tabular}}\bigskip
  \end{itemize}

  \only<1>{
  \begin{textblock}{8}(3,8.5)
  \begin{tabular}{l@ {\hspace{2mm}}p{8cm}}
   & \textcolor{blue}{$as$} is a set of names\ldots the binders\\
   & \textcolor{blue}{$x$} is the body (might be a tuple)\\
   & \textcolor{blue}{$\approx_{\text{set}}$} is where the cardinality 
  of the binders has to be the same\\
  \end{tabular}
  \end{textblock}}

  \only<4->{
  \begin{textblock}{12}(5,8)
  \textcolor{blue}{
  \begin{tabular}{ll@ {\hspace{1mm}}l}
  $\dn$ & \onslide<5->{$\exists \pi.\,$} & $\text{fv}(x) - as = \text{fv}(y) - bs$\\[1mm]
        & \onslide<5->{$\;\;\;\wedge$} & \onslide<5->{$\text{fv}(x) - as \fresh^* \pi$}\\[1mm]
        & \onslide<5->{$\;\;\;\wedge$} & \onslide<5->{$(\pi \act x) = y$}\\[1mm]
        & \only<6-7>{$\;\;\;\wedge$}\only<8>{\textcolor{gray}{\xout{$\;\;\;\wedge$}}} & 
          \only<6-7>{$\pi \act as = bs$}\only<8>{\textcolor{gray}{\xout{$\pi \act as = bs$}}}\\
  \end{tabular}}
  \end{textblock}}
  
  \only<7>{
  \begin{textblock}{7}(3,13.8)
  \footnotesize $^*$ $as$ and $bs$ are \alert{lists} of names 
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets look at type-schemes:\medskip\medskip

  \begin{center}
  \textcolor{blue}{$(as, x) \approx\!\makebox[5mm][l]{${}_{\text{set}}$} (bs, y)$}
  \end{center}\medskip

  \onslide<2->{
  \begin{center}
  \textcolor{blue}{
  \begin{tabular}{l}
  $\text{fv}(x) = \{x\}$\\[1mm]
  $\text{fv}(T_1 \rightarrow T_2) = \text{fv}(T_1) \cup \text{fv}(T_2)$\\
  \end{tabular}}
  \end{center}}
  \end{itemize}

  
  \only<3->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<3->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<3->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \textcolor{blue}{
  \only<1>{$(\{x, y\}, x \rightarrow y) \approx_? (\{x, y\}, y \rightarrow x)$}
  \only<2>{$([x, y], x \rightarrow y) \approx_? ([x, y], y \rightarrow x)$}}
  \end{center}

  \begin{itemize}
  \item \textcolor{blue}{$\approx_{\text{set+}}$, $\approx_{\text{set}}$% 
  \only<2>{, \alert{$\not\approx_{\text{list}}$}}}
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \textcolor{blue}{\only<1>{$(\{x\}, x) \approx_? (\{x, y\}, x)$}}
  \end{center}

  \begin{itemize}
  \item \textcolor{blue}{$\approx_{\text{set+}}$, $\not\approx_{\text{set}}$,
        $\not\approx_{\text{list}}$}
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \only<2>{
  \begin{textblock}{6}(2.5,4)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=5mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize
  \begin{minipage}{8cm}\raggedright
  \begin{itemize}
  \item \color{darkgray}$\alpha$-equivalences coincide when a single name is
  abstracted
  \item \color{darkgray}in that case they are equivalent to ``old-fashioned'' definitions of $\alpha$ 
  \end{itemize}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Our Specifications\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam x::name t::trm
  & \isacommand{bind} x \isacommand{in} t\\
  \hspace{5mm}$|$ Let as::assns t::trm
  & \isacommand{bind} bn(as) \isacommand{in} t\\
  \multicolumn{2}{l}{\isacommand{and} assns $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assns}\\
  \multicolumn{2}{l}{\isacommand{binder} bn \isacommand{where}}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ $[]$}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)}\\
  \end{tabular}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{\begin{tabular}{c}Binder Clauses\end{tabular}}

  \begin{itemize}
  \item We need  to have a `clear scope' for a bound variable, and bound
  variables should not be free and bound at the same time.\bigskip
  \end{itemize}

  \begin{center}
  \only<1>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  \alert{\bf shallow binders}\\ 
  \hspace{4mm}Lam x::name t::trm\hspace{4mm} \isacommand{bind} x \isacommand{in} t\\
  \hspace{4mm}All xs::name set T::ty\hspace{4mm} \isacommand{bind} xs \isacommand{in} T\\
  \hspace{4mm}Foo x::name t$_1$::trm t$_2$::trm\hspace{4mm} 
     \isacommand{bind} x \isacommand{in} t$_1$, \isacommand{bind} x \isacommand{in} t$_2$\\
  \hspace{4mm}Bar x::name t$_1$::trm t$_2$::trm\hspace{4mm} 
     \isacommand{bind} x \isacommand{in} t$_1$ t$_2$\\
  \end{tabular}}
  \only<2>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  \alert{\bf deep binders} \\
  \hspace{4mm}Let as::assns t::trm\hspace{4mm} \isacommand{bind} bn(as) \isacommand{in} t\\
  \hspace{4mm}Foo as::assns t$_1$::trm t$_2$::trm\\
  \hspace{20mm}\isacommand{bind} bn(as) \isacommand{in} t$_1$, \isacommand{bind} bn(as) \isacommand{in} t$_2$\\[4mm]
  \makebox[0mm][l]{\alert{$\times$}}\hspace{4mm}Bar as::assns t$_1$::trm t$_2$::trm\\
  \hspace{20mm}\isacommand{bind} bn$_1$(as) \isacommand{in} t$_1$, \isacommand{bind} bn$_2$(as) \isacommand{in} t$_2$\\
  \end{tabular}}
  \only<3>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  {\bf deep \alert{recursive} binders} \\
  \hspace{4mm}Let\_rec as::assns t::trm\hspace{4mm} \isacommand{bind} bn(as) \isacommand{in} t as\\[4mm]

  \makebox[0mm][l]{\alert{$\times$}}\hspace{4mm}Foo\_rec as::assns t$_1$::trm t$_2$::trm\hspace{4mm}\\ 
  \hspace{20mm}\isacommand{bind} bn(as) \isacommand{in} t$_1$ as, \isacommand{bind} bn(as) \isacommand{in} t$_2$\\

  \end{tabular}}
  \end{center}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-5>
  \frametitle{\begin{tabular}{c}Our Work\end{tabular}}
  \mbox{}\\[-6mm]

    \begin{center}
  \begin{tikzpicture}[scale=1.5]
  %%%\draw[step=2mm] (-4,-1) grid (4,1);
  
  \onslide<1>{\draw[very thick] (0.7,0.4) circle (4.25mm);}
  \onslide<1>{\draw[rounded corners=1mm, very thick] ( 0.0,-0.8) rectangle ( 1.8, 0.9);}
  \onslide<1->{\draw[rounded corners=1mm, very thick] (-1.95,0.85) rectangle (-2.85,-0.05);}
  
  \onslide<1>{\draw (-2.0, 0.845) --  (0.7,0.845);}
  \onslide<1>{\draw (-2.0,-0.045)  -- (0.7,-0.045);}

  \onslide<1>{\alert{\draw ( 0.7, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-\\[-1mm]classes\end{tabular}};}}
  \onslide<1->{\alert{\draw (-2.4, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-eq.\\[-1mm]terms\end{tabular}};}}
  \onslide<1>{\draw (1.8, 0.48) node[right=-0.1mm]
    {\footnotesize\begin{tabular}{@ {}l@ {}}existing\\[-1mm] type\\ \onslide<1>{\alert{(sets of raw terms)}}\end{tabular}};}
  \onslide<1>{\draw (0.9, -0.35) node {\footnotesize\begin{tabular}{@ {}l@ {}}non-empty\\[-1mm]subset\end{tabular}};}
  \onslide<1->{\draw (-3.25, 0.55) node {\footnotesize\begin{tabular}{@ {}l@ {}}new\\[-1mm]type\end{tabular}};}
  
  \onslide<1>{\draw[<->, very thick] (-1.8, 0.3) -- (-0.1,0.3);}
  \onslide<1>{\draw (-0.95, 0.3) node[above=0mm] {\footnotesize{}isomorphism};}

  \onslide<1>{\draw[->, line width=2mm, red] (-1.0,-0.4) -- (0.35,0.16);}
  \end{tikzpicture}
  \end{center}
  
  \begin{textblock}{9.5}(6,3.5)
  \begin{itemize}
  \item<1-> defined fv and $\alpha$
  \item<2-> built quotient / new type
  \item<3-> derived a reasoning infrastructure ($\fresh$, distinctness, injectivity, cases,\ldots) 
  \item<4-> derive a {\bf stronger} cases lemma
  \item<5-> from this, a {\bf stronger} induction principle (Barendregt variable convention built in)\\
  \begin{center}
  \textcolor{blue}{Foo ($\lambda x. \lambda y. t$) ($\lambda u. \lambda v. s$)} 
  \end{center}
  \end{itemize}
  \end{textblock}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Part I: Conclusion\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item the user does not see anything of the raw level\medskip
  \only<1>{\begin{center}
  Lam a (Var a) \alert{$=$} Lam b (Var b)
  \end{center}\bigskip}

  \item<2-> \textcolor{blue}{http://isabelle.in.tum.de/nominal/}
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Part II: $\alpha\beta$-Equal Terms\end{tabular}}

  \begin{itemize}
  \item we have implemented a quotient package for Isabelle;
  \item can now introduce the type of $\alpha\beta$-equal terms (starting
  from $\alpha$-equal terms).
  \item on paper this looks easy\pause\bigskip
  \end{itemize}

  \begin{center}
  \begin{tabular}{lll}
  \smath{x \approx_{\alpha\beta} y} & \smath{\;\not\Rightarrow\;} & 
  \smath{\text{supp}(x) = \text{supp}(y)}\\
  & \smath{\;\not\Rightarrow\;} & 
  \smath{\text{size}(x) = \text{size}(y)}\\
  \end{tabular}
  \end{center}\pause

  \small
  \begin{center}
  Andy: \smath{\;\;\text{supp}\mbox{\isasymlbrakk}x\mbox{\isasymrbrakk}_{\approx_{\alpha\beta}} = 
  {\text{\large$\bigcap$}} \{ \text{supp}(y) \;|\; y \approx_{\alpha\beta} x\}}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{}

  \begin{center}
  \begin{tabular}{rcl}
  \smath{x\;[y := s]} &           \smath{\dn} & \smath{\text{if}\;x=y\;\text{then}\;s\;\text{else}\;x}\bigskip\\
  \smath{t_1 t_2\;[y := s]} &     \smath{\dn} & \smath{t_1[y := s]\;t_2[y := s]}\bigskip\\
  \smath{\lambda x.t\;[y := s]} & \smath{\dn} & \smath{\lambda x.\; t[y := s]}\\
  \multicolumn{3}{r}{provided \smath{x \fresh (y, s)}}
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\begin{tabular}{c}Part III: Regular Languages\\[-8mm]\end{tabular}}

  \begin{center}
  \huge\bf\textcolor{gray}{in Theorem Provers}\\
  \footnotesize\textcolor{gray}{e.g.~Isabelle, Coq, HOL4, \ldots}
  \end{center}

  \begin{itemize}
  \item automata @{text "\<Rightarrow>"} graphs, matrices, functions
  \item<2-> combining automata/graphs

  \onslide<2->{
  \begin{center}
  \begin{tabular}{ccc}
  \begin{tikzpicture}[scale=1]
  %\draw[step=2mm] (-1,-1) grid (1,1);
  
  \draw[rounded corners=1mm, very thick] (-1.0,-0.3) rectangle (-0.2,0.3);
  \draw[rounded corners=1mm, very thick] ( 0.2,-0.3) rectangle ( 1.0,0.3);

  \node (A) at (-1.0,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (B) at ( 0.2,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \node (C) at (-0.2, 0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (D) at (-0.2,-0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \node (E) at (1.0, 0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (F) at (1.0,-0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (G) at (1.0,-0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \draw (-0.6,0.0) node {\small$A_1$};
  \draw ( 0.6,0.0) node {\small$A_2$};
  \end{tikzpicture}}

  & 

  \onslide<3->{\raisebox{1.1mm}{\bf\Large$\;\Rightarrow\,$}}

  &

  \onslide<3->{\begin{tikzpicture}[scale=1]
  %\draw[step=2mm] (-1,-1) grid (1,1);
  
  \draw[rounded corners=1mm, very thick] (-1.0,-0.3) rectangle (-0.2,0.3);
  \draw[rounded corners=1mm, very thick] ( 0.2,-0.3) rectangle ( 1.0,0.3);

  \node (A) at (-1.0,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (B) at ( 0.2,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \node (C) at (-0.2, 0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (D) at (-0.2,-0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \node (E) at (1.0, 0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (F) at (1.0,-0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (G) at (1.0,-0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \draw (C) to [red, very thick, bend left=45] (B);
  \draw (D) to [red, very thick, bend right=45] (B);

  \draw (-0.6,0.0) node {\small$A_1$};
  \draw ( 0.6,0.0) node {\small$A_2$};
  \end{tikzpicture}}

  \end{tabular}
  \end{center}\medskip

  \only<4-5>{
  \begin{tabular}{@ {\hspace{-5mm}}l@ {}}
  disjoint union:\\[2mm]
  \smath{A_1\uplus A_2 \dn \{(1, x)\,|\, x \in A_1\} \,\cup\, \{(2, y)\,|\, y \in A_2\}}
  \end{tabular}}
  \end{itemize}

  \only<5>{
  \begin{textblock}{13.9}(0.7,7.7)
  \begin{block}{}
  \medskip
  \begin{minipage}{14cm}\raggedright
  Problems with definition for regularity:\bigskip\\
  \smath{\;\text{is\_regular}(A) \dn \exists M.\;\text{is\_dfa}(M) \wedge {\cal L} (M) = A}\bigskip
  \end{minipage}
  \end{block}
  \end{textblock}}
  \medskip

  \only<6->{\underline{A solution}:\;\;use \smath{\text{nat}}s \;@{text "\<Rightarrow>"}\; state nodes\medskip}

  \only<7->{You have to \alert{rename} states!}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\normalsize Formal language theory\ldots\hfill\mbox{}}
  \mbox{}\\[-15mm]\mbox{}

  \begin{center}
  \huge\bf\textcolor{gray}{in Theorem Provers}\\
  \footnotesize\textcolor{gray}{e.g.~Isabelle, Coq, HOL4, \ldots}
  \end{center}

  \begin{itemize}
  \item Kozen's ``paper'' proof of Myhill-Nerode:\\ 
  \hspace{2cm}requires absence of \alert{inaccessible states}
  \end{itemize}\bigskip\bigskip

  \begin{center}
  \smath{\;\text{is\_regular}(A) \dn \exists M.\;\text{is\_dfa}(M) \wedge {\cal L} (M) = A}
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{}
  \mbox{}\\[25mm]\mbox{}

  \begin{textblock}{13.9}(0.7,1.2)
  \begin{block}{}
  \begin{minipage}{13.4cm}\raggedright
  {\bf Definition:}\smallskip\\
  
  A language \smath{A} is \alert{regular}, provided there exists a\\ 
  \alert{regular expression} that matches all strings of \smath{A}.
  \end{minipage}
  \end{block}
  \end{textblock}\pause
  
  {\noindent\large\bf\alert{\ldots{}and forget about automata}}\bigskip\bigskip\pause

  Infrastructure for free. But do we lose anything?\medskip\pause

  \begin{minipage}{1.1\textwidth}
  \begin{itemize}
  \item pumping lemma\pause
  \item closure under complementation\pause
  \item \only<6>{regular expression matching}%
       \only<7->{\soutt{regular expression matching}
  {\footnotesize(@{text "\<Rightarrow>"}Brozowski'64, Owens et al '09)}}
  \item<8-> most textbooks are about automata
  \end{itemize}
  \end{minipage}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Myhill-Nerode Theorem}

  \begin{itemize}
  \item provides necessary and suf\!ficient conditions\\ for a language 
  being regular\\ \textcolor{gray}{(pumping lemma only necessary)}\bigskip

  \item key is the equivalence relation:\medskip
  \begin{center}
  \smath{x \approx_{A} y \,\dn\, \forall z.\; x @ z \in A \Leftrightarrow y @ z \in A}
  \end{center}
  \end{itemize}

 
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Myhill-Nerode Theorem}

  \begin{center}
  \only<1>{%
  \begin{tikzpicture}[scale=3]
  \draw[very thick] (0.5,0.5) circle (.6cm);
  \end{tikzpicture}}%
  \only<2->{%
  \begin{tikzpicture}[scale=3]
  \draw[very thick] (0.5,0.5) circle (.6cm);
  \clip[draw] (0.5,0.5) circle (.6cm);
  \draw[step=2mm, very thick] (-1.4,-1.4) grid (1.4,1.4);
  \end{tikzpicture}}
  \end{center}
  
  \begin{itemize}
  \item \smath{\text{finite}\, (U\!N\!IV /\!/ \approx_A) \;\Leftrightarrow\; A\; \text{is regular}}
  \end{itemize}

  \begin{textblock}{5}(2.1,5.3)
  \begin{tikzpicture}
  \node at (0,0) [single arrow, fill=red,text=white, minimum height=2cm]
  {$U\!N\!IV$};
  \draw (-0.3,-1.1) node {\begin{tabular}{l}set of all\\[-1mm] strings\end{tabular}};
  \end{tikzpicture}
  \end{textblock}

  \only<2->{%
  \begin{textblock}{5}(9.1,7.2)
  \begin{tikzpicture}
  \node at (0,0) [shape border rotate=180,single arrow, fill=red,text=white, minimum height=2cm]
  {@{text "\<lbrakk>x\<rbrakk>"}$_{\approx_{A}}$};
  \draw (0.9,-1.1) node {\begin{tabular}{l}an equivalence class\end{tabular}};
  \end{tikzpicture}
  \end{textblock}}

  \only<3->{
  \begin{textblock}{11.9}(1.7,3)
  \begin{block}{}
  \begin{minipage}{11.4cm}\raggedright
  Two directions:\medskip\\
  \begin{tabular}{@ {}ll}
  1.)\;finite $\Rightarrow$ regular\\
  \;\;\;\smath{\text{finite}\,(U\!N\!IV /\!/ \approx_A) \Rightarrow \exists r.\;A = {\cal L}(r)}\\[3mm]
  2.)\;regular $\Rightarrow$ finite\\
  \;\;\;\smath{\text{finite}\, (U\!N\!IV /\!/ \approx_{{\cal L}(r)})}
  \end{tabular}

  \end{minipage}
  \end{block}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<-1>[c]
  \frametitle{\begin{tabular}{@ {}l}\LARGE% 
  Transitions between Eq-Classes\end{tabular}}

  \begin{center}
  \begin{tikzpicture}[scale=3]
  \draw[very thick] (0.5,0.5) circle (.6cm);
  \clip[draw] (0.5,0.5) circle (.6cm);
  \draw[step=2mm, very thick] (-1.4,-1.4) grid (1.4,1.4);
  \draw[blue, fill] (0.0, 0.6) rectangle (0.2, 0.8);
  \draw[blue, fill] (0.8, 0.4) rectangle (1.0, 0.6);
  \draw[white] (0.1,0.7) node (X) {$X$};
  \draw[white] (0.9,0.5) node (Y) {$Y$};
  \draw[blue, ->, line width = 2mm, bend left=45] (X) -- (Y);
  \node [inner sep=1pt,label=above:\textcolor{blue}{$c$}] at ($ (X)!.5!(Y) $) {};
  \end{tikzpicture}
  \end{center}

  \begin{center}
  \smath{X \stackrel{c}{\longrightarrow} Y \;\dn\; X ; c \subseteq Y}
  \end{center}

  \onslide<8>{
  \begin{tabular}{c}
  \begin{tikzpicture}[shorten >=1pt,node distance=2cm,auto, ultra thick]
  \tikzstyle{state}=[circle,thick,draw=blue!75,fill=blue!20,minimum size=0mm]
  \node[state,initial] (q_0) {$R_1$};
  \end{tikzpicture}
  \end{tabular}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Other Direction}

  One has to prove

  \begin{center}
  \smath{\text{finite} (U\!N\!IV /\!/ \approx_{{\cal L}(r)})}
  \end{center}

  by induction on \smath{r}. Not trivial, but after a bit 
  of thinking, one can find a \alert{refined} relation:\bigskip

  
  \begin{center}
  \mbox{\begin{tabular}{c@ {\hspace{7mm}}c@ {\hspace{7mm}}c}
  \begin{tikzpicture}[scale=1.1]
  %Circle
  \draw[thick] (0,0) circle (1.1);    
  \end{tikzpicture}
  &
  \begin{tikzpicture}[scale=1.1]
  %Circle
  \draw[thick] (0,0) circle (1.1);    
  %Main rays
  \foreach \a in {0, 90,...,359}
    \draw[very thick] (0, 0) -- (\a:1.1);
  \foreach \a / \l in {45/1, 135/2, 225/3, 315/4}
      \draw (\a: 0.65) node {\small$a_\l$};
  \end{tikzpicture}
  &
  \begin{tikzpicture}[scale=1.1]
  %Circle
  \draw[red, thick] (0,0) circle (1.1);    
  %Main rays
  \foreach \a in {0, 45,...,359}
     \draw[red, very thick] (0, 0) -- (\a:1.1);
  \foreach \a / \l in {22.5/1.1, 67.5/1.2, 112.5/2.1, 157.5/2.2, 202.4/3.1, 247.5/3.2, 292.5/4.1, 337.5/4.2}
      \draw (\a: 0.77) node {\textcolor{red}{\footnotesize$a_{\l}$}};
  \end{tikzpicture}\\
  \small\smath{U\!N\!IV} & 
  \small\smath{U\!N\!IV /\!/ \approx_{{\cal L}(r)}} &
  \small\smath{U\!N\!IV /\!/ \alert{R}}
  \end{tabular}}
  \end{center}

  \begin{textblock}{5}(9.8,2.6)
  \begin{tikzpicture}
  \node at (0,0) [shape border rotate=270,single arrow, fill=red,text=white, minimum height=0cm]{\textcolor{red}{a}};
  \end{tikzpicture}
  \end{textblock}
  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\LARGE\begin{tabular}{c}Derivatives of RExps\end{tabular}}

  \begin{itemize}
  \item introduced by Brozowski~'64
  \item a regular expressions after a character has been parsed\\[-18mm]\mbox{}
  \end{itemize}

  \only<1>{%
  \textcolor{blue}{%
  \begin{center}
  \begin{tabular}{@ {}lc@ {\hspace{3mm}}l@ {}}
  der c $\varnothing$     & $\dn$ & $\varnothing$\\
  der c []                & $\dn$ & $\varnothing$\\
  der c d                 & $\dn$ & if c $=$ d then [] else $\varnothing$\\
  der c ($r_1 + r_2$)     & $\dn$ & (der c $r_1$) $+$ (der c $r_2$)\\
  der c ($r^\star$)       & $\dn$ & (der c $r$) $\cdot$ $r^\star$\\
  der c ($r_1 \cdot r_2$) & $\dn$ & if nullable $r_1$\\
                          &       & then (der c $r_1$) $\cdot$ $r_2$ $+$ (der c $r_2$)\\
                          &       & else (der c $r_1$) $\cdot$ $r_2$\\
  \end{tabular}
  \end{center}}}
  \only<2>{%
  \textcolor{blue}{%
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {}}
  pder c $\varnothing$     & $\dn$ & \alert{$\{\}$}\\
  pder c []                & $\dn$ & \alert{$\{\}$}\\
  pder c d                 & $\dn$ & if c $=$ d then $\{$[]$\}$ else $\{\}$\\
  pder c ($r_1 + r_2$)     & $\dn$ & (pder c $r_1$) \alert{$\cup$} (der c $r_2$)\\
  pder c ($r^\star$)       & $\dn$ & (pder c $r$) $\cdot$ $r^\star$\\
  pder c ($r_1 \cdot r_2$) & $\dn$ & if nullable $r_1$\\
                          &       & then (pder c $r_1$) $\cdot$ $r_2$ \alert{$\cup$} (pder c $r_2$)\\
                          &       & else (pder c $r_1$) $\cdot$ $r_2$\\
  \end{tabular}
  \end{center}}}

  \only<2>{
  \begin{textblock}{6}(8.5,4.7)
  \begin{block}{}
  \begin{quote}
  \begin{minipage}{6cm}\raggedright
  \begin{itemize}
  \item partial derivatives
  \item by Antimirov~'95
  \end{itemize}
  \end{minipage}
  \end{quote}
  \end{block}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\LARGE Partial Derivatives}

  \mbox{}\\[0mm]\mbox{}

  \begin{itemize}

  \item \alt<1>{\smath{\text{pders $x$ $r$ \mbox{$=$} pders $y$ $r$}}}
            {\smath{\underbrace{\text{pders $x$ $r$ \mbox{$=$} pders $y$ $r$}}_{R}}} 
        refines \textcolor{blue}{$x$ $\approx_{{\cal L}(r)}$ $y$}\\[16mm]\pause
  \item \smath{\text{finite} (U\!N\!IV /\!/ R)} \bigskip\pause
  \item Therefore \smath{\text{finite} (U\!N\!IV /\!/ \approx_{{\cal L}(r)})}. Qed.
  \end{itemize}
  
  \only<2->{%
  \begin{textblock}{5}(3.9,7.2)
  \begin{tikzpicture}
  \node at (0,0) [shape border rotate=270,single arrow, fill=red,text=white, minimum height=0cm]{\textcolor{red}{a}};
  \draw (2.2,0) node {Antimirov '95};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\LARGE What Have We Achieved?}

  \begin{itemize}
  \item \smath{\text{finite}\, (U\!N\!IV /\!/ \approx_A) \;\Leftrightarrow\; A\; \text{is regular}}
  \medskip\pause
  \item regular languages are closed under complementation; this is now easy
  \begin{center}
  \smath{U\!N\!IV /\!/ \approx_A \;\;=\;\; U\!N\!IV /\!/ \approx_{\overline{A}}}
  \end{center}\pause\medskip
  
  \item non-regularity (\smath{a^nb^n})\medskip\pause\pause

  \item take \alert{\bf any} language; build the language of substrings\\
  \pause

  then this language \alert{\bf is} regular\;\; (\smath{a^nb^n} $\Rightarrow$ \smath{a^\star{}b^\star})
  
  \end{itemize}

\only<2>{
\begin{textblock}{10}(4,14)
\small
\smath{x \approx_{A} y \,\dn\, \forall z.\; x @ z \in A \Leftrightarrow y @ z \in A}
\end{textblock}} 

\only<4>{
\begin{textblock}{5}(2,8.6)
\begin{minipage}{8.8cm}
\begin{block}{}
\begin{minipage}{8.6cm}
If there exists a sufficiently large set \smath{B} (for example infinitely large), 
such that

\begin{center}
\smath{\forall x,y \in B.\; x \not= y \;\Rightarrow\; x \not\approx_{A} y}. 
\end{center}  

then \smath{A} is not regular.\hspace{1.3cm}\small(\smath{B \dn \bigcup_n a^n})
\end{minipage}
\end{block}
\end{minipage}
\end{textblock}
}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[b]
  \frametitle{\mbox{}\\[2cm]\textcolor{red}{Thank you!\\[5mm]Questions?}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}




text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>[c]
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-6mm]

  \textcolor{blue}{
  \begin{center}
  $(\{a,b\}, a \rightarrow b) \approx_\alpha (\{a, b\}, a \rightarrow b)$
  $(\{a,b\}, a \rightarrow b) \approx_\alpha (\{a, b\}, b \rightarrow a)$
  \end{center}}

  \textcolor{blue}{
  \begin{center}
  $(\{a,b\}, (a \rightarrow b, a \rightarrow b))$\\ 
  \hspace{17mm}$\not\approx_\alpha (\{a, b\}, (a \rightarrow b, b \rightarrow a))$
  \end{center}}
  
  \onslide<2->
  {1.) \hspace{3mm}\isacommand{bind (set)} as \isacommand{in} $\tau_1$, 
   \isacommand{bind (set)} as \isacommand{in} $\tau_2$\medskip

   2.) \hspace{3mm}\isacommand{bind (set)} as \isacommand{in} $\tau_1$ $\tau_2$ 
  }

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



(*<*)
end
(*>*)