(*<*)
theory Slides3
imports "LaTeXsugar" "Nominal"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)

text_raw {*
  \renewcommand{\slidecaption}{UNIF, Edinburgh, 14.~July 2010}

  \newcommand{\abst}[2]{#1.#2}% atom-abstraction
  \newcommand{\pair}[2]{\langle #1,#2\rangle} % pairing
  \newcommand{\susp}{{\boldsymbol{\cdot}}}% for suspensions
  \newcommand{\unit}{\langle\rangle}% unit
  \newcommand{\app}[2]{#1\,#2}% application
  \newcommand{\eqprob}{\mathrel{{\approx}?}}
  \newcommand{\freshprob}{\mathrel{\#?}}
  \newcommand{\redu}[1]{\stackrel{#1}{\Longrightarrow}}% reduction
  \newcommand{\id}{\varepsilon}% identity substitution

  \pgfdeclareradialshading{smallbluesphere}{\pgfpoint{0.5mm}{0.5mm}}%
  {rgb(0mm)=(0,0,0.9);
  rgb(0.9mm)=(0,0,0.7);
  rgb(1.3mm)=(0,0,0.5);
  rgb(1.4mm)=(1,1,1)}

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Quiz}
  
  Assuming that \smath{a} and \smath{b} are distinct variables,\\
  is it possible to find $\lambda$-terms \smath{M_1} to \smath{M_7} 
  that make the following pairs \alert{$\alpha$-equivalent}?

  \begin{tabular}{@ {\hspace{14mm}}p{12cm}}
  \begin{itemize}
  \item \smath{\lambda a.\lambda b. (M_1\,b)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_1)\;}

  \item \smath{\lambda a.\lambda b. (M_2\,b)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_3)\;}

  \item \smath{\lambda a.\lambda b. (b\,M_4)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_5)\;}

  \item \smath{\lambda a.\lambda b. (b\,M_6)\;} and 
        \smath{\lambda a.\lambda a. (a\,M_7)\;}
  \end{itemize}
  \end{tabular}

  If there is one solution for a pair, can you describe all its solutions?

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{%
  \begin{tabular}{@ {\hspace{-3mm}}c@ {}}
  \\
  \huge Nominal Unification\\[-2mm] 
  \Large Hitting a Sweet Spot\\[5mm]
  \end{tabular}}
  \begin{center}
  Christian Urban
  \end{center}
  \begin{center}
  \small initial spark from Roy Dyckhoff in November 2001\\[0mm] 
  \small joint work with Andy Pitts and Jamie Gabbay\\[0mm] 
  \end{center}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}
text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>[c]
  \frametitle{One Motivation}

  \onslide<2->{Typing implemented in Prolog \textcolor{darkgray}{(from a textbook)}}\bigskip\\

  \onslide<3->{\color{darkgray}
  \begin{tabular}{l}
  type (Gamma, var(X), T) :- member (X,T) Gamma.\smallskip\medskip\\
  
  type (Gamma, app(M, N), T') :-\\
  \hspace{3cm}type (Gamma, M, arrow(T, T')),\\ 
  \hspace{3cm}type (Gamma, N, T).\smallskip\medskip\\
  
  type (Gamma, lam(X, M), arrow(T, T')) :-\\
  \hspace{3cm}type ((X, T)::Gamma, M, T').\smallskip\medskip\\
  
  member X X::Tail.\\
  member X Y::Tail :- member X Tail.\\
  \end{tabular}}
 
  \only<4>{
  \begin{textblock}{6}(2.5,2)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{8cm}\raggedright
  The problem is that \smath{\lambda x.\lambda x. (x\;x)}
  will have the types
  \begin{center}
  \begin{tabular}{l}
  \smath{T\rightarrow (T\rightarrow S) \rightarrow S} and\\ 
  \smath{(T\rightarrow S)\rightarrow T \rightarrow S}\\
  \end{tabular}
  \end{center}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Higher-Order Unification}

  State of the art at the time:

  \begin{itemize}
  \item Lambda Prolog with full Higher-Order Unification\\ 
  \textcolor{darkgray}{(no mgus, undecidable, modulo $\alpha\beta$)}\bigskip
  \item Higher-Order Pattern Unification\\ 
  \textcolor{darkgray}{(has mgus, decidable, some restrictions, modulo $\alpha\beta_0$)}
  \end{itemize}
 
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-10>[t]
  \frametitle{Underlying Ideas}

  \begin{itemize}
  \item<1-> Unification (\alert{only}) up to $\alpha$

  \item<2-> Swappings / Permutations

  \only<2-5>{
  \begin{center}
  \begin{tabular}{r@ {\hspace{1mm}}l@ {\hspace{12mm}}r@ {\hspace{1mm}}l}
  \\
  \only<2>{\smath{\textcolor{white}{[b\!:=\!a]}}}%
  \only<3>{\smath{[b\!:=\!a]}}%
  \only<4-5>{\smath{\alert{\swap{a}{b}\,\act}}} & 
  \onslide<2-5>{\smath{\lambda a.b}} &
  
  \only<2>{\smath{\textcolor{white}{[b\!:=\!a]}}}%
  \only<3>{\smath{[b\!:=\!a]}}%
  \only<4-5>{\smath{\alert{\swap{a}{b}\,\act}}} &
  \onslide<2-5>{\smath{\lambda c.b}}\\

  \onslide<3-5>{\smath{=}} & \only<3>{\smath{\lambda a.a}}\only<4-5>{\smath{\lambda b.a}} & 
  \onslide<3-5>{\smath{=}} & \only<3>{\smath{\lambda c.a}}\only<4-5>{\smath{\lambda c.a}}\\
  \end{tabular}
  \end{center}\bigskip

  \onslide<4-5>{
  \begin{center}
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=0mm,fill=cream, ultra thick, draw=cream] 
  {\begin{minipage}{8cm}
  \begin{tabular}{r@ {\hspace{3mm}}l}
  \smath{\swap{a}{b}\act t} $\;\dn$ & \alert{swap} {\bf all} occurrences of\\ 
                                  & \smath{b} and \smath{a} in \smath{t}
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{center}}\bigskip

  \onslide<5>{
  Unlike for \smath{[b\!:=\!a]\act(-)}, for \smath{\swap{a}{b}\act (-)} we do
  have if \smath{t =_\alpha t'} then \smath{\pi \act t =_\alpha \pi \act t'.}}}

  \item<6-> Variables (or holes)\bigskip

  \begin{center}
  \onslide<7->{\mbox{}\hspace{-25mm}\smath{\lambda x\hspace{-0.5mm}s .}}
  \onslide<8-9>{\raisebox{-1.7mm}{\huge\smath{(}}}\raisebox{-4mm}{\begin{tikzpicture}
  \fill[blue] (0, 0) circle (5mm);
  \end{tikzpicture}}
  \onslide<8-9>{\smath{y\hspace{-0.5mm}s}{\raisebox{-1.7mm}{\huge\smath{)}}}}\bigskip
  \end{center}

  \only<8-9>{\smath{y\hspace{-0.5mm}s} are the parameters the hole can depend on\onslide<9->{, but 
  then you need $\beta_0$-reduction\medskip
  \begin{center}
  \smath{(\lambda x. t) y \longrightarrow_{\beta_0} t[x:=y]}
  \end{center}}}

  \only<10>{we will record the information about which parameters a hole 
  \alert{\bf cannot} depend on}

  \end{itemize}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>[c]
  \frametitle{Terms}

  \begin{tabular}{lll @ {\hspace{10mm}}lll}

  \onslide<1->{\pgfuseshading{smallbluesphere}} & 
  \onslide<1->{\colorbox{cream}{\smath{\unit}}} &
  \onslide<1->{Units} &

  \onslide<2->{\pgfuseshading{smallbluesphere}} &
  \onslide<2->{\colorbox{cream}{\smath{a}}} &
  \onslide<2->{Atoms} \\[5mm]

  \onslide<1->{\pgfuseshading{smallbluesphere}} & 
  \onslide<1->{\colorbox{cream}{\smath{\pair{t}{t'}}}} &
  \onslide<1->{Pairs} &
  
  \onslide<3->{\pgfuseshading{smallbluesphere}} &
  \onslide<3->{\colorbox{cream}{\smath{\abst{a}{t}}}} &
  \onslide<3->{Abstractions}\\[5mm]

  \onslide<1->{\pgfuseshading{smallbluesphere}} & 
  \onslide<1->{\colorbox{cream}{\smath{\app{F}{t}}}} &
  \onslide<1->{Funct.} &

  \onslide<4->{\pgfuseshading{smallbluesphere}} &
  \onslide<4->{\colorbox{cream}{\smath{\pi\susp X}}} &
  \onslide<4->{Suspensions}
  \end{tabular}
 
  \only<2>{
  \begin{textblock}{13}(1.5,12)
  \small Atoms are constants \textcolor{darkgray}{(infinitely many of them)}
  \end{textblock}}

  \only<3>{
  \begin{textblock}{13}(1.5,12)
  \small \smath{\ulcorner \lambda\abst{a}{a}\urcorner \mapsto \text{fn\ }\abst{a}{a}}\\
  \small constructions like \smath{\text{fn\ }\abst{X}{X}} are not allowed
  \end{textblock}}

  \only<4>{
  \begin{textblock}{13}(1.5,12)
  \small \smath{X} is a variable standing for a term\\
  \small \smath{\pi} is an explicit permutation \smath{\swap{a_1}{b_1}\ldots\swap{a_n}{b_n}},
  waiting to be applied to the term that is substituted for \smath{X}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>[c]
  \frametitle{Permutations}

  a permutation applied to a term

  \begin{center}
  \begin{tabular}{lrcl}
  \pgfuseshading{smallbluesphere} &
  \smath{[]\act c} & \smath{\dn} & \smath{c} \\

  \pgfuseshading{smallbluesphere} &
  \smath{\swap{a}{b}\!::\!\pi\act c} & \smath{\dn} & 
  \smath{\begin{cases} 
  a & \text{if}\;\pi\act c = b\\
  b & \text{if}\;\pi\act c = a\\
  \pi\act c & \text{otherwise}
  \end{cases}}\\

  \onslide<2->{\pgfuseshading{smallbluesphere}} &
  \onslide<2->{\smath{\pi\act\abst{a}{t}}} & \onslide<2->{\smath{\dn}} & 
  \onslide<2->{\smath{\abst{\pi\act a}{\pi\act t}}}\\ 

  \onslide<3->{\pgfuseshading{smallbluesphere}} &
  \onslide<3->{\smath{\pi\act\pi'\act X}} & \onslide<3->{\smath{\dn}} & 
  \onslide<3->{\smath{(\pi @ \pi')\act X}}\\
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>[c]
  \frametitle{Freshness Constraints}

  Recall \smath{\lambda a. \raisebox{-0.7mm}{\tikz \fill[blue] (0, 0) circle (2.5mm);}}
  \bigskip\pause

  We therefore will identify

  \begin{center}
  \smath{\text{fn\ } a. X \;\approx\; \text{fn\ } b. \alert<3->{\swap{a}{b}}\act X}
  \end{center}

  provided that `\smath{b} is fresh for \smath{X} --- (\smath{b\fresh X})',
  i.e., does not occur freely in any ground term that might be substituted for
  \smath{X}.\bigskip\pause 

  If we know more about \smath{X}, e.g., if we knew that \smath{a\fresh X} and
  \smath{b\fresh X}, then we can replace\\ \smath{\swap{a}{b}\act X} by
  \smath{X}.

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>[c]
  \frametitle{Equivalence Judgements}

  \alt<1>{Our equality is {\bf not} just}{but judgements}

  \begin{center}
  \begin{tabular}{rl}
  \colorbox{cream}{\smath{\onslide<2->{\nabla \vdash} t \approx t'}} & \alert{$\alpha$-equivalence}\\[1mm]
  \onslide<4->{\colorbox{cream}{\smath{\onslide<2->{\nabla \vdash} a \fresh t}}} & 
  \onslide<4->{\alert{freshness}}
  \end{tabular}
  \end{center}

  \onslide<2->{
  where
  \begin{center}
  \smath{\nabla = \{a_1\fresh X_1,\ldots, a_n\fresh X_n\}}
  \end{center}
  is a finite set of \alert{freshness assumptions}.}

  \onslide<3->{
  \begin{center}
  \smath{\{a\fresh X,b\fresh X\} \vdash \text{fn\ } a. X \approx \text{fn\ } b. X}
  \end{center}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Rules for Equivalence}

  \begin{center}
  \begin{tabular}{c}
  Excerpt\\
  (i.e.~only the interesting rules)
  \end{tabular}
  \end{center}  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Rules for Equivalence}

  \begin{center}
  \begin{tabular}{c}
  \colorbox{cream}{\smath{\infer{\nabla \vdash a \approx a}{}}}\\[8mm]

  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash \abst{a}{t} \approx \abst{a}{t'}}
               {\nabla \vdash t \approx t'}}}\\[8mm]
 
  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash \abst{a}{t} \approx \abst{b}{t'}}
  {a\not=b\;\; & \nabla \vdash t \approx \swap{a}{b}\act t'\;\;& \nabla \vdash a\fresh t'}}}
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>[c]
  \frametitle{Rules for Equivalence}

  \begin{center}
  \colorbox{cream}{%
  \smath{%
  \infer{\nabla \vdash \pi\act X \approx \pi'\act X}
  {\begin{array}{c}
  (a\fresh X)\in\nabla\\
  \text{for all}\; a \;\text{with}\;\pi\act a \not= \pi'\act a 
  \end{array}
  }}}
  \end{center}

  \onslide<2->{
  for example\\[4mm]
  
  \alt<2>{%
  \begin{center}
  \smath{\{a\fresh\!X, b\fresh\!X\} \vdash X \approx \swap{a}{b}\act X}
  \end{center}}
  {%
  \begin{center}
  \smath{\{a\fresh\!X, c\fresh\!X\} \vdash \swap{a}{c}\swap{a}{b}\act X \approx \swap{b}{c}\act X}
  \end{center}}

  \onslide<3->{
  \begin{tabular}{@ {}lllll@ {}}
  because & 
  \smath{\swap{a}{c}\swap{a}{b}}: & 
  \smath{a\mapsto b} &
  \smath{\swap{b}{c}}: &
  \smath{a\mapsto a}\\
  & & \smath{b\mapsto c} & & \smath{b\mapsto c}\\
  & & \smath{c\mapsto a} & & \smath{c\mapsto b}\\
  \end{tabular}
  disagree at \smath{a} and \smath{c}.}
  }

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Rules for Freshness}

  \begin{center}
  \begin{tabular}{c}
  Excerpt\\
  (i.e.~only the interesting rules)
  \end{tabular}
  \end{center}  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Rules for Freshness}

  \begin{center}
  \begin{tabular}{c}
  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash a\fresh b}{a\not= b}}}\\[5mm]
  
  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash a\fresh\abst{a}{t}}{}}}\hspace{7mm}
  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash a\fresh\abst{b}{t}}
  {a\not= b\;\; & \nabla \vdash a\fresh t}}}\\[5mm]

  \colorbox{cream}{%
  \smath{\infer{\nabla \vdash a\fresh \pi\act X}
  {(\pi^{-1}\act a\fresh X)\in\nabla}}}
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>[t]
  \frametitle{$\approx$ is an Equivalence}
  \mbox{}\\[5mm]

  \begin{center}
  \colorbox{cream}{\alert{Theorem:}
  $\approx$ is an equivalence relation.}
  \end{center}\bigskip

  \only<1>{%
  \begin{tabular}{ll}
  (Reflexivity)  & $\smath{\nabla\vdash t\approx t}$\\[2mm]
  (Symmetry)     & if $\smath{\nabla\vdash t_1\approx t_2}\;$ 
                   then $\;\smath{\nabla\vdash t_2\approx t_1}$\\[2mm]
  (Transitivity) & if $\smath{\nabla\vdash t_1\approx t_2}\;$ and 
                   $\;\smath{\nabla\vdash t_2\approx t_3}$\\
                 & then $\smath{\nabla\vdash t_1\approx t_3}$\\
  \end{tabular}}

  \only<2->{%
  \begin{itemize}
  \item<2-> \smath{\nabla \vdash t\approx t'} then \smath{\nabla \vdash \pi\act t\approx \pi\act t'}

  \item<2-> \smath{\nabla \vdash a\fresh t} then 
  \smath{\nabla \vdash \pi\act a\fresh \pi\act t}

  \item<3-> \smath{\nabla \vdash t\approx \pi\act t'} then 
  \smath{\nabla \vdash (\pi^{-1})\act t\approx t'}

  \item<3-> \smath{\nabla \vdash a\fresh \pi\act t} then 
  \smath{\nabla \vdash (\pi^{-1})\act a\fresh t}

  \item<4-> \smath{\nabla \vdash a\fresh t} and \smath{\nabla \vdash t\approx t'} then
      \smath{\nabla \vdash a\fresh t'}
  \end{itemize}
  }

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>
  \frametitle{Comparison $=_\alpha$}

  Traditionally \smath{=_\alpha} is defined as

  \begin{center}
  \colorbox{cream}{%
  \begin{minipage}{9cm}
  \raggedright least congruence which identifies \smath{\abst{a}{t}} 
  with \smath{\abst{b}{[a:=b]t}} provided \smath{b} is not free  
  in \smath{t}
  \end{minipage}}
  \end{center}

  where \smath{[a:=b]t} replaces all free occurrences of\\
  \smath{a} by \smath{b} in \smath{t}.
  \bigskip 

  \only<2>{%
  \begin{textblock}{13}(1.2,10)
  For \alert{ground} terms:
  
  \begin{center}
  \colorbox{cream}{%
  \begin{minipage}{9.0cm}
  \begin{tabular}{@ {}rl}
  \underline{Theorem:}
  & \smath{t=_\alpha t'\;\;}  if\hspace{-0.5mm}f~\smath{\;\;\emptyset \vdash t\approx t'}\\[2mm]
  & \smath{a\not\in F\hspace{-0.9mm}A(t)\;\;} if\hspace{-0.5mm}f~\smath{\;\;\emptyset\vdash a\fresh t} 
  \end{tabular}
  \end{minipage}}
  \end{center}
  \end{textblock}}

  \only<3>{%
  \begin{textblock}{13}(1.2,10)
  In general \smath{=_\alpha} and \smath{\approx} are distinct!
  \begin{center}
  \colorbox{cream}{%
  \begin{minipage}{6.0cm}
  \smath{\abst{a}{X}=_\alpha \abst{b}{X}\;} but not\\[2mm]
  \smath{\emptyset \vdash \abst{a}{X} \approx \abst{b}{X}\;} (\smath{a\not=b})
  \end{minipage}}
  \end{center}
  \end{textblock}}

  \only<4>{
  \begin{textblock}{6}(1,2)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{10cm}\raggedright
  That is a crucial point: if we had\\[-2mm]
  \[\smath{\emptyset \vdash \abst{a}{X}\approx \abst{b}{X}}\mbox{,}\] 
  then applying $\smath{[X:=a]}$, $\smath{[X:=b]}$, $\ldots$\\
  give two terms that are {\bf not} $\alpha$-equivalent.\\[3mm] 
  The freshness constraints $\smath{a\fresh X}$ and $\smath{b\fresh X}$
  rule out the problematic substitutions. Therefore

  \[\smath{\{a\fresh X,b\fresh X\} \vdash \abst{a}{X}\approx \abst{b}{X}}\] 
  
  does hold.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-9>
  \frametitle{Substitution}

  \begin{tabular}{l@ {\hspace{8mm}}r@ {\hspace{1.5mm}}c@ {\hspace{1.5mm}}l@ {}}
  \pgfuseshading{smallbluesphere} & 
  \smath{\sigma(\abst{a}{t})} & \smath{\dn} & \smath{\abst{a}{\sigma(t)}}\\[2mm]

  \pgfuseshading{smallbluesphere} & 
  \smath{\sigma(\pi\act X)} & \smath{\dn} & 
  \smath{\begin{cases}% 
  \pi\;\act\;\sigma(X) & \!\!\text{if\ } \sigma(X)\not=X\\
  \pi\act X & \!\!\text{otherwise}% 
  \end{cases}}\\[6mm]
  \end{tabular}\bigskip\bigskip

  \pause
  \only<2-5>{
  \only<2->{for example}
  \def\arraystretch{1.3}
  \begin{tabular}{@ {\hspace{14mm}}l@ {\hspace{3mm}}l}
  \onslide<2->{\textcolor{white}{$\Rightarrow$}} &
  \onslide<2->{\alt<3>{\smath{\underline{\abst{a}{\swap{a}{b}\act X}\;\,[X:=\pair{b}{Y}]}}}
                      {\smath{\abst{a}{\swap{a}{b}\act X}\;\,[X:=\pair{b}{Y}]}}}\\
  \onslide<3->{\smath{\Rightarrow}} &
  \onslide<3->{\alt<3,4>{\smath{\abst{a}{\underline{\swap{a}{b}\act X[X:=\pair{b}{Y}]}}}}
                        {\smath{\abst{a}{\swap{a}{b}\act X}[X:=\pair{b}{Y}]}}}\\
  \onslide<4->{\smath{\Rightarrow}} &
  \onslide<4->{\alt<4>{\smath{\abst{a}{\swap{a}{b}\act \underline{\pair{b}{Y}}}}}
                      {\smath{\abst{a}{\underline{\swap{a}{b}}\act \pair{b}{Y}}}}}\\
  \onslide<5->{\smath{\Rightarrow}} &
  \onslide<5->{\smath{\abst{a}{\pair{a}{\swap{a}{b}\act Y}}}}
  \end{tabular}}

  \only<6->
  {\begin{tabular}{l@ {\hspace{8mm}}l@ {}}
  \pgfuseshading{smallbluesphere} &
  if \smath{\nabla\vdash t\approx t'} and\hspace{-2mm}\mbox{}
  \raisebox{-2.7mm}{
  \alt<7>{\begin{tikzpicture}
          \draw (0,0) node[inner sep=1mm,fill=cream, very thick, draw=red, rounded corners=3mm] 
          {\smath{\;\nabla'\vdash\sigma(\nabla)\;}};
          \end{tikzpicture}}
         {\begin{tikzpicture}
          \draw (0,0) node[inner sep=1mm,fill=white, very thick, draw=white, rounded corners=3mm] 
          {\smath{\;\nabla'\vdash\sigma(\nabla)\;}};
          \end{tikzpicture}}}\\
  & then \smath{\nabla'\vdash\sigma(t)\approx\sigma(t')}
  \end{tabular}}

  \only<9>
  {\begin{tabular}{l@ {\hspace{8mm}}l@ {}}
  \\[-4mm]
  \pgfuseshading{smallbluesphere} &
  \smath{\sigma(\pi\act t)=\pi\act\sigma(t)}
  \end{tabular}}


  \only<7>{
  \begin{textblock}{6}(10,10.5)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, very thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
   \begin{minipage}{3.8cm}\raggedright
   this means\\[1mm]
   \smath{\nabla'\vdash a\fresh\sigma(X)}\\[1mm]
   holds for all\\[1mm]
   \smath{(a\fresh X)\in\nabla}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Equational Problems}

  An equational problem 
  \[
    \colorbox{cream}{\smath{t \eqprob t'}}
  \]
  is \alert{solved} by

  \begin{center}
  \begin{tabular}{ll}
  \pgfuseshading{smallbluesphere} & a substitution \smath{\sigma} (terms for variables)\\[3mm]
  \pgfuseshading{smallbluesphere} & {\bf and} a set of freshness assumptions \smath{\nabla}
  \end{tabular}
  \end{center}

  so that \smath{\nabla\vdash \sigma(t)\approx \sigma(t')}.


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->

  Unifying equations may entail solving
  \alert{freshness problems}.

  \bigskip
  
  E.g.~assuming that \smath{a\not=a'}, then
  \[
  \smath{\abst{a}{t}\eqprob \abst{a'}{t'}} 
  \]
  can only be solved if 
  \[
  \smath{t\eqprob \swap{a}{a'}\act t'} \quad\text{\emph{and}}\quad
  \smath{a\freshprob t'}
  \]
  can be solved.

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Freshness Problems}

  A freshness problem
  \[
  \colorbox{cream}{\smath{a \freshprob t}}
  \]
  is \alert{solved} by

  \begin{center}
  \begin{tabular}{ll}
  \pgfuseshading{smallbluesphere} & a substitution \smath{\sigma}\\[3mm]
  \pgfuseshading{smallbluesphere} & and a set of freshness assumptions \smath{\nabla}
  \end{tabular}
  \end{center}

  so that \smath{\nabla\vdash a \fresh \sigma(t)}.

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{Existence of MGUs}

  \underline{Theorem}: There is an algorithm which, given a nominal
  unification problem \smath{P}, decides whether\\ 
  or not it has a solution \smath{(\sigma,\nabla)}, and returns a \\
  \alert{most general} one if it does.\bigskip\bigskip

  \only<3>{
  Proof: one can reduce all the equations to `solved form'
  first (creating a substitution), and then solve the freshness
  problems (easy).}

  \only<2>{
  \begin{textblock}{6}(2.5,9.5)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{8cm}\raggedright
  \alert{most general:}\\
  straightforward definition\\
  ``if\hspace{-0.5mm}f there exists a \smath{\tau} such that \ldots''
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{Remember the Quiz?}

  \textcolor{gray}{Assuming that $a$ and $b$ are distinct variables,\\
  is it possible to find $\lambda$-terms $M_1$ to $M_7$ 
  that make the following pairs $\alpha$-equivalent?}

  \begin{tabular}{@ {\hspace{14mm}}p{12cm}}
  \begin{itemize}
  \item \smath{\lambda a.\lambda b. (M_1\,b)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_1)\;}

  \item \textcolor{gray}{$\lambda a.\lambda b. (M_2\,b)\;$ and 
        $\lambda b.\lambda a. (a\,M_3)\;$}

  \item \textcolor{gray}{$\lambda a.\lambda b. (b\,M_4)\;$ and 
        $\lambda b.\lambda a. (a\,M_5)\;$}

  \item \smath{\lambda a.\lambda b. (b\,M_6)\;} and 
        \smath{\lambda a.\lambda a. (a\,M_7)\;}
  \end{itemize}
  \end{tabular}

  \textcolor{gray}{If there is one solution for a pair, can you 
  describe all its solutions?}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Answers to the Quiz}
  \small
  \def\arraystretch{1.6}
  \begin{tabular}{c@ {\hspace{2mm}}l}
  & \only<1>{\smath{\lambda a.\lambda b. (M_1\,b)\;} and \smath{\;\lambda b.\lambda a. (a\,M_1)}}%
    \only<2->{\smath{\abst{a}{\abst{b}{\pair{M_1}{b}}} \;\eqprob\; \abst{b}{\abst{a}{\pair{a}{M_1}}}}}\\

  \onslide<3->{\smath{\redu{\id}}} &
  \only<3>{\smath{\abst{b}{\pair{M_1}{b}} \eqprob
       \alert{\swap{a}{b}} \act \abst{a}{\pair{a}{M_1}}\;,\;a\freshprob \abst{a}{\pair{a}{M_1}}}}%
  \only<4->{\smath{\abst{b}{\pair{M_1}{b}} \eqprob \abst{b}{\pair{b}{\swap{a}{b}\act M_1}}\;,\
       a\freshprob \abst{a}{\pair{a}{M_1}}}}\\

  \onslide<5->{\smath{\redu{\id}}} &
  \only<5->{\smath{\pair{M_1}{b} \eqprob \pair{b}{\swap{a}{b}\act M_1}\;,\;%
       a\freshprob \abst{a}{\pair{a}{M_1}}}}\\

  \onslide<6->{\smath{\redu{\id}}} &
  \only<6->{\smath{M_1 \eqprob b \;,\; b \eqprob \swap{a}{b}\act M_1\;,\;%
       a\freshprob \abst{a}{\pair{a}{M_1}}}}\\

  \onslide<7->{\smath{\redu{[M_1:=b]}}} &
  \only<7>{\smath{b \eqprob \swap{a}{b}\act \alert{b}\;,\;%
       a\freshprob \abst{a}{\pair{a}{\alert{b}}}}}%
  \only<8->{\smath{b \eqprob a\;,\; a\freshprob \abst{a}{\pair{a}{b}}}}\\

  \onslide<9->{\smath{\redu{}}} &
  \only<9->{\smath{F\hspace{-0.5mm}AIL}}
  \end{tabular}

  \only<10>{
  \begin{textblock}{6}(2,11)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{9cm}\raggedright
  \smath{\lambda a.\lambda b. (M_1\,b)} \smath{=_\alpha} 
  \smath{\lambda b.\lambda a. (a\,M_1)} has no solution
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Answers to the Quiz}
  \small
  \def\arraystretch{1.6}
  \begin{tabular}{c@ {\hspace{2mm}}l}
  & \only<1>{\smath{\lambda a.\lambda b. (b\,M_6)\;} and \smath{\;\lambda a.\lambda a. (a\,M_7)}}%
    \only<2->{\smath{\abst{a}{\abst{b}{\pair{b}{M_6}}} \;\eqprob\; \abst{a}{\abst{a}{\pair{a}{M_7}}}}}\\

  \onslide<3->{\smath{\redu{\id}}} &
  \only<3->{\smath{\abst{b}{\pair{b}{M_6}} \eqprob \abst{a}{\pair{a}{M_7}}}}\\

  \onslide<4->{\smath{\redu{\id}}} &
  \only<4->{\smath{\pair{b}{M_6} \eqprob \pair{b}{\swap{b}{a}\act M_7}\;,\;b\freshprob\pair{a}{M_7}}}\\

  \onslide<5->{\smath{\redu{\id}}} &
  \only<5->{\smath{b\eqprob b\;,\; M_6 \eqprob \swap{b}{a}\act M_7\;,\;%
       b\freshprob \pair{a}{M_7}}}\\

  \onslide<6->{\smath{\redu{\id}}} &
  \only<6->{\smath{M_6 \eqprob \swap{b}{a}\act M_7\;,\;%
       b\freshprob \pair{a}{M_7}}}\\

  \onslide<7->{\makebox[0mm]{\smath{\redu{[M_6:=\swap{b}{a}\act M_7]}}}} &
  \only<7->{\smath{\qquad b\freshprob \pair{a}{M_7}}}\\

  \onslide<8->{\smath{\redu{\varnothing}}} &
  \only<8->{\smath{b\freshprob a\;,\;b\freshprob M_7}}\\
  
  \onslide<9->{\smath{\redu{\varnothing}}} &
  \only<9->{\smath{b\freshprob M_7}}\\
 
  \onslide<10->{\makebox[0mm]{\smath{\redu{\{b\fresh M_7\}}}}} &
  \only<10->{\smath{\;\;\varnothing}}\\

  \end{tabular}

  \only<10>{
  \begin{textblock}{6}(6,9)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{7cm}\raggedright
  \smath{\lambda a.\lambda b. (b\,M_6)\;} \smath{=_\alpha} 
  \smath{\;\lambda a.\lambda a. (a\,M_7)}\\[2mm]
  we can take \smath{M_7} to be any $\lambda$-term that does not
  contain free occurrences of \smath{b}, so long as we take \smath{M_6} to
  be the result of swapping all occurrences of \smath{b} and \smath{a}
  throughout \smath{M_7}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Properties}

  \begin{itemize}
  \item An interesting feature of nominal unification is that it
  does not need to create new atoms.\bigskip

  \begin{center}\small
  \colorbox{cream}{
  \smath{\{a.t \eqprob b.t'\}\cup P \redu{\id} \{t \eqprob \swap{a}{b}\act t', a \freshprob t'\} \cup P}}
  \end{center}\bigskip\bigskip
  \pause

  \item The alternative rule

  \begin{center}\small
  \colorbox{cream}{
  \begin{tabular}{@ {}l@ {}}
  \smath{\{a.t \eqprob b.t'\}\cup P \redu{\id}}\\ 
  \mbox{}\hspace{2cm}\smath{\{\swap{a}{c}\act t \eqprob 
  \swap{b}{c}\act t', c \freshprob t, c \freshprob t'\} \cup P}
  \end{tabular}}
  \end{center}
 
  leads to a more complicated notion of mgu.\medskip\pause
  
  \footnotesize
  \smath{\{a.X \eqprob b.Y\} \redu{} (\{a\fresh Y, c\fresh Y\}, [X:=\swap{a}{c}\swap{b}{c}\act Y])}
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{Is it Useful?}

  Yes. $\alpha$Prolog by James Cheney (main developer)\bigskip\bigskip

  \color{darkgray}
  \begin{tabular}{@ {}l}
  type (Gamma, var(X), T) :- member (X,T) Gamma.\smallskip\medskip\\
  
  type (Gamma, app(M, N), T') :-\\
  \hspace{3cm}type (Gamma, M, arrow(T, T')),\\ 
  \hspace{3cm}type (Gamma, N, T).\smallskip\medskip\\
  
  type (Gamma, lam(\alert{x.M}), arrow(T, T')) / \alert{x \# Gamma} :-\\
  \hspace{3cm}type ((x, T)::Gamma, M, T').\smallskip\medskip\\
  
  member X X::Tail.\\
  member X Y::Tail :- member X Tail.\\
  \end{tabular}

  \only<2->{
  \begin{textblock}{6}(1.5,0.5)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{9cm}\raggedright
  {\bf One problem:} If we ask whether
  
  \begin{center}
  ?- type ([(x, T')], lam(x.Var(x)), T) 
  \end{center}

  is typable, we expect an answer for T.\bigskip

  \onslide<3>{Solution: Before back-chaining freshen all variables and atoms
  in a program (clause).}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Equivariant Unification}

  James Cheney proposed

  \begin{center}
  \colorbox{cream}{
  \smath{t \eqprob t'  \redu{\nabla, \sigma, \pi}   
    \nabla \vdash \sigma(t) \approx \pi \act \sigma(t')}}
  \end{center}\bigskip\bigskip
  \pause

  But he also showed this problem is undecidable\\ in general. :(

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{Taking Atoms as Variables}

  Instead of \smath{a.X}, have \smath{A.X}.\bigskip
  \pause

  Unfortunately this breaks the mgu-property:

  \begin{center}
  \smath{a.Z \eqprob X.Y.v(a)}
  \end{center}

  can be solved by

  \begin{center}
  \smath{[X:=a, Z:=Y.v(a)]} and
  \smath{[Y:=a, Z:=Y.v(Y)]}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{HOPU vs. NOMU}

  \begin{itemize}
  \item James Cheney showed\bigskip
  \begin{center}
  \colorbox{cream}{\smath{HOPU \Rightarrow NOMU}} 
  \end{center}\bigskip

  \item Jordi Levy and Mateu Villaret established\bigskip
  \begin{center}
  \colorbox{cream}{\smath{HOPU \Leftarrow NOMU}} 
  \end{center}\bigskip
  \end{itemize}

  The translations `explode' the problems quadratically.

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \small\tt
  
  \begin{minipage}{13cm}
  \begin{tabular}{@ {\hspace{-2mm}}p{11.5cm}}
  \\
  From: Zhenyu Qian <zhqian@microsoft.com>\\
  To: Christian Urban <urbanc@in.tum.de>\\
  Subject: RE: Linear Higher-Order Pattern Unification\\
  Date: Mon, 14 Apr 2008 09:56:47 +0800\\
  \\
  Hi Christian,\\
  \\
  Thanks for your interests and asking. I know that that paper is complex. As
  I told Tobias when we met last time, I have raised the question to myself 
  many times whether the proof could have some flaws, and so making it through 
  a theorem prover would definitely bring piece to my mind (no matter what 
  the result would be). The only problem for me is the time.\\
  \ldots\\

  Thanks/Zhenyu
  \end{tabular}
  \end{minipage}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{Complexity}

  \begin{itemize}
  \item Christiopher Calves and Maribel Fernandez showed first that
  it is polynomial and then also quadratic

  \item Jordi Levy and Mateu Villaret showed that it is quadratic
  by a translation into a subset of NOMU and using ideas from
  Martelli/Montenari.
  
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Conclusion}

  \begin{itemize}
  \item Nominal Unification is a completely first-order 
  language, but implements unification modulo $\alpha$.
  \textcolor{gray}{(verification\ldots Ramana Kumar and Michael Norrish)}
  \medskip\pause

  \item NOMU has been applied in term-rewriting and
  logic programming. \textcolor{gray}{(Maribel Fernandez et 
  al has a KB-completion procedure.)} 
  I hope it will also be used in typing
  systems.\medskip\pause

  \item NOMU and HOPU are `equivalent' (it took a long time
  and considerable research to find this out).\medskip\pause
  
  \item The question about complexity is still an ongoing 
  story.\medskip 
  \end{itemize}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{
  \begin{tabular}{c}
  \mbox{}\\[23mm]
  \alert{\LARGE Thank you very much!}\\
  \alert{\Large Questions?}
  \end{tabular}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{Most General Unifiers}

  \underline{Definition}: For a unification problem
  \smath{P}, a solution \smath{(\sigma_1,\nabla_1)} is
  \alert{more general} than another solution
  \smath{(\sigma_2,\nabla_2)}, iff~there exists a substitution
  \smath{\tau} with

  \begin{center}
  \begin{tabular}{ll}
  \pgfuseshading{smallbluesphere} & 
     \alt<2>{\smath{\alert{\nabla_2\vdash\tau(\nabla_1)}}}
            {\smath{\nabla_2\vdash\tau(\nabla_1)}}\\
  \pgfuseshading{smallbluesphere} & 
     \alt<3>{\smath{\alert{\nabla_2\vdash\sigma_2\approx \tau\circ\sigma_1}}}
            {\smath{\nabla_2\vdash\sigma_2\approx \tau\circ\sigma_1}}
  \end{tabular}
  \end{center}

  \only<2>{
  \begin{textblock}{13}(1.5,10.5)
  \smath{\nabla_2\vdash a\fresh \sigma(X)} holds for all
  \smath{(a\fresh X)\in\nabla_1}
  \end{textblock}}
  
  \only<3>{
  \begin{textblock}{11}(1.5,10.5)
  \smath{\nabla_2\vdash \sigma_2(X)\approx
  \sigma(\sigma_1(X))}
  holds for all
  \smath{X\in\text{dom}(\sigma_2)\cup\text{dom}(\sigma\circ\sigma_1)}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

(*<*)
end
(*>*)