theory Term8
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "Abs" "Perm" "Fv" "Rsp" "../Attic/Prove"
begin

atom_decl name

datatype rfoo8 =
  Foo0 "name"
| Foo1 "rbar8" "rfoo8" --"bind bv(bar) in foo"
and rbar8 =
  Bar0 "name"
| Bar1 "name" "name" "rbar8" --"bind second name in b"

primrec
  rbv8
where
  "rbv8 (Bar0 x) = {}"
| "rbv8 (Bar1 v x b) = {atom v}"

setup {* snd o define_raw_perms (Datatype.the_info @{theory} "Term8.rfoo8") 2 *}
print_theorems

local_setup {* snd o define_fv_alpha (Datatype.the_info @{theory} "Term8.rfoo8") [
  [[[]], [[], [(SOME @{term rbv8}, 0)]]], [[[]], [[], [(NONE, 1)], [(NONE, 1)]]]] *}
notation
  alpha_rfoo8 ("_ \<approx>f' _" [100, 100] 100) and
  alpha_rbar8 ("_ \<approx>b' _" [100, 100] 100)
thm alpha_rfoo8_alpha_rbar8.intros


inductive
  alpha8f :: "rfoo8 \<Rightarrow> rfoo8 \<Rightarrow> bool" ("_ \<approx>f _" [100, 100] 100)
and
  alpha8b :: "rbar8 \<Rightarrow> rbar8 \<Rightarrow> bool" ("_ \<approx>b _" [100, 100] 100)
where
  a1: "a = b \<Longrightarrow> (Foo0 a) \<approx>f (Foo0 b)"
| a2: "a = b \<Longrightarrow> (Bar0 a) \<approx>b (Bar0 b)"
| a3: "b1 \<approx>b b2 \<Longrightarrow> (\<exists>pi. (((rbv8 b1), t1) \<approx>gen alpha8f fv_rfoo8 pi ((rbv8 b2), t2))) \<Longrightarrow> Foo1 b1 t1 \<approx>f Foo1 b2 t2"
| a4: "v1 = v2 \<Longrightarrow> (\<exists>pi. (({atom x1}, t1) \<approx>gen alpha8b fv_rbar8 pi ({atom x2}, t2))) \<Longrightarrow> Bar1 v1 x1 t1 \<approx>b Bar1 v2 x2 t2"

lemma "(alpha8b ===> op =) rbv8 rbv8"
  apply simp apply clarify
  apply (erule alpha8f_alpha8b.inducts(2))
  apply (simp_all)
done

lemma fv_rbar8_rsp_hlp: "x \<approx>b y \<Longrightarrow> fv_rbar8 x = fv_rbar8 y"
  apply (erule alpha8f_alpha8b.inducts(2))
  apply (simp_all add: alpha_gen)
done
lemma "(alpha8b ===> op =) fv_rbar8 fv_rbar8"
  apply simp apply clarify apply (simp add: fv_rbar8_rsp_hlp)
done

lemma "(alpha8f ===> op =) fv_rfoo8 fv_rfoo8"
  apply simp apply clarify
  apply (erule alpha8f_alpha8b.inducts(1))
  apply (simp_all add: alpha_gen fv_rbar8_rsp_hlp)
done

end
