theory ExPS3
imports "../NewParser"
begin

(* example 3 from Peter Sewell's bestiary *)

atom_decl name

ML {* val _ = cheat_alpha_eqvt := true *}
ML {* val _ = cheat_equivp := true *}
ML {* val _ = cheat_alpha_bn_rsp := true *}

nominal_datatype exp =
  Var "name"
| App "exp" "exp"
| Lam x::"name" e::"exp" bind_set x in e
| Let x::"name" p::"pat" e1::"exp" e2::"exp" bind_set x in e2, bind_set "bp p" in e1
and pat =
  PVar "name"
| PUnit
| PPair "pat" "pat"
binder
  bp :: "pat \<Rightarrow> atom set"
where
  "bp (PVar x) = {atom x}"
| "bp (PUnit) = {}"
| "bp (PPair p1 p2) = bp p1 \<union> bp p2"

thm exp_pat.fv
thm exp_pat.eq_iff
thm exp_pat.bn
thm exp_pat.perm
thm exp_pat.induct
thm exp_pat.distinct
thm exp_pat.fv
thm exp_pat.supp(1-2)

declare permute_exp_raw_permute_pat_raw.simps[eqvt]

equivariance alpha_exp_raw


end



