theory LFex
imports "Parser"
begin

atom_decl name
atom_decl ident

ML {* val _ = cheat_fv_rsp := false *}
ML {* val _ = cheat_const_rsp := false *}
ML {* val _ = cheat_equivp := false *}
ML {* val _ = cheat_fv_eqvt := false *}
ML {* val _ = cheat_alpha_eqvt := false *}

nominal_datatype kind =
    Type
  | KPi "ty" n::"name" k::"kind" bind n in k
and ty =
    TConst "ident"
  | TApp "ty" "trm"
  | TPi "ty" n::"name" t::"ty" bind n in t
and trm =
    Const "ident"
  | Var "name"
  | App "trm" "trm"
  | Lam "ty" n::"name" t::"trm" bind n in t

lemma ex_out: 
  "(\<exists>x. Z x \<and> Q) = (Q \<and> (\<exists>x. Z x))"
  "(\<exists>x. Q \<and> Z x) = (Q \<and> (\<exists>x. Z x))"
  "(\<exists>x. P x \<and> Q \<and> Z x) = (Q \<and> (\<exists>x. P x \<and> Z x))"
  "(\<exists>x. Q \<and> P x \<and> Z x) = (Q \<and> (\<exists>x. P x \<and> Z x))"
apply (blast)+
done

lemma Collect_neg_conj: "{x. \<not>(P x \<and> Q x)} = {x. \<not>(P x)} \<union> {x. \<not>(Q x)}"
by (simp add: Collect_imp_eq Collect_neg_eq[symmetric])

lemma supp_eqs:
  "supp Type = {}"
  "supp rkind = fv_kind rkind \<Longrightarrow> supp (KPi rty name rkind) = supp rty \<union> supp (Abs {atom name} rkind)"
  "supp (TConst i) = {atom i}"
  "supp (TApp A M) = supp A \<union> supp M"
  "supp rty2 = fv_ty rty2 \<Longrightarrow> supp (TPi rty1 name rty2) = supp rty1 \<union> supp (Abs {atom name} rty2)"
  "supp (Const i) = {atom i}"
  "supp (Var x) = {atom x}"
  "supp (App M N) = supp M \<union> supp N"
  "supp rtrm = fv_trm rtrm \<Longrightarrow> supp (Lam rty name rtrm) = supp rty \<union> supp (Abs {atom name} rtrm)"
  apply(simp_all (no_asm) add: supp_def permute_set_eq atom_eqvt kind_ty_trm_perm)
  apply(simp_all only: kind_ty_trm_eq_iff Abs_eq_iff alpha_gen)
  apply(simp_all only: ex_out)
  apply(simp_all only: eqvts[symmetric])
  apply(simp_all only: Collect_neg_conj)
  apply(simp_all only: supp_at_base[simplified supp_def] Un_commute Un_assoc)
  apply(simp_all add: Collect_imp_eq Collect_neg_eq[symmetric] Un_commute Un_assoc)
  apply(simp_all add: Un_left_commute)
  done

lemma supp_fv:
  "supp t1 = fv_kind t1 \<and> supp t2 = fv_ty t2 \<and> supp t3 = fv_trm t3"
  apply(induct rule: kind_ty_trm_induct)
  apply(simp_all (no_asm) only: supp_eqs kind_ty_trm_fv)
  apply(simp_all)
  apply(simp_all add: supp_eqs)
  apply(simp_all add: supp_Abs)
  done

lemma supp_rkind_rty_rtrm:
  "supp Type = {}"
  "supp (KPi A x K) = supp A \<union> (supp K - {atom x})"
  "supp (TConst i) = {atom i}"
  "supp (TApp A M) = supp A \<union> supp M"
  "supp (TPi A x B) = supp A \<union> (supp B - {atom x})"
  "supp (Const i) = {atom i}"
  "supp (Var x) = {atom x}"
  "supp (App M N) = supp M \<union> supp N"
  "supp (Lam A x M) = supp A \<union> (supp M - {atom x})"
apply (simp_all add: supp_fv kind_ty_trm_fv)

end




