theory Let
imports "../Nominal2" 
begin


atom_decl name

nominal_datatype trm =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind  x in t
| Let as::"assn" t::"trm"   bind "bn as" in t
and assn =
  ANil
| ACons "name" "trm" "assn"
binder
  bn
where
  "bn ANil = []"
| "bn (ACons x t as) = (atom x) # (bn as)"

print_theorems

thm alpha_trm_raw_alpha_assn_raw_alpha_bn_raw.intros
thm bn_raw.simps
thm permute_bn_raw.simps
thm trm_assn.perm_bn_alpha
thm trm_assn.permute_bn

thm trm_assn.fv_defs
thm trm_assn.eq_iff 
thm trm_assn.bn_defs
thm trm_assn.bn_inducts
thm trm_assn.perm_simps
thm trm_assn.induct
thm trm_assn.inducts
thm trm_assn.distinct
thm trm_assn.supp
thm trm_assn.fresh
thm trm_assn.exhaust
thm trm_assn.strong_exhaust

lemma alpha_bn_inducts_raw:
  "\<lbrakk>alpha_bn_raw a b; P3 ANil_raw ANil_raw;
 \<And>trm_raw trm_rawa assn_raw assn_rawa name namea.
    \<lbrakk>alpha_trm_raw trm_raw trm_rawa; alpha_bn_raw assn_raw assn_rawa;
     P3 assn_raw assn_rawa\<rbrakk>
    \<Longrightarrow> P3 (ACons_raw name trm_raw assn_raw)
        (ACons_raw namea trm_rawa assn_rawa)\<rbrakk> \<Longrightarrow> P3 a b"
  by (erule alpha_trm_raw_alpha_assn_raw_alpha_bn_raw.inducts(3)[of _ _ "\<lambda>x y. True" _ "\<lambda>x y. True", simplified]) auto

lemmas alpha_bn_inducts = alpha_bn_inducts_raw[quot_lifted]



lemma alpha_bn_refl: "alpha_bn x x"
  by (induct x rule: trm_assn.inducts(2))
     (rule TrueI, auto simp add: trm_assn.eq_iff)
lemma alpha_bn_sym: "alpha_bn x y \<Longrightarrow> alpha_bn y x"
  sorry
lemma alpha_bn_trans: "alpha_bn x y \<Longrightarrow> alpha_bn y z \<Longrightarrow> alpha_bn x z"
  sorry

lemma bn_inj[rule_format]:
  assumes a: "alpha_bn x y"
  shows "bn x = bn y \<longrightarrow> x = y"
  by (rule alpha_bn_inducts[OF a]) (simp_all add: trm_assn.bn_defs)

(*lemma alpha_bn_permute:
  assumes a: "alpha_bn x y"
      and b: "q \<bullet> bn x = r \<bullet> bn y"
    shows "alpha_bn (q \<bullet> x) (r \<bullet> y)"
proof -
  have "alpha_bn x (permute_bn r y)"
    by (rule alpha_bn_trans[OF a]) (rule trm_assn.perm_bn_alpha)
  then have "alpha_bn (permute_bn r y) x"
    by (rule alpha_bn_sym)
  then have "alpha_bn (permute_bn r y) (permute_bn q x)"
    by (rule alpha_bn_trans) (rule trm_assn.perm_bn_alpha)
  then have "alpha_bn (permute_bn q x) (permute_bn r y)"
    by (rule alpha_bn_sym)
  moreover have "bn (permute_bn q x) = bn (permute_bn r y)"
    using b trm_assn.permute_bn by simp
  ultimately have "permute_bn q x = permute_bn r y"
    using bn_inj by simp
*)

lemma lets_bla:
  "x \<noteq> z \<Longrightarrow> y \<noteq> z \<Longrightarrow> x \<noteq> y \<Longrightarrow>(Let (ACons x (Var y) ANil) (Var x)) \<noteq> (Let (ACons x (Var z) ANil) (Var x))"
  by (simp add: trm_assn.eq_iff)


lemma lets_ok:
  "(Let (ACons x (Var y) ANil) (Var x)) = (Let (ACons y (Var y) ANil) (Var y))"
  apply (simp add: trm_assn.eq_iff Abs_eq_iff )
  apply (rule_tac x="(x \<leftrightarrow> y)" in exI)
  apply (simp_all add: alphas atom_eqvt supp_at_base fresh_star_def trm_assn.bn_defs trm_assn.supp)
  done

lemma lets_ok3:
  "x \<noteq> y \<Longrightarrow>
   (Let (ACons x (App (Var y) (Var x)) (ACons y (Var y) ANil)) (App (Var x) (Var y))) \<noteq>
   (Let (ACons y (App (Var x) (Var y)) (ACons x (Var x) ANil)) (App (Var x) (Var y)))"
  apply (simp add: trm_assn.eq_iff)
  done

lemma lets_not_ok1:
  "x \<noteq> y \<Longrightarrow>
   (Let (ACons x (Var x) (ACons y (Var y) ANil)) (App (Var x) (Var y))) \<noteq>
   (Let (ACons y (Var x) (ACons x (Var y) ANil)) (App (Var x) (Var y)))"
  apply (simp add: alphas trm_assn.eq_iff trm_assn.supp fresh_star_def atom_eqvt Abs_eq_iff trm_assn.bn_defs)
  done

lemma lets_nok:
  "x \<noteq> y \<Longrightarrow> x \<noteq> z \<Longrightarrow> z \<noteq> y \<Longrightarrow>
   (Let (ACons x (App (Var z) (Var z)) (ACons y (Var z) ANil)) (App (Var x) (Var y))) \<noteq>
   (Let (ACons y (Var z) (ACons x (App (Var z) (Var z)) ANil)) (App (Var x) (Var y)))"
  apply (simp add: alphas trm_assn.eq_iff fresh_star_def trm_assn.bn_defs Abs_eq_iff trm_assn.supp trm_assn.distinct)
  done

lemma
  fixes a b c :: name
  assumes x: "a \<noteq> c" and y: "b \<noteq> c"
  shows "\<exists>p.([atom a], Var c) \<approx>lst (op =) supp p ([atom b], Var c)"
  apply (rule_tac x="(a \<leftrightarrow> b)" in exI)
  apply (simp add: alphas trm_assn.supp supp_at_base x y fresh_star_def atom_eqvt)
  by (metis Rep_name_inverse atom_name_def flip_fresh_fresh fresh_atom fresh_perm x y)


lemma max_eqvt[eqvt]: "p \<bullet> (max (a :: _ :: pure) b) = max (p \<bullet> a) (p \<bullet> b)"
  by (simp add: permute_pure)


lemma Abs_lst_fcb2:
  fixes as bs :: "'a :: fs"
    and x y :: "'b :: fs"
    and c::"'c::fs"
  assumes eq: "[ba as]lst. x = [ba bs]lst. y"
  and fcb1: "set (ba as) \<sharp>* f as x c"
  and fresh1: "set (ba as) \<sharp>* c"
  and fresh2: "set (ba bs) \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f as x c) = f (p \<bullet> as) (p \<bullet> x) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f bs y c) = f (p \<bullet> bs) (p \<bullet> y) c"
(* What we would like in this proof, and lets this proof finish *)
  and ba_inj: "\<And>q r. q \<bullet> ba as = r \<bullet> ba bs \<Longrightarrow> q \<bullet> as = r \<bullet> bs"
(* What the user can supply with the help of alpha_bn *)
(*  and bainj: "ba as = ba bs \<Longrightarrow> as = bs"*)
  shows "f as x c = f bs y c"
proof -
  have "supp (as, x, c) supports (f as x c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm1 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin1: "finite (supp (f as x c))"
    by (auto intro: supports_finite simp add: finite_supp)
  have "supp (bs, y, c) supports (f bs y c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm2 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin2: "finite (supp (f bs y c))"
    by (auto intro: supports_finite simp add: finite_supp)
  obtain q::"perm" where 
    fr1: "(q \<bullet> (set (ba as))) \<sharp>* (x, c, f as x c, f bs y c)" and 
    fr2: "supp q \<sharp>* ([ba as]lst. x)" and 
    inc: "supp q \<subseteq> (set (ba as)) \<union> q \<bullet> (set (ba as))"
    using at_set_avoiding3[where xs="set (ba as)" and c="(x, c, f as x c, f bs y c)" 
      and x="[ba as]lst. x"]  fin1 fin2
    by (auto simp add: supp_Pair finite_supp Abs_fresh_star dest: fresh_star_supp_conv)
  have "[q \<bullet> (ba as)]lst. (q \<bullet> x) = q \<bullet> ([ba as]lst. x)" by simp
  also have "\<dots> = [ba as]lst. x"
    by (simp only: fr2 perm_supp_eq)
  finally have "[q \<bullet> (ba as)]lst. (q \<bullet> x) = [ba bs]lst. y" using eq by simp
  then obtain r::perm where 
    qq1: "q \<bullet> x = r \<bullet> y" and 
    qq2: "q \<bullet> (ba as) = r \<bullet> (ba bs)" and 
    qq3: "supp r \<subseteq> (q \<bullet> (set (ba as))) \<union> set (ba bs)"
    apply(drule_tac sym)
    apply(simp only: Abs_eq_iff2 alphas)
    apply(erule exE)
    apply(erule conjE)+
    apply(drule_tac x="p" in meta_spec)
    apply(simp add: set_eqvt)
    apply(blast)
    done
  have "(set (ba as)) \<sharp>* f as x c" by (rule fcb1)
  then have "q \<bullet> ((set (ba as)) \<sharp>* f as x c)"
    by (simp add: permute_bool_def)
  then have "set (q \<bullet> (ba as)) \<sharp>* f (q \<bullet> as) (q \<bullet> x) c"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm1)
    using inc fresh1 fr1
    apply(auto simp add: fresh_star_def fresh_Pair)
    done
  then have "set (r \<bullet> (ba bs)) \<sharp>* f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq2 ba_inj 
    by simp
  then have "r \<bullet> ((set (ba bs)) \<sharp>* f bs y c)"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm2[symmetric])
    using qq3 fresh2 fr1
    apply(auto simp add: set_eqvt fresh_star_def fresh_Pair)
    done
  then have fcb2: "(set (ba bs)) \<sharp>* f bs y c" by (simp add: permute_bool_def)
  have "f as x c = q \<bullet> (f as x c)"
    apply(rule perm_supp_eq[symmetric])
    using inc fcb1 fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (q \<bullet> as) (q \<bullet> x) c"
    apply(rule perm1)
    using inc fresh1 fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq2 ba_inj by simp
  also have "\<dots> = r \<bullet> (f bs y c)"
    apply(rule perm2[symmetric])
    using qq3 fresh2 fr1 by (auto simp add: fresh_star_def)
  also have "... = f bs y c"
    apply(rule perm_supp_eq)
    using qq3 fr1 fcb2 by (auto simp add: fresh_star_def)
  finally show ?thesis by simp
qed

nominal_primrec
    height_trm :: "trm \<Rightarrow> nat"
and height_assn :: "assn \<Rightarrow> nat"
where
  "height_trm (Var x) = 1"
| "height_trm (App l r) = max (height_trm l) (height_trm r)"
| "height_trm (Lam v b) = 1 + (height_trm b)"
| "height_trm (Let as b) = max (height_assn as) (height_trm b)"
| "height_assn ANil = 0"
| "height_assn (ACons v t as) = max (height_trm t) (height_assn as)"
  apply (simp only: eqvt_def height_trm_height_assn_graph_def)
  apply (rule, perm_simp, rule, rule TrueI)
  apply (case_tac x)
  apply (case_tac a rule: trm_assn.exhaust(1))
  apply (auto)[4]
  apply (drule_tac x="assn" in meta_spec)
  apply (drule_tac x="trm" in meta_spec)
  apply (simp add: alpha_bn_refl)
  apply (case_tac b rule: trm_assn.exhaust(2))
  apply (auto)[2]
  apply(simp_all)
  apply (erule_tac c="()" in Abs_lst_fcb2)
  apply (simp_all add: pure_fresh fresh_star_def)[3]
  apply (simp add: eqvt_at_def)
  apply (simp add: eqvt_at_def)
  apply assumption
  apply(erule conjE)
  apply (simp add: meta_eq_to_obj_eq[OF height_trm_def, symmetric, unfolded fun_eq_iff])
  apply (simp add: meta_eq_to_obj_eq[OF height_assn_def, symmetric, unfolded fun_eq_iff])
  apply (subgoal_tac "eqvt_at height_assn as")
  apply (subgoal_tac "eqvt_at height_assn asa")
  apply (subgoal_tac "eqvt_at height_trm b")
  apply (subgoal_tac "eqvt_at height_trm ba")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inr as)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inr asa)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inl b)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inl ba)")
  defer
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_assn_def)
  apply (simp add: eqvt_at_def height_assn_def)
  apply (subgoal_tac "height_assn as = height_assn asa")
  apply (subgoal_tac "height_trm b = height_trm ba")
  apply simp
  apply (erule_tac c="()" in Abs_lst_fcb2)
  apply (simp_all add: pure_fresh fresh_star_def)[3]
  apply (simp_all add: eqvt_at_def)[2]
  apply assumption
  apply (erule_tac c="()" and ba="bn" in Abs_lst_fcb2)
  apply (simp_all add: pure_fresh fresh_star_def)[3]
  apply (simp_all add: eqvt_at_def)[2]
  apply (rule bn_inj)
  prefer 2
  apply (simp add: eqvts)
  oops

nominal_primrec
    subst  :: "name \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> trm"
and substa :: "name \<Rightarrow> trm \<Rightarrow> assn \<Rightarrow> assn"
where
  "subst s t (Var x) = (if (s = x) then t else (Var x))"
| "subst s t (App l r) = App (subst s t l) (subst s t r)"
| "atom v \<sharp> (s, t) \<Longrightarrow> subst s t (Lam v b) = Lam v (subst s t b)"
| "set (bn as) \<sharp>* (s, t) \<Longrightarrow> subst s t (Let as b) = Let (substa s t as) (subst s t b)"
| "substa s t ANil = ANil"
| "substa s t (ACons v t' as) = ACons v (subst v t t') as"
(*unfolding eqvt_def subst_substa_graph_def
  apply (rule, perm_simp)*)
  defer
  apply (rule TrueI)
  apply (case_tac x)
  apply (case_tac a)
  apply (rule_tac y="c" and c="(aa,b)" in trm_assn.strong_exhaust(1))
  apply (auto simp add: fresh_star_def)[3]
  apply (drule_tac x="assn" in meta_spec)
  apply (simp add: Abs1_eq_iff alpha_bn_refl)
  apply (case_tac b)
  apply (case_tac c rule: trm_assn.exhaust(2))
  apply (auto)[2]
  apply blast
  apply blast
  apply auto
  apply (simp_all add: meta_eq_to_obj_eq[OF subst_def, symmetric, unfolded fun_eq_iff])
  apply (simp_all add: meta_eq_to_obj_eq[OF substa_def, symmetric, unfolded fun_eq_iff])
  prefer 2
  apply (erule_tac c="(sa, ta)" in Abs_lst_fcb2)
  apply (simp_all add: fresh_star_Pair)
  prefer 6
  apply (erule alpha_bn_inducts)
 oops


end



