(*<*)
theory Slides5
imports "~~/src/HOL/Library/LaTeXsugar" "Nominal"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)


text_raw {*
  %% shallow, deep, and recursive binders
  %%
  %%\renewcommand{\slidecaption}{Cambridge, 8.~June 2010}
  %%\renewcommand{\slidecaption}{Uppsala, 3.~March 2011}
  \renewcommand{\slidecaption}{Saarbrcken, 31.~March 2011}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{%
  \begin{tabular}{@ {\hspace{-3mm}}c@ {}}
  \\
  \LARGE General Bindings and\\ 
  \LARGE Alpha-Equivalence\\ 
  \LARGE in Nominal Isabelle\\[3mm] 
  \Large Or, Nominal Isabelle 2\\[-5mm]
  \end{tabular}}
  \begin{center}
  Christian Urban
  \end{center}
  \begin{center}
  joint work with {\bf Cezary Kaliszyk}\\[0mm] 
  \end{center}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Binding in Old Nominal\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item the old Nominal Isabelle provided a reasoning infrastructure for single binders\medskip
  
  \begin{center}
  Lam [a].(Var a)
  \end{center}\bigskip

  \item<2-> but representing 

  \begin{center}
  $\forall\{a_1,\ldots,a_n\}.\; T$ 
  \end{center}\medskip

  with single binders and reasoning about it is a \alert{\bf major} pain; 
  take my word for it!
  \end{itemize}

  \only<1>{
  \begin{textblock}{6}(1.5,11)
  \small
  for example\\
  \begin{tabular}{l@ {\hspace{2mm}}l}
   & a $\fresh$ Lam [a]. t\\
   & Lam [a]. (Var a) \alert{$=$} Lam [b]. (Var b)\\
   & Barendregt-style reasoning about bound variables\\
  \end{tabular}
  \end{textblock}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-6>
  \frametitle{New Types in HOL}

   \begin{center}
  \begin{tikzpicture}[scale=1.5]
  %%%\draw[step=2mm] (-4,-1) grid (4,1);
  
  \onslide<2-4,6>{\draw[very thick] (0.7,0.4) circle (4.25mm);}
  \onslide<1-4,6>{\draw[rounded corners=1mm, very thick] ( 0.0,-0.8) rectangle ( 1.8, 0.9);}
  \onslide<3-5,6>{\draw[rounded corners=1mm, very thick] (-1.95,0.85) rectangle (-2.85,-0.05);}
  
  \onslide<3-4,6>{\draw (-2.0, 0.845) --  (0.7,0.845);}
  \onslide<3-4,6>{\draw (-2.0,-0.045)  -- (0.7,-0.045);}

  \onslide<4-4,6>{\alert{\draw ( 0.7, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-\\[-1mm]classes\end{tabular}};}}
  \onslide<4-5,6>{\alert{\draw (-2.4, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-eq.\\[-1mm]terms\end{tabular}};}}
  \onslide<1-4,6>{\draw (1.8, 0.48) node[right=-0.1mm]
    {\footnotesize\begin{tabular}{@ {}l@ {}}existing\\[-1mm] type\\ \onslide<4-4,6>{\alert{(sets of raw terms)}}\end{tabular}};}
  \onslide<2-4,6>{\draw (0.9, -0.35) node {\footnotesize\begin{tabular}{@ {}l@ {}}non-empty\\[-1mm]subset\end{tabular}};}
  \onslide<3-5,6>{\draw (-3.25, 0.55) node {\footnotesize\begin{tabular}{@ {}l@ {}}new\\[-1mm]type\end{tabular}};}
  
  \onslide<3-4,6>{\draw[<->, very thick] (-1.8, 0.3) -- (-0.1,0.3);}
  \onslide<3-4,6>{\draw (-0.95, 0.3) node[above=0mm] {\footnotesize{}isomorphism};}

  \onslide<6>{\draw[->, line width=2mm, red] (-1.0,-0.4) -- (0.35,0.16);}
  \end{tikzpicture}
  \end{center}
  
  \begin{center}
  \textcolor{red}{\large\bf\onslide<6>{define $\alpha$-equivalence}}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>
  \frametitle{\begin{tabular}{c}Binding Sets of Names\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item binding sets of names has some interesting properties:\medskip
  
  \begin{center}
  \begin{tabular}{l}
  \textcolor{blue}{$\forall\{x, y\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{y, x\}.\, y \rightarrow x$}
  \bigskip\smallskip\\

  \onslide<2->{%
  \textcolor{blue}{$\forall\{x, y\}.\, x \rightarrow y \;\;\not\approx_\alpha\;\; \forall\{z\}.\, z \rightarrow z$}
  }\bigskip\smallskip\\

  \onslide<3->{%
  \textcolor{blue}{$\forall\{x\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{x, \alert{z}\}.\, x \rightarrow y$}
  }\medskip\\
  \onslide<3->{\hspace{4cm}\small provided $z$ is fresh for the type}
  \end{tabular}
  \end{center}
  \end{itemize}
  
  \begin{textblock}{8}(2,14.5)
  \footnotesize $^*$ $x$, $y$, $z$ are assumed to be distinct
  \end{textblock}

  \only<4>{
  \begin{textblock}{6}(2.5,4)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize\color{darkgray}
  \begin{minipage}{8cm}\raggedright
  For type-schemes the order of bound names does not matter, and
  $\alpha$-equivalence is preserved under \alert{vacuous} binders.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Other Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item alpha-equivalence being preserved under vacuous binders is \underline{not} always
  wanted:\bigskip\bigskip\normalsize
  
  \textcolor{blue}{\begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;x = 3\;\text{and}\;y = 2\;\text{in}\;x - y\;\text{end}$\medskip\\
  \onslide<2->{$\;\;\;\only<2>{\approx_\alpha}\only<3>{\alert{\not\approx_\alpha}}
   \text{let}\;y = 2\;\text{and}\;x = 3\only<3->{\alert{\;\text{and}
    \;z = \text{loop}}}\;\text{in}\;x - y\;\text{end}$}
  \end{tabular}}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}\LARGE{}Even Another Binding Mode\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item sometimes one wants to abstract more than one name, but the order \underline{does} matter\bigskip
  
  \begin{center}
  \textcolor{blue}{\begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;(x, y) = (3, 2)\;\text{in}\;x - y\;\text{end}$\medskip\\
  $\;\;\;\not\approx_\alpha
   \text{let}\;(y, x) = (3, 2)\;\text{in}\;x - y\;\text{end}$
  \end{tabular}}
  \end{center}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}\LARGE{}Three Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item the order does not matter and alpha-equivelence is preserved under
  vacuous binders \textcolor{gray}{(restriction)}\medskip
  
  \item the order does not matter, but the cardinality of the binders 
  must be the same \textcolor{gray}{(abstraction)}\medskip

  \item the order does matter \textcolor{gray}{(iterated single binders)}
  \end{itemize}

  \onslide<2->{
  \begin{center}
  \isacommand{bind (set+)}\hspace{6mm}
  \isacommand{bind (set)}\hspace{6mm}
  \isacommand{bind}
  \end{center}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Specification of Binding\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam \only<2->{x::}name \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} x \isacommand{in} t}\\
  \hspace{5mm}$|$ Let \only<2->{as::}assns \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} bn(as) \isacommand{in} t}\\
  \multicolumn{2}{l}{\isacommand{and} assns $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assns}\\
  \multicolumn{2}{l}{\onslide<3->{\isacommand{binder} bn \isacommand{where}}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ []}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}$|$ bn(ACons a t as) $=$ [a] @ bn(as)}}\\
  \end{tabular}



  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-8>
  \frametitle{\begin{tabular}{c}Alpha-Equivalence\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets first look at pairs\bigskip\medskip

  \textcolor{blue}{\begin{tabular}{@ {\hspace{1cm}}l}
  $(as, x) \onslide<2->{\approx\!}\makebox[5mm][l]{\only<2-6>{${}_{\text{set}}$}%
           \only<7>{${}_{\text{\alert{list}}}$}%
           \only<8>{${}_{\text{\alert{set+}}}$}}%
           \,\onslide<2->{(bs,y)}$
  \end{tabular}}\bigskip
  \end{itemize}

  \only<1>{
  \begin{textblock}{8}(3,8.5)
  \begin{tabular}{l@ {\hspace{2mm}}p{8cm}}
   & \textcolor{blue}{$as$} is a set of names\ldots the binders\\
   & \textcolor{blue}{$x$} is the body (might be a tuple)\\
   & \textcolor{blue}{$\approx_{\text{set}}$} is where the cardinality 
  of the binders has to be the same\\
  \end{tabular}
  \end{textblock}}

  \only<4->{
  \begin{textblock}{12}(5,8)
  \textcolor{blue}{
  \begin{tabular}{ll@ {\hspace{1mm}}l}
  $\dn$ & \onslide<5->{$\exists \pi.\,$} & $\text{fv}(x) - as = \text{fv}(y) - bs$\\[1mm]
        & \onslide<5->{$\;\;\;\wedge$} & \onslide<5->{$\text{fv}(x) - as \fresh^* \pi$}\\[1mm]
        & \onslide<5->{$\;\;\;\wedge$} & \onslide<5->{$(\pi \act x) = y$}\\[1mm]
        & \only<6-7>{$\;\;\;\wedge$}\only<8>{\textcolor{gray}{\xout{$\;\;\;\wedge$}}} & 
          \only<6-7>{$\pi \act as = bs$}\only<8>{\textcolor{gray}{\xout{$\pi \act as = bs$}}}\\
  \end{tabular}}
  \end{textblock}}
  
  \only<7>{
  \begin{textblock}{7}(3,13.8)
  \footnotesize $^*$ $as$ and $bs$ are \alert{lists} of names 
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets look at type-schemes:\medskip\medskip

  \begin{center}
  \textcolor{blue}{$(as, x) \approx\!\makebox[5mm][l]{${}_{\text{set}}$} (bs, y)$}
  \end{center}\medskip

  \onslide<2->{
  \begin{center}
  \textcolor{blue}{
  \begin{tabular}{l}
  $\text{fv}(x) = \{x\}$\\[1mm]
  $\text{fv}(T_1 \rightarrow T_2) = \text{fv}(T_1) \cup \text{fv}(T_2)$\\
  \end{tabular}}
  \end{center}}
  \end{itemize}

  
  \only<3->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<3->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<3->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \textcolor{blue}{
  \only<1>{$(\{x, y\}, x \rightarrow y) \approx_? (\{x, y\}, y \rightarrow x)$}
  \only<2>{$([x, y], x \rightarrow y) \approx_? ([x, y], y \rightarrow x)$}}
  \end{center}

  \begin{itemize}
  \item \textcolor{blue}{$\approx_{\text{set+}}$, $\approx_{\text{set}}$% 
  \only<2>{, \alert{$\not\approx_{\text{list}}$}}}
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \textcolor{blue}{\only<1>{$(\{x\}, x) \approx_? (\{x, y\}, x)$}}
  \end{center}

  \begin{itemize}
  \item \textcolor{blue}{$\approx_{\text{set+}}$, $\not\approx_{\text{set}}$,
        $\not\approx_{\text{list}}$}
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set+:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \only<2>{
  \begin{textblock}{6}(2.5,4)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=5mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize
  \begin{minipage}{8cm}\raggedright
  \begin{itemize}
  \item \color{darkgray}$\alpha$-equivalences coincide when a single name is
  abstracted
  \item \color{darkgray}in that case they are equivalent to ``old-fashioned'' definitions of $\alpha$ 
  \end{itemize}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Our Specifications\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam x::name t::trm
  & \isacommand{bind} x \isacommand{in} t\\
  \hspace{5mm}$|$ Let as::assns t::trm
  & \isacommand{bind} bn(as) \isacommand{in} t\\
  \multicolumn{2}{l}{\isacommand{and} assns $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assns}\\
  \multicolumn{2}{l}{\isacommand{binder} bn \isacommand{where}}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ $[]$}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)}\\
  \end{tabular}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{\begin{tabular}{c}Binding Functions\end{tabular}}

  \begin{center}
  \begin{tikzpicture}
  \node (A) at (-0.5,1) {Foo $(\lambda y. \lambda x. t)$};
  \node (B) at ( 1.5,1) {$s$};
  \onslide<1>{\node (C) at (0.5,-0.5) {$\{y, x\}$};}
  \onslide<1>{\draw[->,red,line width=1mm] (A) -- (C);}
  \onslide<1>{\draw[->,red,line width=1mm] (C) -- (B);}
  \end{tikzpicture}
  \end{center}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{\begin{tabular}{c}Binder Clauses\end{tabular}}

  \begin{itemize}
  \item We need for a bound variable to have a `clear scope', and bound
  variables should not be free and bound at the same time.\bigskip
  \end{itemize}

  \begin{center}
  \only<1>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  \alert{\bf shallow binders}\\ 
  \hspace{4mm}Lam x::name t::trm\hspace{4mm} \isacommand{bind} x \isacommand{in} t\\
  \hspace{4mm}All xs::name set T::ty\hspace{4mm} \isacommand{bind} xs \isacommand{in} T\\
  \hspace{4mm}Foo x::name t$_1$::trm t$_2$::trm\hspace{4mm} 
     \isacommand{bind} x \isacommand{in} t$_1$, \isacommand{bind} x \isacommand{in} t$_2$\\
  \hspace{4mm}Bar x::name t$_1$::trm t$_2$::trm\hspace{4mm} 
     \isacommand{bind} x \isacommand{in} t$_1$ t$_2$\\
  \end{tabular}}
  \only<2>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  \alert{\bf deep binders} \\
  \hspace{4mm}Let as::assns t::trm\hspace{4mm} \isacommand{bind} bn(as) \isacommand{in} t\\
  \hspace{4mm}Foo as::assns t$_1$::trm t$_2$::trm\\
  \hspace{20mm}\isacommand{bind} bn(as) \isacommand{in} t$_1$, \isacommand{bind} bn(as) \isacommand{in} t$_2$\\[4mm]
  \makebox[0mm][l]{\alert{$\times$}}\hspace{4mm}Bar as::assns t$_1$::trm t$_2$::trm\\
  \hspace{20mm}\isacommand{bind} bn$_1$(as) \isacommand{in} t$_1$, \isacommand{bind} bn$_2$(as) \isacommand{in} t$_2$\\
  \end{tabular}}
  \only<3>{
  \begin{tabular}{@ {\hspace{-5mm}}l}
  {\bf deep \alert{recursive} binders} \\
  \hspace{4mm}Let\_rec as::assns t::trm\hspace{4mm} \isacommand{bind} bn(as) \isacommand{in} t as\\[4mm]

  \makebox[0mm][l]{\alert{$\times$}}\hspace{4mm}Foo\_rec as::assns t$_1$::trm t$_2$::trm\hspace{4mm}\\ 
  \hspace{20mm}\isacommand{bind} bn(as) \isacommand{in} t$_1$ as, \isacommand{bind} bn(as) \isacommand{in} t$_2$\\

  \end{tabular}}
  \end{center}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<2-5>
  \frametitle{\begin{tabular}{c}Our Work\end{tabular}}
  \mbox{}\\[-6mm]

    \begin{center}
  \begin{tikzpicture}[scale=1.5]
  %%%\draw[step=2mm] (-4,-1) grid (4,1);
  
  \onslide<1>{\draw[very thick] (0.7,0.4) circle (4.25mm);}
  \onslide<1>{\draw[rounded corners=1mm, very thick] ( 0.0,-0.8) rectangle ( 1.8, 0.9);}
  \onslide<1->{\draw[rounded corners=1mm, very thick] (-1.95,0.85) rectangle (-2.85,-0.05);}
  
  \onslide<1>{\draw (-2.0, 0.845) --  (0.7,0.845);}
  \onslide<1>{\draw (-2.0,-0.045)  -- (0.7,-0.045);}

  \onslide<1>{\alert{\draw ( 0.7, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-\\[-1mm]classes\end{tabular}};}}
  \onslide<1->{\alert{\draw (-2.4, 0.4) node {\footnotesize\begin{tabular}{@ {}c@ {}}$\alpha$-eq.\\[-1mm]terms\end{tabular}};}}
  \onslide<1>{\draw (1.8, 0.48) node[right=-0.1mm]
    {\footnotesize\begin{tabular}{@ {}l@ {}}existing\\[-1mm] type\\ \onslide<1>{\alert{(sets of raw terms)}}\end{tabular}};}
  \onslide<1>{\draw (0.9, -0.35) node {\footnotesize\begin{tabular}{@ {}l@ {}}non-empty\\[-1mm]subset\end{tabular}};}
  \onslide<1->{\draw (-3.25, 0.55) node {\footnotesize\begin{tabular}{@ {}l@ {}}new\\[-1mm]type\end{tabular}};}
  
  \onslide<1>{\draw[<->, very thick] (-1.8, 0.3) -- (-0.1,0.3);}
  \onslide<1>{\draw (-0.95, 0.3) node[above=0mm] {\footnotesize{}isomorphism};}

  \onslide<1>{\draw[->, line width=2mm, red] (-1.0,-0.4) -- (0.35,0.16);}
  \end{tikzpicture}
  \end{center}
  
  \begin{textblock}{9.5}(6,3.5)
  \begin{itemize}
  \item<1-> defined fv and $\alpha$
  \item<3-> derived a reasoning infrastructure ($\fresh$, distinctness, injectivity, cases,\ldots) 
  \item<4-> a (weak) induction principle
  \item<5-> derive a {\bf stronger} induction principle (Barendregt variable convention built in)\\
  \begin{center}
  \textcolor{blue}{Foo ($\lambda x. \lambda y. t$) ($\lambda u. \lambda v. s$)} 
  \end{center}
  \end{itemize}
  \end{textblock}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Conclusion\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item the user does not see anything of the raw level\medskip
  \only<1>{\begin{center}
  Lam a (Var a) \alert{$=$} Lam b (Var b)
  \end{center}\bigskip}

  \item<2-> it took quite some time to get here, but it seems worthwhile 
  (Barendregt's variable convention is unsound in general, 
  found bugs in two paper proofs)\bigskip\medskip
  
  \item<3-> \textcolor{blue}{http://isabelle.in.tum.de/nominal/}
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{\begin{tabular}{c}Questions?\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{center}
  \alert{\huge{Thanks!}}
  \end{center}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>[c]
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-6mm]

  \textcolor{blue}{
  \begin{center}
  $(\{a,b\}, a \rightarrow b) \approx_\alpha (\{a, b\}, a \rightarrow b)$
  $(\{a,b\}, a \rightarrow b) \approx_\alpha (\{a, b\}, b \rightarrow a)$
  \end{center}}

  \textcolor{blue}{
  \begin{center}
  $(\{a,b\}, (a \rightarrow b, a \rightarrow b))$\\ 
  \hspace{17mm}$\not\approx_\alpha (\{a, b\}, (a \rightarrow b, b \rightarrow a))$
  \end{center}}
  
  \onslide<2->
  {1.) \hspace{3mm}\isacommand{bind (set)} as \isacommand{in} $\tau_1$, 
   \isacommand{bind (set)} as \isacommand{in} $\tau_2$\medskip

   2.) \hspace{3mm}\isacommand{bind (set)} as \isacommand{in} $\tau_1$ $\tau_2$ 
  }

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



(*<*)
end
(*>*)