theory Lambda
imports "../Nominal2" 
begin


atom_decl name

nominal_datatype lam =
  Var "name"
| App "lam" "lam"
| Lam x::"name" l::"lam"  bind x in l ("Lam [_]. _" [100, 100] 100)


inductive 
  triv :: "lam \<Rightarrow> nat \<Rightarrow> bool"
where
  Var: "triv (Var x) n"
| App: "\<lbrakk>triv t1 n; triv t2 n\<rbrakk> \<Longrightarrow> triv (App t1 t2) n"

lemma 
  "p \<bullet> (triv t x) = triv (p \<bullet> t) (p \<bullet> x)"
unfolding triv_def
apply(perm_simp)
apply(rule refl)
oops
(*apply(perm_simp)*)

ML {*
  Inductive.the_inductive @{context} "Lambda.triv"
*}

thm triv_def

equivariance triv
nominal_inductive triv avoids Var: "{}::name set"
apply(auto simp add: fresh_star_def) 
done

inductive 
  triv2 :: "lam \<Rightarrow> nat \<Rightarrow> bool" 
where
  Var1: "triv2 (Var x) 0"
| Var2: "triv2 (Var x) (n + n)"
| Var3: "triv2 (Var x) n"

equivariance triv2
nominal_inductive triv2 .

lemma Abs1_eq_fdest:
  fixes x y :: "'a :: at_base"
    and S T :: "'b :: fs"
  assumes "(Abs_lst [atom x] T) = (Abs_lst [atom y] S)"
  and "x \<noteq> y \<Longrightarrow> atom y \<sharp> T \<Longrightarrow> atom x \<sharp> f x T"
  and "x \<noteq> y \<Longrightarrow> atom y \<sharp> T \<Longrightarrow> atom y \<sharp> f x T"
  and "x \<noteq> y \<Longrightarrow> atom y \<sharp> T \<Longrightarrow> (atom x \<rightleftharpoons> atom y) \<bullet> T = S \<Longrightarrow> (atom x \<rightleftharpoons> atom y) \<bullet> (f x T) = f y S"
  and "sort_of (atom x) = sort_of (atom y)"
  shows "f x T = f y S"
using assms apply -
apply (subst (asm) Abs1_eq_iff')
apply simp_all
apply (elim conjE disjE)
apply simp
apply(rule trans)
apply (rule_tac p="(atom x \<rightleftharpoons> atom y)" in supp_perm_eq[symmetric])
apply(rule fresh_star_supp_conv)
apply(simp add: supp_swap fresh_star_def)
apply(simp add: swap_commute)
done

text {* height function *}

nominal_primrec
  height :: "lam \<Rightarrow> int"
where
  "height (Var x) = 1"
| "height (App t1 t2) = max (height t1) (height t2) + 1"
| "height (Lam [x].t) = height t + 1"
  unfolding eqvt_def height_graph_def
  apply (rule, perm_simp, rule)
apply(rule_tac y="x" in lam.exhaust)
apply(auto simp add: lam.distinct lam.eq_iff)
apply (erule Abs1_eq_fdest)
apply(simp_all add: fresh_def pure_supp eqvt_at_def)
done

termination
  by (relation "measure size") (simp_all add: lam.size)
  
thm height.simps

  
text {* free name function - returns atom lists *}

nominal_primrec 
  frees_lst :: "lam \<Rightarrow> atom list"
where
  "frees_lst (Var x) = [atom x]"
| "frees_lst (App t1 t2) = frees_lst t1 @ frees_lst t2"
| "frees_lst (Lam [x]. t) = removeAll (atom x) (frees_lst t)"
  unfolding eqvt_def frees_lst_graph_def
  apply (rule, perm_simp, rule)
apply(rule_tac y="x" in lam.exhaust)
apply(auto)
apply (erule Abs1_eq_fdest)
apply(simp add: supp_removeAll fresh_def)
apply(drule supp_eqvt_at)
apply(simp add: finite_supp)
apply(auto simp add: fresh_def supp_removeAll eqvts eqvt_at_def)
done

termination
  by (relation "measure size") (simp_all add: lam.size)

text {* a small test lemma *}
lemma
  shows "supp t = set (frees_lst t)"
apply(induct t rule: frees_lst.induct)
apply(simp_all add: lam.supp supp_at_base)
done

text {* capture - avoiding substitution *}

nominal_primrec
  subst :: "lam \<Rightarrow> name \<Rightarrow> lam \<Rightarrow> lam"  ("_ [_ ::= _]" [90, 90, 90] 90)
where
  "(Var x)[y ::= s] = (if x = y then s else (Var x))"
| "(App t1 t2)[y ::= s] = App (t1[y ::= s]) (t2[y ::= s])"
| "atom x \<sharp> (y, s) \<Longrightarrow> (Lam [x]. t)[y ::= s] = Lam [x].(t[y ::= s])"
  unfolding eqvt_def subst_graph_def
  apply (rule, perm_simp, rule)
apply(auto simp add: lam.distinct lam.eq_iff)
apply(rule_tac y="a" and c="(aa, b)" in lam.strong_exhaust)
apply(blast)+
apply(simp_all add: fresh_star_def fresh_Pair_elim)
apply (erule Abs1_eq_fdest)
apply(simp_all add: Abs_fresh_iff)
apply(drule_tac a="atom (xa)" in fresh_eqvt_at)
apply(simp_all add: finite_supp fresh_Pair)
apply(subgoal_tac "(atom x \<rightleftharpoons> atom xa) \<bullet> sa = sa")
apply(subgoal_tac "(atom x \<rightleftharpoons> atom xa) \<bullet> ya = ya")
apply(simp add: eqvt_at_def)
apply(rule perm_supp_eq,simp add: fresh_star_def fresh_Pair supp_swap)+
done

termination
  by (relation "measure (\<lambda>(t,_,_). size t)") (simp_all add: lam.size)

lemma subst_eqvt[eqvt]:
  shows "(p \<bullet> t[x ::= s]) = (p \<bullet> t)[(p \<bullet> x) ::= (p \<bullet> s)]"
by (induct t x s rule: subst.induct) (simp_all)

lemma forget:
  shows "atom x \<sharp> t \<Longrightarrow> t[x ::= s] = t"
apply(nominal_induct t avoiding: x s rule: lam.strong_induct)
apply(auto simp add: lam.fresh fresh_at_base)
done

text {* same lemma but with subst.induction *}
lemma forget2:
  shows "atom x \<sharp> t \<Longrightarrow> t[x ::= s] = t"
apply(induct t x s rule: subst.induct)
apply(auto simp add: lam.fresh fresh_at_base fresh_Pair)
done

lemma fresh_fact:
  fixes z::"name"
  assumes a: "atom z \<sharp> s"
  and b: "z = y \<or> atom z \<sharp> t"
  shows "atom z \<sharp> t[y ::= s]"
using a b
apply (nominal_induct t avoiding: z y s rule: lam.strong_induct)
apply (auto simp add: lam.fresh fresh_at_base)
done

lemma substitution_lemma:  
  assumes a: "x \<noteq> y" "atom x \<sharp> u"
  shows "t[x ::= s][y ::= u] = t[y ::= u][x ::= s[y ::= u]]"
using a 
by (nominal_induct t avoiding: x y s u rule: lam.strong_induct)
   (auto simp add: fresh_fact forget)

lemma subst_rename: 
  assumes a: "atom y \<sharp> t"
  shows "t[x ::= s] = ((y \<leftrightarrow> x) \<bullet>t)[y ::= s]"
using a 
apply (nominal_induct t avoiding: x y s rule: lam.strong_induct)
apply (auto simp add: lam.fresh fresh_at_base)
done

lemma height_ge_one:
  shows "1 \<le> (height e)"
by (induct e rule: lam.induct) (simp_all)

theorem height_subst:
  shows "height (e[x::=e']) \<le> ((height e) - 1) + (height e')"
proof (nominal_induct e avoiding: x e' rule: lam.strong_induct)
  case (Var y)
  have "1 \<le> height e'" by (rule height_ge_one)
  then show "height (Var y[x::=e']) \<le> height (Var y) - 1 + height e'" by simp
next
  case (Lam y e1)
  hence ih: "height (e1[x::=e']) \<le> ((height e1) - 1) + (height e')" by simp
  moreover
  have vc: "atom y\<sharp>x" "atom y\<sharp>e'" by fact+ (* usual variable convention *)
  ultimately show "height ((Lam [y]. e1)[x::=e']) \<le> height (Lam [y]. e1) - 1 + height e'" by simp
next
  case (App e1 e2)
  hence ih1: "height (e1[x::=e']) \<le> ((height e1) - 1) + (height e')"
    and ih2: "height (e2[x::=e']) \<le> ((height e2) - 1) + (height e')" by simp_all
  then show "height ((App e1 e2)[x::=e']) \<le> height (App e1 e2) - 1 + height e'"  by simp
qed

subsection {* single-step beta-reduction *}

inductive 
  beta :: "lam \<Rightarrow> lam \<Rightarrow> bool" (" _ \<longrightarrow>b _" [80,80] 80)
where
  b1[intro]: "t1 \<longrightarrow>b t2 \<Longrightarrow> App t1 s \<longrightarrow>b App t2 s"
| b2[intro]: "s1 \<longrightarrow>b s2 \<Longrightarrow> App t s1 \<longrightarrow>b App t s2"
| b3[intro]: "t1 \<longrightarrow>b t2 \<Longrightarrow> Lam [x]. t1 \<longrightarrow>b Lam [x]. t2"
| b4[intro]: "atom x \<sharp> s \<Longrightarrow> App (Lam [x]. t) s \<longrightarrow>b t[x ::= s]"

equivariance beta

nominal_inductive beta
  avoids b4: "x"
  by (simp_all add: fresh_star_def fresh_Pair lam.fresh fresh_fact)

text {* One-Reduction *}

inductive 
  One :: "lam \<Rightarrow> lam \<Rightarrow> bool" (" _ \<longrightarrow>1 _" [80,80] 80)
where
  o1[intro]: "Var x \<longrightarrow>1 Var x"
| o2[intro]: "\<lbrakk>t1 \<longrightarrow>1 t2; s1 \<longrightarrow>1 s2\<rbrakk> \<Longrightarrow> App t1 s1 \<longrightarrow>1 App t2 s2"
| o3[intro]: "t1 \<longrightarrow>1 t2 \<Longrightarrow> Lam [x].t1 \<longrightarrow>1 Lam [x].t2"
| o4[intro]: "\<lbrakk>atom x \<sharp> (s1, s2); t1 \<longrightarrow>1 t2; s1 \<longrightarrow>1 s2\<rbrakk> \<Longrightarrow> App (Lam [x].t1) s1 \<longrightarrow>1 t2[x ::= s2]"

equivariance One

nominal_inductive One 
  avoids o3: "x"
      |  o4: "x"
  by (simp_all add: fresh_star_def fresh_Pair lam.fresh fresh_fact)

lemma One_refl:
  shows "t \<longrightarrow>1 t"
by (nominal_induct t rule: lam.strong_induct) (auto)

lemma One_subst: 
  assumes a: "t1 \<longrightarrow>1 t2" "s1 \<longrightarrow>1 s2"
  shows "t1[x ::= s1] \<longrightarrow>1 t2[x ::= s2]" 
using a 
apply(nominal_induct t1 t2 avoiding: s1 s2 x rule: One.strong_induct)
apply(auto simp add: substitution_lemma fresh_at_base fresh_fact fresh_Pair)
done

lemma better_o4_intro:
  assumes a: "t1 \<longrightarrow>1 t2" "s1 \<longrightarrow>1 s2"
  shows "App (Lam [x]. t1) s1 \<longrightarrow>1 t2[ x ::= s2]"
proof -
  obtain y::"name" where fs: "atom y \<sharp> (x, t1, s1, t2, s2)" by (rule obtain_fresh)
  have "App (Lam [x]. t1) s1 = App (Lam [y]. ((y \<leftrightarrow> x) \<bullet> t1)) s1" using fs
    by (auto simp add: lam.eq_iff Abs1_eq_iff' flip_def fresh_Pair fresh_at_base)
  also have "\<dots> \<longrightarrow>1 ((y \<leftrightarrow> x) \<bullet> t2)[y ::= s2]" using fs a by (auto simp add: One.eqvt)
  also have "\<dots> = t2[x ::= s2]" using fs by (simp add: subst_rename[symmetric])
  finally show "App (Lam [x].t1) s1 \<longrightarrow>1 t2[x ::= s2]" by simp
qed



section {* Locally Nameless Terms *}

nominal_datatype ln = 
  LNBnd nat
| LNVar name
| LNApp ln ln
| LNLam ln

fun
  lookup :: "name list \<Rightarrow> nat \<Rightarrow> name \<Rightarrow> ln" 
where
  "lookup [] n x = LNVar x"
| "lookup (y # ys) n x = (if x = y then LNBnd n else (lookup ys (n + 1) x))"

lemma [eqvt]:
  shows "(p \<bullet> lookup xs n x) = lookup (p \<bullet> xs) (p \<bullet> n) (p \<bullet> x)"
  by (induct xs arbitrary: n) (simp_all add: permute_pure)

nominal_primrec
  trans :: "lam \<Rightarrow> name list \<Rightarrow> ln"
where
  "trans (Var x) xs = lookup xs 0 x"
| "trans (App t1 t2) xs = LNApp (trans t1 xs) (trans t2 xs)"
| "atom x \<sharp> xs \<Longrightarrow> trans (Lam [x]. t) xs = LNLam (trans t (x # xs))"
  unfolding eqvt_def trans_graph_def
  apply (rule, perm_simp, rule)
apply(case_tac x)
apply(simp)
apply(rule_tac y="a" and c="b" in lam.strong_exhaust)
apply(simp_all add: fresh_star_def)[3]
apply(blast)
apply(blast)
apply(simp_all add: lam.distinct lam.eq_iff)
apply(elim conjE)
apply clarify
apply (erule Abs1_eq_fdest)
apply (simp_all add: ln.fresh)
prefer 2
apply(drule supp_eqvt_at)
apply (auto simp add: finite_supp supp_Pair fresh_def supp_Cons supp_at_base)[2]
prefer 2
apply (subgoal_tac "(atom x \<rightleftharpoons> atom xa) \<bullet> xsa = xsa")
apply (simp add: eqvt_at_def)
apply (metis atom_name_def swap_fresh_fresh)
oops

(* lemma helpr: "atom x \<sharp> ta \<Longrightarrow> Lam [xa]. ta = Lam [x]. ((xa \<leftrightarrow> x) \<bullet> ta)"
  apply (case_tac "x = xa")
  apply simp
  apply (simp add: lam.eq_iff Abs1_eq_iff flip_def[symmetric])
  by (metis atom_eqvt flip_at_simps(2) fresh_permute_iff)

lemma supp_lookup: "supp (lookup l n name) = {atom name} - supp l"
  apply (induct l arbitrary: n)
  apply (simp_all add: ln.supp supp_at_base supp_Nil supp_Cons pure_supp)
  done

lemma trans_eqvt[eqvt]: "p \<bullet> (trans t l) = trans (p \<bullet> t) (p \<bullet> l)"
  apply (induct t l rule: trans.induct)
  apply simp_all
  apply (simp add: eqvts permute_pure)
  done

lemma diff_un: "a - (b \<union> c) = a - b - c"
  by blast

lemma supp_trans: "supp (trans t l) = supp t - supp l"
  apply (induct t arbitrary: l rule: lam.induct)
  apply (simp_all add: lam.supp supp_at_base supp_lookup ln.supp)
  apply blast
  apply (rule_tac x="(lam, l)" and ?'a="name" in obtain_fresh)
  apply (simp add: fresh_Pair)
  apply clarify
  apply (subgoal_tac "supp (Lambda.trans (Lam [a]. ((name \<leftrightarrow> a) \<bullet> lam)) l) =
    supp lam - {atom name} - supp l")
  using helpr
  apply simp
  apply (simp add: ln.supp)
  apply (subgoal_tac "supp ((name \<leftrightarrow> a) \<bullet> (Lambda.trans lam ((name \<leftrightarrow> a) \<bullet> (a # l)))) = supp lam - {atom name} - supp l")
  apply (simp add: trans_eqvt)
  apply (simp add: supp_eqvt[symmetric])
  apply (simp add: Diff_eqvt)
  apply (simp add: supp_eqvt supp_Cons  union_eqvt)
  apply (simp add: diff_un)
  apply (tactic {* Cong_Tac.cong_tac @{thm cong} 1*})
  apply (tactic {* Cong_Tac.cong_tac @{thm cong} 1*})
  apply rule
  prefer 2
  apply rule
  apply (simp add: supp_at_base)
  apply (subgoal_tac "(name \<leftrightarrow> a) \<bullet> (supp lam - {atom name}) = supp lam - {atom name}")
  apply (simp add: eqvts)
  unfolding flip_def
  apply (rule swap_fresh_fresh)
apply (metis fresh_at_base fresh_def fresh_minus_atom_set lam.fsupp supp_at_base)
by (metis fresh_def fresh_finite_atom_set fresh_minus_atom_set lam.fsupp)

lemma "atom x \<sharp> trans_sumC (t, x # xsa)"
  by (simp add: fresh_def meta_eq_to_obj_eq[OF trans_def, symmetric, unfolded fun_eq_iff] supp_trans supp_Cons supp_at_base)
*)

nominal_datatype db = 
  DBVar nat
| DBApp db db
| DBLam db

fun dbapp_in where
  "dbapp_in None _ = None"
| "dbapp_in (Some _ ) None = None"
| "dbapp_in (Some x) (Some y) = Some (DBApp x y)"

fun dblam_in where
  "dblam_in None = None"
| "dblam_in (Some x) = Some (DBLam x)"

lemma db_in_eqvt[eqvt]:
  "p \<bullet> (dbapp_in x y) = dbapp_in (p \<bullet> x) (p \<bullet> y)"
  "p \<bullet> (dblam_in x) = dblam_in (p \<bullet> x)"
  apply (case_tac [!] x)
  apply (simp_all add: eqvts)
  apply (case_tac y)
  apply (simp_all add: eqvts)
  done

instance db :: pure
  apply default
  apply (induct_tac x rule: db.induct)
  apply (simp_all add: permute_pure)
  done

lemma fresh_at_list: "atom x \<sharp> xs \<longleftrightarrow> x \<notin> set xs"
  unfolding fresh_def supp_set[symmetric]
  apply (induct xs)
  apply (simp add: supp_set_empty)
  apply simp
  apply auto
  apply (simp_all add: insert_absorb UnI2 finite_set supp_of_finite_insert supp_at_base)
  done

fun
  vindex :: "name list \<Rightarrow> name \<Rightarrow> nat \<Rightarrow> db option" 
where
  "vindex [] v n = None"
| "vindex (h # t) v n = (if v = h then (Some (DBVar n)) else (vindex t v (Suc n)))"

lemma vindex_eqvt[eqvt]:
  "(p \<bullet> vindex l v n) = vindex (p \<bullet> l) (p \<bullet> v) (p \<bullet> n)"
  by (induct l arbitrary: n) (simp_all add: permute_pure)

nominal_primrec
  trans :: "lam \<Rightarrow> name list \<Rightarrow> db option"
where
  "trans (Var x) l = vindex l x 0"
| "trans (App t1 t2) xs = dbapp_in (trans t1 xs) (trans t2 xs)"
| "x \<notin> set xs \<Longrightarrow> trans (Lam [x].t) xs = dblam_in (trans t (x # xs))"
  unfolding eqvt_def trans_graph_def
  apply (rule, perm_simp, rule)
  apply (case_tac x)
  apply (rule_tac y="a" and c="b" in lam.strong_exhaust)
  apply (auto simp add: fresh_star_def fresh_at_list)
  apply (rule_tac f="dblam_in" in arg_cong)
  apply (erule Abs1_eq_fdest)
  apply (simp_all add: pure_fresh)
  apply (subgoal_tac "(atom x \<rightleftharpoons> atom xa) \<bullet> xsa = xsa")
  apply (simp add: eqvt_at_def)
  apply (metis atom_name_def swap_fresh_fresh fresh_at_list)
  done

termination
  by (relation "measure (\<lambda>(t,_). size t)") (simp_all add: lam.size)

lemma trans_eqvt[eqvt]:
  "p \<bullet> trans t l = trans (p \<bullet>t) (p \<bullet>l)"
  apply (nominal_induct t avoiding: l p rule: lam.strong_induct)
  apply (simp add: vindex_eqvt)
  apply (simp_all add: permute_pure)
  apply (simp add: fresh_at_list)
  apply (subst trans.simps)
  apply (simp add: fresh_at_list[symmetric])
  apply (drule_tac x="name # l" in meta_spec)
  apply auto
  done

(*
lemma db_trans_test:
  assumes a: "y \<noteq> x"
  shows "trans (Lam [x]. Lam [y]. App (Var x) (Var y)) [] 0 = Some (DBLam (DBLam (DBApp (DBVar 1) (DBVar 0))))"
  using a by simp
*)

abbreviation
  mbind :: "'a option => ('a => 'b option) => 'b option"  ("_ \<guillemotright>= _" [65,65] 65) 
where  
  "c \<guillemotright>= f \<equiv> case c of None => None | (Some v) => f v"

lemma mbind_eqvt:
  fixes c::"'a::pt option"
  shows "(p \<bullet> (c \<guillemotright>= f)) = ((p \<bullet> c) \<guillemotright>= (p \<bullet> f))"
apply(cases c)
apply(simp_all)
apply(perm_simp)
apply(rule refl)
done

lemma mbind_eqvt_raw[eqvt_raw]:
  shows "(p \<bullet> option_case) \<equiv> option_case"
apply(rule eq_reflection)
apply(rule ext)+
apply(case_tac xb)
apply(simp_all)
apply(rule_tac p="-p" in permute_boolE)
apply(perm_simp add: permute_minus_cancel)
apply(simp)
apply(rule_tac p="-p" in permute_boolE)
apply(perm_simp add: permute_minus_cancel)
apply(simp)
done

fun
  index :: "atom list \<Rightarrow> nat \<Rightarrow> atom \<Rightarrow> nat option" 
where
  "index [] n x = None"
| "index (y # ys) n x = (if x = y then (Some n) else (index ys (n + 1) x))"

lemma [eqvt]:
  shows "(p \<bullet> index xs n x) = index (p \<bullet> xs) (p \<bullet> n) (p \<bullet> x)"
apply(induct xs arbitrary: n)
apply(simp_all add: permute_pure)
done


text {* tests of functions containing if and case *}

consts P :: "lam \<Rightarrow> bool"

nominal_primrec  
  A :: "lam => lam"
where  
  "A (App M N) = (if (True \<or> P M) then (A M) else (A N))"
| "A (Var x) = (Var x)" 
| "A (App M N) = (if True then M else A N)"
oops

nominal_primrec  
  C :: "lam => lam"
where  
  "C (App M N) = (case (True \<or> P M) of True \<Rightarrow> (A M) | False \<Rightarrow> (A N))"
| "C (Var x) = (Var x)" 
| "C (App M N) = (if True then M else C N)"
oops

nominal_primrec
  map_term :: "(lam \<Rightarrow> lam) \<Rightarrow> lam \<Rightarrow> lam"
where
  "eqvt f \<Longrightarrow> map_term f (Var x) = f (Var x)"
| "eqvt f \<Longrightarrow> map_term f (App t1 t2) = App (f t1) (f t2)"
| "eqvt f \<Longrightarrow> map_term f (Lam [x].t) = Lam [x].(f t)"
| "\<not>eqvt f \<Longrightarrow> map_term f t = t"
  apply (simp add: eqvt_def map_term_graph_def)
  apply (rule, perm_simp, rule)
  apply (case_tac x, case_tac "eqvt a", case_tac b rule: lam.exhaust)
  apply auto
  apply (simp add: Abs1_eq_iff)
  apply (auto)
  apply (simp add: eqvt_def permute_fun_app_eq)
  apply (drule supp_fun_app_eqvt)
  apply (simp add: fresh_def )
  apply blast
  apply (simp add: eqvt_def permute_fun_app_eq)
  apply (drule supp_fun_app_eqvt)
  apply (simp add: fresh_def )
  apply blast
  done

termination
  by (relation "measure (\<lambda>(_,t). size t)") (simp_all add: lam.size)

nominal_primrec  
  A :: "lam => lam"
where  
  "A (Lam [x].M) = (Lam [x].M)"
| "A (Var x) = (Var x)"
| "A (App M N) = (if True then M else A N)"
oops

nominal_primrec  
  B :: "lam => lam"
where  
  "B (Lam [x].M) = (Lam [x].M)"
| "B (Var x) = (Var x)"
| "B (App M N) = (if True then M else (B N))"
unfolding eqvt_def
unfolding B_graph_def
apply(perm_simp)
apply(rule allI)
apply(rule refl)
oops

text {* "HO" functions *}

nominal_primrec
  trans2 :: "lam \<Rightarrow> atom list \<Rightarrow> db option"
where
  "trans2 (Var x) xs = (index xs 0 (atom x) \<guillemotright>= (\<lambda>n. Some (DBVar n)))"
| "trans2 (App t1 t2) xs = ((trans2 t1 xs) \<guillemotright>= (\<lambda>db1. (trans2 t2 xs) \<guillemotright>= (\<lambda>db2. Some (DBApp db1 db2))))"
| "trans2 (Lam [x].t) xs = (trans2 t (atom x # xs) \<guillemotright>= (\<lambda>db. Some (DBLam db)))"
oops

nominal_primrec
  CPS :: "lam \<Rightarrow> (lam \<Rightarrow> lam) \<Rightarrow> lam"
where
  "CPS (Var x) k = Var x"
| "CPS (App M N) k = CPS M (\<lambda>m. CPS N (\<lambda>n. n))"
oops

(* Problem: nominal_primrec generates non-quantified free variable "x" *)
consts b :: name
nominal_primrec
  Z :: "lam \<Rightarrow> (lam \<Rightarrow> lam) \<Rightarrow> lam"
where
  "Z (App M N) k = Z M (%m. (Z N (%n.(App m n))))"
unfolding eqvt_def Z_graph_def
apply (rule, perm_simp, rule)
oops

(* function tests *)

(* similar problem with function package *)
function
  f :: "int list \<Rightarrow> int"
where
  "f [] = 0"
| "f [e] = e"
| "f (l @ m) = f l + f m"
apply(simp_all)
oops






end



