import Element.elem
import RexpRelated._
import RexpRelated.Rexp._
object Spiral{

  val space = elem(" ")
  val corner = elem("+")

  def spiral(nEdges: Int, direction: Int): Element = {
    if(nEdges == 1)
      elem("+")
    else {
      val sp = spiral(nEdges - 1, (direction + 3) % 4)
      def verticalBar = elem('|', 1, sp.height)
      def horizontalBar = elem('-', sp.width, 1)
      if(direction == 0)
        (corner beside horizontalBar) above sp//(sp beside space)
      else if (direction == 1)
        sp beside (corner above verticalBar)
      else if (direction == 2)
        (space beside sp) above (horizontalBar beside corner)
      else
        (verticalBar above corner) beside (space above sp)
    }
  }
  val alphabet = ("""abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.:"=()\;-+*!<>\/%{} """+"\n\t").toSet//Set('a','b','c')
  def regx_tree(r: ARexp): Element = {
    r match {
      case APRED(bs, f) => {
        val Some(d) = alphabet.find(f)
        d match {
          case '\n' => elem("\\n")
          case '\t' => elem("\\t")
          case ' ' => elem("space")
          case d => elem(d.toString)
        }   
      }
      case AONE(bs) => {
        elem("ONE")
      }
      case AZERO => {
        elem("ZERO")
      }
      case ASEQ(bs, r1, r2) => {
        binary_print("SEQ", r1, r2)
      }
      case AALTS(bs, rs) => {
        //elem("Awaiting completion")
        list_print("ALT", rs)
      }
      case ASTAR(bs, r) => {
        list_print("STA", List(r))
      }
    }
  }
  val port = elem(" └-")
  def list_print(name: String, rs: List[ARexp]): Element = {
    rs match {
      case r::Nil => {
        val pref = regx_tree(r)
        val head = elem(name)
        (head left_align (port up_align pref) ) 
      }
      case r2::r1::Nil => {
        binary_print(name, r2, r1)
      }
      case r::rs1 => {
        val pref = regx_tree(r)
        val head = elem(name)
        if (pref.height > 1){
          val link = elem('|', 1, pref.height - 1)
          (head left_align ((port above link) beside pref)) left_align tail_print(rs1)    
        }
        else{
          (head left_align (port beside pref) ) left_align tail_print(rs1)
        }
      }
    }
  }
  def tail_print(rs: List[ARexp]): Element = {

    rs match {
      case r2::r1::Nil => {
        val pref = regx_tree(r2)
        val suff = regx_tree(r1)
        if (pref.height > 1){
          val link = elem('|', 1, pref.height - 1)
          ((port above link) beside pref) left_align (port up_align suff)
        }
        else{
          (port beside pref) left_align (port up_align suff)
        } 
      }
      case r2::rs1 => {
        val pref = regx_tree(r2)
        
        if (pref.height > 1){
          val link = elem('|', 1, pref.height - 1)
          ((port above link) beside pref) left_align tail_print(rs1)//(port up_align tail_print(rs1) )
        }
        else{
          (port beside pref) left_align tail_print(rs1)//(port up_align tail_print(rs1))
        } 
        //pref left_align tail_print(rs1)
      }
    }
  }

  def binary_print(name: String, r1: ARexp, r2: ARexp): Element = {
    val pref = regx_tree(r1)
    val suff = regx_tree(r2)
    val head = elem(name)
    if (pref.height > 1){
      val link = elem('|', 1, pref.height - 1)
      (head left_align ((port above link) beside pref) ) left_align (port up_align suff)
    }
    else{
      (head left_align (port beside pref) ) left_align (port up_align suff)
    }
  }
  def illustration(r: Rexp, s: String){
    var i_like_imperative_style = internalise(r)
    val all_chars = s.toList
    for (i <- 0 to s.length - 1){
      val der_res =  bder(all_chars(i), i_like_imperative_style)
      val simp_res = bsimp(der_res)
      println("The three regxes are the original regex, the regex after derivative w.r.t " + all_chars(i) + " and the simplification of the derivative.")
      //println(regx_tree(i_like_imperative_style) up_align regx_tree(der_res) up_align regx_tree(simp_res))
      println(asize(i_like_imperative_style), asize(der_res), asize(simp_res))
      i_like_imperative_style = simp_res
    }
  }
  val ran = scala.util.Random
  var alphabet_size = 3
  def balanced_seq_star_gen(depth: Int, star: Boolean): Rexp = {
    if(depth == 1){
      ((ran.nextInt(6) + 97).toChar).toString
    }
    else if(star){
      STAR(balanced_seq_star_gen(depth - 1, false))
    }
    else{
      SEQ(balanced_seq_star_gen(depth - 1, true), balanced_seq_star_gen(depth - 1, true))
    }
  }
  def random_struct_gen(depth:Int): Rexp = {
    val dice = ran.nextInt(3)
    (dice, depth) match {
      case (_, 0) => ((ran.nextInt(alphabet_size) + 97).toChar).toString
      case (0, i) => STAR(random_struct_gen(i - 1))
      case (1, i) => SEQ(random_struct_gen(i - 1), random_struct_gen(i - 1))
      case (2, i) => ALTS( List(random_struct_gen(i - 1), random_struct_gen(i - 1)) )
    }
  }
  def rd_string_gen(alp_size: Int, len: Int): String = {
    ((ran.nextInt(alp_size) + 97).toChar).toString + rd_string_gen(alp_size, len - 1)
  }
  //def stay_same_hpth(r: Rexp, )
  def main(args: Array[String]) {
    val depth = args(0).toInt
    alphabet_size = args(1).toInt
    //illustration(random_struct_gen(depth), rd_string_gen(alphabet_size, 20))//"abcabadaaadcabdbabcdaadbabbcbbdabdabbcbdbabdbcdb")
    for( i <- 50 to 400 by 20){
      println(i+" iterations of prog2:")
      blexing_simp(AWHILE_REGS, prog2 * i)
    }
      
  } 
}