theory ClosedForms imports
"BasicIdentities"
begin

lemma map_concat_cons:
  shows "map f rsa @ f a # rs = map f (rsa @ [a]) @ rs"
  by simp

lemma neg_removal_element_of:
  shows " \<not> a \<notin> aset \<Longrightarrow> a \<in> aset"
  by simp










lemma flts_middle0:
  shows "rflts (rsa @ RZERO # rsb) = rflts (rsa @ rsb)"
  apply(induct rsa)
  apply simp
  by (metis append_Cons rflts.simps(2) rflts.simps(3) rflts_def_idiot)

lemma flts_middle01:
  shows "rflts (rsa @ [RZERO] @ rsb) = rflts (rsa @ rsb)"
  by (simp add: flts_middle0)

lemma flts_append1:
  shows "\<lbrakk>a \<noteq> RZERO; \<nexists>rs1. a = RALTS rs1; a \<in> set rs\<rbrakk>  \<Longrightarrow>
         rflts (rsa @ [a] @ rsb) = rflts rsa @ [a] @ (rflts rsb)"
  apply(induct rsa arbitrary: rsb)
   apply simp
  using rflts_def_idiot apply presburger
  apply(case_tac aa)  
       apply simp+
  done



lemma simp_removes_duplicate1:
  shows  " a \<in> set rsa \<Longrightarrow> rsimp (RALTS (rsa @ [a])) =  rsimp (RALTS (rsa))"
and " rsimp (RALTS (a1 # rsa @ [a1])) = rsimp (RALTS (a1 # rsa))"
  apply(induct rsa arbitrary: a1)
     apply simp
    apply simp
  prefer 2
  apply(case_tac "a = aa")
     apply simp
    apply simp
  apply (metis Cons_eq_appendI Cons_eq_map_conv distinct_removes_duplicate_flts list.set_intros(2))
  apply (metis append_Cons append_Nil distinct_removes_duplicate_flts list.set_intros(1) list.simps(8) list.simps(9))
  by (metis (mono_tags, lifting) append_Cons distinct_removes_duplicate_flts list.set_intros(1) list.simps(8) list.simps(9) map_append rsimp.simps(2))
  
lemma simp_removes_duplicate2:
  shows "a \<in> set rsa \<Longrightarrow> rsimp (RALTS (rsa @ [a] @ rsb)) = rsimp (RALTS (rsa @ rsb))"
  apply(induct rsb arbitrary: rsa)
   apply simp
  using distinct_removes_duplicate_flts apply auto[1]
  by (metis append.assoc head_one_more_simp rsimp.simps(2) simp_flatten simp_removes_duplicate1(1))

lemma simp_removes_duplicate3:
  shows "a \<in> set rsa \<Longrightarrow> rsimp (RALTS (rsa @ a # rsb)) = rsimp (RALTS (rsa @ rsb))"
  using simp_removes_duplicate2 by auto

lemma distinct_removes_middle4:
  shows "a \<in> set rsa \<Longrightarrow> rdistinct (rsa @ [a] @ rsb) rset = rdistinct (rsa @ rsb) rset"
  using distinct_removes_middle(1) by fastforce

lemma distinct_removes_middle_list:
  shows "\<forall>a \<in> set x. a \<in> set rsa \<Longrightarrow> rdistinct (rsa @ x @ rsb) rset = rdistinct (rsa @ rsb) rset"
  apply(induct x)
   apply simp
  by (simp add: distinct_removes_middle3)


lemma distinct_removes_duplicate_flts2:
  shows " a \<in> set rsa
       \<Longrightarrow> rdistinct (rflts (rsa @ [a] @ rsb)) {} =
           rdistinct (rflts (rsa @ rsb)) {}"
  apply(induct a arbitrary: rsb)
  using flts_middle01 apply presburger
      apply(subgoal_tac "rflts (rsa @ [RONE] @ rsb) = rflts rsa @ [RONE] @ rflts rsb")
  prefer 2
  using flts_append1 apply blast
      apply simp
      apply(subgoal_tac "RONE \<in> set (rflts rsa)")
  prefer 2
  using rflts_def_idiot2 apply blast
      apply(subst distinct_removes_middle3)
       apply simp
  using flts_append apply presburger
     apply simp
  apply (metis distinct_removes_middle3 flts_append in_set_conv_decomp rflts.simps(5))
  apply (metis distinct_removes_middle(1) flts_append flts_append1 rflts_def_idiot2 rrexp.distinct(25) rrexp.distinct(5))
   apply(subgoal_tac "rflts (rsa @ [RALTS x] @ rsb) = rflts rsa @ x @ rflts rsb")
    prefer 2
  apply (simp add: flts_append)
   apply (simp only:)

   apply(subgoal_tac "\<forall>r1 \<in> set x. r1 \<in> set (rflts rsa)")
    prefer 2
  using spilled_alts_contained apply blast
  apply(subst flts_append)
  using distinct_removes_middle_list apply blast
  using distinct_removes_middle2 flts_append rflts_def_idiot2 by fastforce


lemma simp_removes_duplicate:
  shows "a \<in> set rsa \<Longrightarrow> rsimp (rsimp_ALTs (rsa @ a # rs)) =  rsimp (rsimp_ALTs (rsa @ rs))"
  apply(subgoal_tac "rsimp (rsimp_ALTs (rsa @ a # rs)) = rsimp (RALTS (rsa @ a # rs))")
   prefer 2
  apply (smt (verit, best) Cons_eq_append_conv append_is_Nil_conv empty_set equals0D list.distinct(1) rsimp_ALTs.elims)
  apply(simp only:)
  apply simp
  apply(subgoal_tac "(rdistinct (rflts (map rsimp rsa @ rsimp a # map rsimp rs)) {}) = (rdistinct (rflts (map rsimp rsa @  map rsimp rs)) {})")
   apply(simp only:)
  prefer 2
   apply(subgoal_tac "rsimp a \<in> set (map rsimp rsa)")
    prefer 2
  apply simp
  using distinct_removes_duplicate_flts2 apply force
  apply(case_tac rsa)
   apply simp
  apply(case_tac rs)
   apply simp
   apply(case_tac list)
    apply simp
  using idem_after_simp1 apply presburger
   apply simp+
  apply(subgoal_tac "rsimp_ALTs (aa # list @ aaa # lista) = RALTS (aa # list @ aaa # lista)")
   apply simp
  using rsimpalts_conscons by presburger








inductive frewrite:: "rrexp list \<Rightarrow> rrexp list \<Rightarrow> bool" ("_ \<leadsto>f _" [10, 10] 10)
  where
  "(RZERO # rs) \<leadsto>f rs"
| "((RALTS rs) # rsa) \<leadsto>f (rs @ rsa)"
| "rs1 \<leadsto>f rs2 \<Longrightarrow> (r # rs1) \<leadsto>f (r # rs2)"


inductive 
  frewrites:: "rrexp list \<Rightarrow> rrexp list \<Rightarrow> bool" ("_ \<leadsto>f* _" [10, 10] 10)
where 
  [intro, simp]:"rs \<leadsto>f* rs"
| [intro]: "\<lbrakk>rs1 \<leadsto>f* rs2; rs2 \<leadsto>f rs3\<rbrakk> \<Longrightarrow> rs1 \<leadsto>f* rs3"

inductive grewrite:: "rrexp list \<Rightarrow> rrexp list \<Rightarrow> bool" ("_ \<leadsto>g _" [10, 10] 10)
  where
  "(RZERO # rs) \<leadsto>g rs"
| "((RALTS rs) # rsa) \<leadsto>g (rs @ rsa)"
| "rs1 \<leadsto>g rs2 \<Longrightarrow> (r # rs1) \<leadsto>g (r # rs2)"
| "rsa @ [a] @ rsb @ [a] @ rsc \<leadsto>g rsa @ [a] @ rsb @ rsc" 

lemma grewrite_variant1:
  shows "a \<in> set rs1 \<Longrightarrow> rs1 @ a # rs \<leadsto>g rs1 @ rs"
  apply (metis append.assoc append_Cons append_Nil grewrite.intros(4) split_list_first)
  done


inductive 
  grewrites:: "rrexp list \<Rightarrow> rrexp list \<Rightarrow> bool" ("_ \<leadsto>g* _" [10, 10] 10)
where 
  [intro, simp]:"rs \<leadsto>g* rs"
| [intro]: "\<lbrakk>rs1 \<leadsto>g* rs2; rs2 \<leadsto>g rs3\<rbrakk> \<Longrightarrow> rs1 \<leadsto>g* rs3"



(*
inductive 
  frewrites2:: "rrexp list \<Rightarrow> rrexp list \<Rightarrow> bool" ("_ <\<leadsto>f* _" [10, 10] 10)
where 
 [intro]: "\<lbrakk>rs1 \<leadsto>f* rs2; rs2 \<leadsto>f* rs1\<rbrakk> \<Longrightarrow> rs1 <\<leadsto>f* rs2"
*)

lemma fr_in_rstar : "r1 \<leadsto>f r2 \<Longrightarrow> r1 \<leadsto>f* r2"
  using frewrites.intros(1) frewrites.intros(2) by blast
 
lemma freal_trans[trans]: 
  assumes a1: "r1 \<leadsto>f* r2"  and a2: "r2 \<leadsto>f* r3"
  shows "r1 \<leadsto>f* r3"
  using a2 a1
  apply(induct r2 r3 arbitrary: r1 rule: frewrites.induct) 
  apply(auto)
  done


lemma  many_steps_later: "\<lbrakk>r1 \<leadsto>f r2; r2 \<leadsto>f* r3 \<rbrakk> \<Longrightarrow> r1 \<leadsto>f* r3"
  by (meson fr_in_rstar freal_trans)


lemma gr_in_rstar : "r1 \<leadsto>g r2 \<Longrightarrow> r1 \<leadsto>g* r2"
  using grewrites.intros(1) grewrites.intros(2) by blast
 
lemma greal_trans[trans]: 
  assumes a1: "r1 \<leadsto>g* r2"  and a2: "r2 \<leadsto>g* r3"
  shows "r1 \<leadsto>g* r3"
  using a2 a1
  apply(induct r2 r3 arbitrary: r1 rule: grewrites.induct) 
  apply(auto)
  done


lemma  gmany_steps_later: "\<lbrakk>r1 \<leadsto>g r2; r2 \<leadsto>g* r3 \<rbrakk> \<Longrightarrow> r1 \<leadsto>g* r3"
  by (meson gr_in_rstar greal_trans)

lemma gstar_rdistinct_general:
  shows "rs1 @  rs \<leadsto>g* rs1 @ (rdistinct rs (set rs1))"
  apply(induct rs arbitrary: rs1)
   apply simp
  apply(case_tac " a \<in> set rs1")
   apply simp
  apply(subgoal_tac "rs1 @ a # rs \<leadsto>g rs1 @ rs")
  using gmany_steps_later apply auto[1]
  apply (metis append.assoc append_Cons append_Nil grewrite.intros(4) split_list_first)
  apply simp
  apply(drule_tac x = "rs1 @ [a]" in meta_spec)
  by simp


lemma gstar_rdistinct:
  shows "rs \<leadsto>g* rdistinct rs {}"
  apply(induct rs)
   apply simp
  by (metis append.left_neutral empty_set gstar_rdistinct_general)



lemma frewrite_append:
  shows "\<lbrakk> rsa \<leadsto>f rsb \<rbrakk> \<Longrightarrow> rs @ rsa \<leadsto>f rs @ rsb"
  apply(induct rs)
   apply simp+
  using frewrite.intros(3) by blast

lemma grewrite_append:
  shows "\<lbrakk> rsa \<leadsto>g rsb \<rbrakk> \<Longrightarrow> rs @ rsa \<leadsto>g rs @ rsb"
  apply(induct rs)
   apply simp+
  using grewrite.intros(3) by blast
  


lemma frewrites_cons:
  shows "\<lbrakk> rsa \<leadsto>f* rsb \<rbrakk> \<Longrightarrow> r # rsa \<leadsto>f* r # rsb"
  apply(induct rsa rsb rule: frewrites.induct)
   apply simp
  using frewrite.intros(3) by blast


lemma grewrites_cons:
  shows "\<lbrakk> rsa \<leadsto>g* rsb \<rbrakk> \<Longrightarrow> r # rsa \<leadsto>g* r # rsb"
  apply(induct rsa rsb rule: grewrites.induct)
   apply simp
  using grewrite.intros(3) by blast


lemma frewrites_append:
  shows " \<lbrakk>rsa \<leadsto>f* rsb\<rbrakk> \<Longrightarrow> (rs @ rsa) \<leadsto>f* (rs @ rsb)"
  apply(induct rs)
   apply simp
  by (simp add: frewrites_cons)

lemma grewrites_append:
  shows " \<lbrakk>rsa \<leadsto>g* rsb\<rbrakk> \<Longrightarrow> (rs @ rsa) \<leadsto>g* (rs @ rsb)"
  apply(induct rs)
   apply simp
  by (simp add: grewrites_cons)



lemma frewrites_concat:
  shows "\<lbrakk>rs1 \<leadsto>f rs2; rsa \<leadsto>f* rsb \<rbrakk> \<Longrightarrow> (rs1 @ rsa) \<leadsto>f* (rs2 @ rsb)"
  apply(induct rs1 rs2 rule: frewrite.induct)
    apply(simp)
  apply(subgoal_tac "(RZERO # rs @ rsa) \<leadsto>f (rs @ rsa)")
  prefer 2
  using frewrite.intros(1) apply blast
    apply(subgoal_tac "(rs @ rsa) \<leadsto>f* (rs @ rsb)")
  using many_steps_later apply blast
  apply (simp add: frewrites_append)
  apply (metis append.assoc append_Cons frewrite.intros(2) frewrites_append many_steps_later)
  using frewrites_cons by auto

lemma grewrites_concat:
  shows "\<lbrakk>rs1 \<leadsto>g rs2; rsa \<leadsto>g* rsb \<rbrakk> \<Longrightarrow> (rs1 @ rsa) \<leadsto>g* (rs2 @ rsb)"
  apply(induct rs1 rs2 rule: grewrite.induct)
    apply(simp)
  apply(subgoal_tac "(RZERO # rs @ rsa) \<leadsto>g (rs @ rsa)")
  prefer 2
  using grewrite.intros(1) apply blast
    apply(subgoal_tac "(rs @ rsa) \<leadsto>g* (rs @ rsb)")
  using gmany_steps_later apply blast
  apply (simp add: grewrites_append)
  apply (metis append.assoc append_Cons grewrite.intros(2) grewrites_append gmany_steps_later)
  using grewrites_cons apply auto
  apply(subgoal_tac "rsaa @ a # rsba @ a # rsc @ rsa \<leadsto>g* rsaa @ a # rsba @ a # rsc @ rsb")
  using grewrite.intros(4) grewrites.intros(2) apply force
  using grewrites_append by auto


lemma grewritess_concat:
  shows "\<lbrakk>rsa \<leadsto>g* rsb; rsc \<leadsto>g* rsd \<rbrakk> \<Longrightarrow> (rsa @ rsc) \<leadsto>g* (rsb @ rsd)"
  apply(induct rsa rsb rule: grewrites.induct)
   apply(case_tac rs)
    apply simp
  using grewrites_append apply blast   
  by (meson greal_trans grewrites.simps grewrites_concat)

fun alt_set:: "rrexp \<Rightarrow> rrexp set"
  where
  "alt_set (RALTS rs) = set rs \<union> \<Union> (alt_set ` (set rs))"
| "alt_set r = {r}"

lemma alt_set_has_all:
  shows "RALTS rs \<in> alt_set rx \<Longrightarrow> set rs \<subseteq> alt_set rx"
  apply(induct rx arbitrary: rs)
       apply simp_all
  apply(rename_tac rSS rss)
  using in_mono by fastforce




lemma grewrite_equal_rsimp:
  shows "\<lbrakk>rs1 \<leadsto>g rs2; rsimp_ALTs (rdistinct (rflts (map rsimp rs1)) (rset \<union> \<Union>(alt_set ` rset))) =
          rsimp_ALTs (rdistinct (rflts (map rsimp rs2)) (rset \<union> \<Union>(alt_set ` rset)))\<rbrakk>
       \<Longrightarrow> rsimp_ALTs (rdistinct (rflts (rsimp r # map rsimp rs1))  (rset \<union> \<Union>(alt_set ` rset))) =
           rsimp_ALTs (rdistinct (rflts (rsimp r # map rsimp rs2))  (rset \<union> \<Union>(alt_set ` rset)))"
  apply(induct rs1 rs2 arbitrary:rset rule: grewrite.induct)
     apply simp
  apply (metis append_Cons append_Nil flts_middle0)
    apply(case_tac "rsimp r \<in> rset")
     apply simp
  oops

lemma grewrite_cases_middle:
  shows "rs1 \<leadsto>g rs2 \<Longrightarrow> 
(\<exists>rsa rsb rsc. rs1 =  (rsa @ [RALTS rsb] @ rsc) \<and> rs2 = (rsa @ rsb @ rsc)) \<or>
(\<exists>rsa rsc. rs1 = rsa @ [RZERO] @ rsc \<and> rs2 = rsa @ rsc) \<or>
(\<exists>rsa rsb rsc a. rs1 = rsa @ [a] @ rsb @ [a] @ rsc \<and> rs2 = rsa @ [a] @ rsb @ rsc)"
  apply( induct rs1 rs2 rule: grewrite.induct)
     apply simp
  apply blast
  apply (metis append_Cons append_Nil)
  apply (metis append_Cons)
  by blast


lemma grewrite_equal_rsimp:
  shows "rs1 \<leadsto>g rs2 \<Longrightarrow> rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  apply(frule grewrite_cases_middle)
  apply(case_tac "(\<exists>rsa rsb rsc. rs1 = rsa @ [RALTS rsb] @ rsc \<and> rs2 = rsa @ rsb @ rsc)")  
  using simp_flatten3 apply auto[1]
  apply(case_tac "(\<exists>rsa rsc. rs1 = rsa @ [RZERO] @ rsc \<and> rs2 = rsa @ rsc)")
  apply (metis (mono_tags, opaque_lifting) append_Cons append_Nil list.set_intros(1) list.simps(9) rflts.simps(2) rsimp.simps(2) rsimp.simps(3) simp_removes_duplicate3)
  by (smt (verit) append.assoc append_Cons append_Nil in_set_conv_decomp simp_removes_duplicate3)


lemma grewrites_equal_rsimp:
  shows "rs1 \<leadsto>g* rs2 \<Longrightarrow> rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  apply (induct rs1 rs2 rule: grewrites.induct)
  apply simp
  using grewrite_equal_rsimp by presburger
  



lemma grewrites_equal_simp_2:
  shows "rsimp (RALTS rs1) = rsimp (RALTS rs2) \<Longrightarrow> rs1 \<leadsto>g* rs2"
  oops




lemma grewrites_last:
  shows "r # [RALTS rs] \<leadsto>g*  r # rs"
  by (metis gr_in_rstar grewrite.intros(2) grewrite.intros(3) self_append_conv)

lemma simp_flatten2:
  shows "rsimp (RALTS (r # [RALTS rs])) = rsimp (RALTS (r # rs))"
  using grewrites_equal_rsimp grewrites_last by blast

lemma frewrites_middle:
  shows "rs1 \<leadsto>f* rs2 \<Longrightarrow> r # (RALTS rs # rs1) \<leadsto>f* r # (rs @ rs1)"
  by (simp add: fr_in_rstar frewrite.intros(2) frewrite.intros(3))

lemma frewrites_alt:
  shows "rs1 \<leadsto>f* rs2 \<Longrightarrow> (RALT r1 r2) # rs1 \<leadsto>f* r1 # r2 # rs2"  
  by (metis Cons_eq_appendI append_self_conv2 frewrite.intros(2) frewrites_cons many_steps_later)

lemma early_late_der_frewrites:
  shows "map (rder x) (rflts rs) \<leadsto>f* rflts (map (rder x) rs)"
  apply(induct rs)
   apply simp
  apply(case_tac a)
       apply simp+
  using frewrite.intros(1) many_steps_later apply blast
     apply(case_tac "x = x3")
      apply simp
  using frewrites_cons apply presburger
  using frewrite.intros(1) many_steps_later apply fastforce
  apply(case_tac "rnullable x41")
     apply simp+
     apply (simp add: frewrites_alt)
  apply (simp add: frewrites_cons)
   apply (simp add: frewrites_append)
  by (simp add: frewrites_cons)




lemma with_wo0_distinct:
  shows "rdistinct rs rset \<leadsto>f* rdistinct rs (insert RZERO rset)"
  apply(induct rs arbitrary: rset)
   apply simp
  apply(case_tac a)
  apply(case_tac "RZERO \<in> rset")
        apply simp+
  using fr_in_rstar frewrite.intros(1) apply presburger
  apply (case_tac "RONE \<in> rset")
       apply simp+
  using frewrites_cons apply presburger
     apply(case_tac "a \<in> rset")
  apply simp
  apply (simp add: frewrites_cons)
     apply(case_tac "a \<in> rset")
  apply simp
  apply (simp add: frewrites_cons)
       apply(case_tac "a \<in> rset")
  apply simp
  apply (simp add: frewrites_cons)
       apply(case_tac "a \<in> rset")
  apply simp
  apply (simp add: frewrites_cons)
  done

(*Interesting lemma: not obvious but easily proven by sledgehammer*)

  


(*lemma induction last rule not go through
 example:
r #
           rdistinct rs1
            (insert RZERO
              (insert r
                (rset \<union>
                 \<Union> (alt_set `
                     rset)))) \<leadsto>g* r #
                                   rdistinct rs2
                                    (insert RZERO (insert r (rset \<union> \<Union> (alt_set ` rset))))
 rs2 = [+rs] rs3 = rs,
r = +rs
[] \<leadsto>g* rs which is wrong
*)







lemma frewrite_simpeq:
  shows "rs1 \<leadsto>f rs2 \<Longrightarrow> rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  apply(induct rs1 rs2 rule: frewrite.induct)
    apply simp
  using simp_flatten apply presburger
  by (metis (no_types, opaque_lifting) grewrites_equal_rsimp grewrites_last list.simps(9) rsimp.simps(2))

lemma gstar0:
  shows "rsa @ (rdistinct rs (set rsa)) \<leadsto>g* rsa @ (rdistinct rs (insert RZERO (set rsa)))"
  apply(induct rs arbitrary: rsa)
   apply simp
  apply(case_tac "a = RZERO")
   apply simp
  
  using gr_in_rstar grewrite.intros(1) grewrites_append apply presburger
  apply(case_tac "a \<in> set rsa")
   apply simp+
  apply(drule_tac x = "rsa @ [a]" in meta_spec)
  by simp
  
lemma gstar01:
  shows "rdistinct rs {} \<leadsto>g* rdistinct rs {RZERO}"
  by (metis empty_set gstar0 self_append_conv2)


lemma grewrite_rdistinct_aux:
  shows "rs @ rdistinct rsa rset \<leadsto>g* rs @ rdistinct rsa (rset \<union> set rs)"
  sorry

lemma grewrite_rdistinct_worth1:
  shows "(rsb @ [a]) @ rdistinct rs set1 \<leadsto>g* (rsb @ [a]) @ rdistinct rs (insert a set1)"
  by (metis append.assoc empty_set grewrite_rdistinct_aux grewrites_append inf_sup_aci(5) insert_is_Un list.simps(15))

lemma grewrite_rdisitinct:
  shows "rs @ rdistinct rsa {RALTS rs} \<leadsto>g* rs @ rdistinct rsa (insert (RALTS rs) (set rs))"
  apply(induct rsa arbitrary: rs)
   apply simp
  apply(case_tac "a = RALTS rs")
  apply simp
  apply(case_tac "a \<in> set rs")
   apply simp
  apply(subgoal_tac "rs @
           a # rdistinct rsa {RALTS rs, a} \<leadsto>g rs @ rdistinct rsa {RALTS rs, a}")
    apply(subgoal_tac 
"rs @ rdistinct rsa {RALTS rs, a} \<leadsto>g* rs @ rdistinct rsa (insert (RALTS rs) (set rs))")
  using gmany_steps_later apply blast
    apply(subgoal_tac 
" rs @ rdistinct rsa {RALTS rs, a} \<leadsto>g* rs @ rdistinct rsa ({RALTS rs, a} \<union> set rs)")
     apply (simp add: insert_absorb)
  using grewrite_rdistinct_aux apply blast
  using grewrite_variant1 apply blast
  by (metis grewrite_rdistinct_aux insert_is_Un)

  
lemma frewrite_rd_grewrites_general:
  shows "\<lbrakk>rs1 \<leadsto>f rs2; \<And>rs. \<exists>rs3. 
(rs @ (rdistinct rs1 (set rs)) \<leadsto>g* rs3) \<and> (rs @ (rdistinct rs2 (set rs)) \<leadsto>g* rs3)\<rbrakk>
       \<Longrightarrow> 
\<exists>rs3. (rs @ (r # rdistinct rs1 (set rs \<union> {r})) \<leadsto>g* rs3) \<and> (rs @ (r # rdistinct rs2 (set rs \<union> {r})) \<leadsto>g* rs3)"
  apply(drule_tac x = "rs @ [r]" in meta_spec )
  by simp


lemma grewrites_middle_distinct:
  shows "RALTS rs \<in> set rsb \<Longrightarrow> 
         rsb @
       rdistinct ( rs @ rsa)
        (set rsb) \<leadsto>g* rsb @ rdistinct rsa (set rsb)"
  sorry



lemma frewrite_rd_grewrites_aux:
  shows     "  rsb @
       rdistinct (RALTS rs # rsa)
        (set rsb) \<leadsto>g* rsb @
                       rdistinct rs (set rsb) @ rdistinct rsa (insert (RALTS rs) (set rs) \<union> set rsb)"

  
  sorry

lemma flts_gstar:
  shows "rs \<leadsto>g* rflts rs"
  sorry

lemma list_dlist_union:
  shows "set rs \<subseteq> set rsb \<union> set (rdistinct rs (set rsb))"
  by (metis rdistinct_concat_general rdistinct_set_equality set_append sup_ge2)

lemma subset_distinct_rewrite1:
  shows "set1 \<subseteq> set rsb \<Longrightarrow> rsb @ rs \<leadsto>g* rsb @ (rdistinct rs set1)"
  apply(induct rs arbitrary: rsb)
   apply simp
  apply(case_tac "a \<in> set1")
   apply simp
  
  using gmany_steps_later grewrite_variant1 apply blast
  apply simp
  apply(drule_tac x = "rsb @ [a]" in meta_spec)
  apply(subgoal_tac "set1 \<subseteq> set (rsb @ [a])")
   apply (simp only:)
  apply(subgoal_tac "(rsb @ [a]) @ rdistinct rs set1 \<leadsto>g* (rsb @ [a]) @ rdistinct rs (insert a set1)")
    apply (metis (no_types, opaque_lifting) append.assoc append_Cons append_Nil greal_trans)
  apply (metis append.assoc empty_set grewrite_rdistinct_aux grewrites_append inf_sup_aci(5) insert_is_Un list.simps(15))
  by auto


lemma subset_distinct_rewrite:
  shows "set rsb' \<subseteq> set rsb \<Longrightarrow> rsb @ rs \<leadsto>g* rsb @ (rdistinct rs (set rsb'))"
  by (simp add: subset_distinct_rewrite1)
  


lemma distinct_3list:
  shows "rsb @ (rdistinct rs (set rsb)) @ rsa \<leadsto>g* 
         rsb @ (rdistinct rs (set rsb)) @ (rdistinct rsa (set rs))"
  by (metis append.assoc list_dlist_union set_append subset_distinct_rewrite)
  



lemma grewrites_shape1:
  shows "      RALTS rs \<notin> set rsb \<Longrightarrow>
       rsb @
       RALTS rs #
       rdistinct rsa
        (
          (set rsb)) \<leadsto>g* rsb @
                          rdistinct rs (set rsb) @
                          rdistinct (rflts (rdistinct rsa ( (set rsb \<union> set rs)))) (set rs)"


  apply (subgoal_tac "       rsb @
       RALTS rs #
       rdistinct rsa
        (
          (set rsb))  \<leadsto>g*        rsb @
       rs @
       rdistinct rsa
        (
          (set rsb)) ")
   prefer 2
  using gr_in_rstar grewrite.intros(2) grewrites_append apply presburger
  apply(subgoal_tac "rsb @ rs @ rdistinct rsa (  (set rsb)) \<leadsto>g* rsb @ 
(rdistinct rs (set rsb) @ rdistinct rsa (  (set rsb)))")
  prefer 2
  apply (metis append_assoc grewrites.intros(1) grewritess_concat gstar_rdistinct_general)
  apply(subgoal_tac " rsb @ rdistinct rs (set rsb) @ rdistinct rsa (  (set rsb))
\<leadsto>g*  rsb @ rdistinct rs (set rsb) @ rdistinct rsa (  (set rsb) \<union> (set rs))")
  prefer 2
  apply (smt (verit, best) append.assoc append_assoc boolean_algebra_cancel.sup2 grewrite_rdistinct_aux inf_sup_aci(5) insert_is_Un rdistinct_concat_general rdistinct_set_equality set_append sup.commute sup.right_idem sup_commute)
  apply(subgoal_tac "rdistinct rsa (  (set rsb)  \<union> set rs) \<leadsto>g*
rflts (rdistinct rsa (  (set rsb) \<union> set rs))")
   apply(subgoal_tac "rsb @ (rdistinct rs (set rsb)) @ rflts (rdistinct rsa (  (set rsb) \<union> set rs)) \<leadsto>g* 
rsb @ (rdistinct rs (set rsb)) @ (rdistinct (rflts (rdistinct rsa (  (set rsb) \<union> set rs))) (set rs))")
  apply (smt (verit, ccfv_SIG) Un_insert_left greal_trans grewrites_append)
  using distinct_3list apply presburger
  using flts_gstar apply blast
  done

lemma r_finite1:
  shows "r = RALTS (r # rs) = False"
  apply(induct r)
  apply simp+
   apply (metis list.set_intros(1))
  by blast
  


lemma grewrite_singleton:
  shows "[r] \<leadsto>g r # rs \<Longrightarrow> rs = []"
  apply (induct "[r]" "r # rs" rule: grewrite.induct)
    apply simp
  apply (metis r_finite1)
  using grewrite.simps apply blast
  by simp

lemma impossible_grewrite1:
  shows "\<not>( [RONE] \<leadsto>g [])"
  using grewrite.cases by fastforce


lemma impossible_grewrite2:
  shows "\<not> ([RALTS rs] \<leadsto>g (RALTS rs) # a # rs)"
  
  using grewrite_singleton by blast
thm grewrite.cases
lemma impossible_grewrite3:
  shows "\<not> (RALTS rs # rs1 \<leadsto>g (RALTS rs) # a # rs1)"
  oops


lemma grewrites_singleton:
  shows "[r] \<leadsto>g* r # rs \<Longrightarrow> rs = []"
  apply(induct "[r]" "r # rs" rule: grewrites.induct)
   apply simp
  
  oops

lemma grewrite_nonequal_elem:
  shows "r # rs2 \<leadsto>g r # rs3 \<Longrightarrow> rs2 \<leadsto>g rs3"
  oops

lemma grewrites_nonequal_elem:
  shows "r # rs2 \<leadsto>g* r # rs3 \<Longrightarrow> rs2 \<leadsto>g* rs3"
  apply(induct r)
  
  oops

  


lemma :
  shows "rs1 @ rs2 \<leadsto>g* rs1 @ rs3 \<Longrightarrow> rs2 \<leadsto>g* rs3"
  apply(induct rs1 arbitrary: rs2 rs3 rule: rev_induct)
   apply simp
  apply(drule_tac x = "[x] @ rs2" in meta_spec)
  apply(drule_tac x = "[x] @ rs3" in meta_spec)
  apply(simp)

  oops



lemma grewrites_shape3_aux:
  shows "rs @ (rdistinct rsa (insert (RALTS rs) rsc)) \<leadsto>g* rs @ rdistinct (rflts (rdistinct rsa rsc)) (set rs)"
  apply(induct rsa arbitrary: rsc rs)
   apply simp
  apply(case_tac "a \<in> rsc")
   apply simp
  apply(case_tac "a = RALTS rs")
   apply simp
  apply(subgoal_tac " rdistinct (rs @ rflts (rdistinct rsa (insert (RALTS rs) rsc))) (set rs) \<leadsto>g*
 rdistinct (rflts (rdistinct rsa (insert (RALTS rs) rsc))) (set rs)")
  apply (metis insertI1 insert_absorb rdistinct_concat2)
   apply (simp add: rdistinct_concat)

  apply simp
  apply(case_tac "a = RZERO")
  apply (metis gmany_steps_later grewrite.intros(1) grewrite_append rflts.simps(2))
  apply(case_tac "\<exists>rs1. a = RALTS rs1")
   prefer 2
   apply simp
   apply(subgoal_tac "rflts (a # rdistinct rsa (insert a rsc)) = a # rflts (rdistinct rsa (insert a rsc))")
    apply (simp  only:)
    apply(case_tac "a \<notin> set rs")
     apply simp
  apply(drule_tac x = "insert a rsc" in meta_spec)
  apply(drule_tac x = "rs " in meta_spec)
  
    apply(erule exE)
    apply simp
  apply(subgoal_tac "RALTS rs1 #
           rdistinct rsa
            (insert (RALTS rs)
              (insert (RALTS rs1)
                rsc)) \<leadsto>g* rs1 @
           rdistinct rsa
            (insert (RALTS rs)
              (insert (RALTS rs1)
                rsc)) ")
     apply(subgoal_tac " rs1 @
           rdistinct rsa
            (insert (RALTS rs)
              (insert (RALTS rs1)
                rsc)) \<leadsto>g*
                        rs1 @
           rdistinct rsa
            (insert (RALTS rs)
              (insert (RALTS rs1)
                rsc))")
  
  apply(case_tac "a \<in> set rs")
  


  sorry


lemma grewrites_shape3:
  shows "      RALTS rs \<notin> set rsb \<Longrightarrow>
       rsb @
       RALTS rs #
       rdistinct rsa
        (insert (RALTS rs)
          (set rsb)) \<leadsto>g* rsb @
                          rdistinct rs (set rsb) @
                          rdistinct (rflts (rdistinct rsa (set rsb \<union> set rs))) (set rs)"
  apply(subgoal_tac "rsb @ RALTS rs # rdistinct rsa (insert (RALTS rs) (set rsb)) \<leadsto>g*
                     rsb @ rs @ rdistinct rsa (insert (RALTS rs) (set rsb))")
  prefer 2
  using gr_in_rstar grewrite.intros(2) grewrites_append apply presburger
  apply(subgoal_tac "rsb @ rs @ rdistinct rsa (insert (RALTS rs) (set rsb )) \<leadsto>g*
                     rsb @ rs @ rdistinct rsa (insert (RALTS rs) (set rsb \<union> set rs))")
  prefer 2
  apply (metis Un_insert_left grewrite_rdistinct_aux grewrites_append)

  apply(subgoal_tac "rsb @  rs @ rdistinct rsa (insert (RALTS rs) (set rsb \<union> set rs)) \<leadsto>g* 
rsb @ rs @ rdistinct (rflts (rdistinct rsa (set rsb \<union> set rs))) (set rs)")
   prefer 2
  using grewrites_append grewrites_shape3_aux apply presburger
  apply(subgoal_tac "rsb @ rs \<leadsto>g* rsb @ rdistinct rs (set rsb)")
  apply (smt (verit, ccfv_SIG) append_eq_appendI greal_trans grewrites.simps grewritess_concat)
  using gstar_rdistinct_general by blast


lemma grewrites_shape2:
  shows "       RALTS rs \<notin> set rsb \<Longrightarrow>
       rsb @
       rdistinct (rs @ rsa)
        (set rsb) \<leadsto>g* rsb @
                       rdistinct rs (set rsb) @
                       rdistinct (rflts (rdistinct rsa (set rsb \<union> set rs))) (set rs)"

 (* by (smt (z3) append.assoc distinct_3list flts_gstar greal_trans grewrites_append rdistinct_concat_general same_append_eq set_append)
*)
  sorry





lemma frewrite_rd_grewrites:
  shows "rs1 \<leadsto>f rs2 \<Longrightarrow> 
\<exists>rs3. (rs @ (rdistinct rs1 (set rs)) \<leadsto>g* rs3) \<and> (rs @ (rdistinct rs2 (set rs)) \<leadsto>g* rs3) "
  apply(induct rs1 rs2 arbitrary: rs rule: frewrite.induct)
    apply(rule_tac x = "rsa @ (rdistinct rs ({RZERO} \<union> set rsa))" in exI)
    apply(rule conjI)
  apply(case_tac "RZERO \<in> set rsa")
  apply simp+
  using gstar0 apply fastforce
     apply (simp add: gr_in_rstar grewrite.intros(1) grewrites_append)
    apply (simp add: gstar0)
    prefer 2
    apply(case_tac "r \<in> set rs")
  apply simp
    apply(drule_tac x = "rs @ [r]" in meta_spec)
    apply(erule exE)
    apply(rule_tac x = "rs3" in exI)
   apply simp
  apply(case_tac "RALTS rs \<in> set rsb")
   apply simp
   apply(rule_tac x = "rflts rsb @ rdistinct rsa (set rsb)" in exI)
   apply(rule conjI)
  apply (simp add: flts_gstar grewritess_concat)
  apply (meson flts_gstar greal_trans grewrites.intros(1) grewrites_middle_distinct grewritess_concat)
  apply(simp)
  apply(rule_tac x = 
"rsb @ (rdistinct rs (set rsb)) @
 (rdistinct (rflts (rdistinct  rsa ( (set rsb \<union> set rs)) ) ) (set rs))" in exI)
  apply(rule conjI)
   prefer 2
  using grewrites_shape2 apply force
  using grewrites_shape3 by auto



lemma frewrite_simprd:
  shows "rs1 \<leadsto>f rs2 \<Longrightarrow> rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  by (meson frewrite_simpeq)


lemma frewrites_rd_grewrites:
  shows "rs1 \<leadsto>f* rs2 \<Longrightarrow>
rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  apply(induct rs1 rs2 rule: frewrites.induct)
   apply simp
  using frewrite_simprd by presburger




lemma frewrite_simpeq2:
  shows "rs1 \<leadsto>f rs2 \<Longrightarrow> rsimp (RALTS (rdistinct rs1 {})) = rsimp (RALTS (rdistinct rs2 {}))"
  apply(subgoal_tac "\<exists> rs3. (rdistinct rs1 {} \<leadsto>g* rs3) \<and> (rdistinct rs2 {} \<leadsto>g* rs3)")
  using grewrites_equal_rsimp apply fastforce
  using frewrite_rd_grewrites by presburger

(*a more refined notion of \<leadsto>* is needed,
this lemma fails when rs1 contains some RALTS rs where elements
of rs appear in later parts of rs1, which will be picked up by rs2
and deduplicated*)
lemma frewrites_simpeq:
  shows "rs1 \<leadsto>f* rs2 \<Longrightarrow>
 rsimp (RALTS (rdistinct rs1 {})) = rsimp (RALTS ( rdistinct rs2 {})) "
  apply(induct rs1 rs2 rule: frewrites.induct)
   apply simp
  using frewrite_simpeq2 by presburger


lemma frewrite_single_step:
  shows " rs2 \<leadsto>f rs3 \<Longrightarrow> rsimp (RALTS rs2) = rsimp (RALTS rs3)"
  apply(induct rs2 rs3 rule: frewrite.induct)
    apply simp
  using simp_flatten apply blast
  by (metis (no_types, opaque_lifting) list.simps(9) rsimp.simps(2) simp_flatten2)

lemma frewrites_equivalent_simp:
  shows "rs1 \<leadsto>f* rs2 \<Longrightarrow> rsimp (RALTS rs1) = rsimp (RALTS rs2)"
  apply(induct rs1 rs2 rule: frewrites.induct)
   apply simp
  using frewrite_single_step by presburger

lemma grewrite_simpalts:
  shows " rs2 \<leadsto>g rs3 \<Longrightarrow> rsimp (rsimp_ALTs rs2) = rsimp (rsimp_ALTs rs3)"
  apply(induct rs2 rs3 rule : grewrite.induct)
  using identity_wwo0 apply presburger
  apply (metis frewrite.intros(1) frewrite_single_step identity_wwo0 rsimp_ALTs.simps(3) simp_flatten)
  apply (smt (verit, ccfv_SIG) gmany_steps_later grewrites.intros(1) grewrites_cons grewrites_equal_rsimp identity_wwo0 rsimp_ALTs.simps(3))
  apply simp
  apply(subst rsimp_alts_equal)
  apply(case_tac "rsa = [] \<and> rsb = [] \<and> rsc = []")
   apply(subgoal_tac "rsa @ a # rsb @ rsc = [a]")
  apply (simp only:)
  apply (metis append_Nil frewrite.intros(1) frewrite_single_step identity_wwo0 rsimp_ALTs.simps(3) simp_removes_duplicate1(2))
   apply simp
  by (smt (verit, best) append.assoc append_Cons frewrite.intros(1) frewrite_single_step identity_wwo0 in_set_conv_decomp rsimp_ALTs.simps(3) simp_removes_duplicate3)


lemma grewrites_simpalts:
  shows " rs2 \<leadsto>g* rs3 \<Longrightarrow> rsimp (rsimp_ALTs rs2) = rsimp (rsimp_ALTs rs3)"
  apply(induct rs2 rs3 rule: grewrites.induct)
   apply simp
  using grewrite_simpalts by presburger
(*
lemma frewrites_dB_wwo0_simp:
  shows "rdistinct rs1 {RZERO} \<leadsto>f* rdistinct rs2 {RZERO} 
         \<Longrightarrow> rsimp (RALTS (rdistinct rs1 {})) = rsimp (RALTS (rdistinct rs2 {}))"

  sorry
*)
lemma "rsimp (rsimp_ALTs (RZERO # rdistinct (map (rder x) (rflts rs)) {RZERO})) =
       rsimp (rsimp_ALTs (rdistinct (map (rder x) (rflts rs)) {})) "

  sorry



lemma simp_der_flts:
  shows "rsimp (RALTS (rdistinct (map (rder x) (rflts rs)) {})) = 
         rsimp (RALTS (rdistinct (rflts (map (rder x) rs)) {}))"
  apply(subgoal_tac "map (rder x) (rflts rs) \<leadsto>f* rflts (map (rder x) rs)")
  using frewrites_simpeq apply presburger
  using early_late_der_frewrites by auto

  




 



lemma simp_der_pierce_flts_prelim:
  shows "rsimp (rsimp_ALTs (rdistinct (map (rder x) (rflts rs)) {})) 
       = rsimp (rsimp_ALTs (rdistinct (rflts (map (rder x) rs)) {}))"
  by (metis append.right_neutral grewrite.intros(2) grewrite_simpalts rsimp_ALTs.simps(2) simp_der_flts)


lemma simp_der_pierce_flts:
  shows " rsimp (
rsimp_ALTs (rdistinct (map (rder x) (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs))) {})
) =
          rsimp (
rsimp_ALTs (rdistinct (rflts (map (rder x) (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs))) {})
)"
  using simp_der_pierce_flts_prelim by presburger



lemma simp_more_distinct:
  shows "rsimp  (rsimp_ALTs (rsa @ rs)) = rsimp (rsimp_ALTs (rsa @ (rdistinct rs (set rsa)))) "
  



  sorry

lemma non_empty_list:
  shows "a \<in> set as \<Longrightarrow> as \<noteq> []"
  by (metis empty_iff empty_set)

lemma distinct_comp:
  shows "rdistinct (rs1@rs2) {} = (rdistinct rs1 {}) @ (rdistinct rs2 (set rs1))"
  apply(induct rs2 arbitrary: rs1)
   apply simp
  apply(subgoal_tac "rs1 @ a # rs2 = (rs1 @ [a]) @ rs2")
   apply(simp only:)
   apply(case_tac "a \<in> set rs1")
    apply simp
  oops

lemma instantiate1:
  shows "\<lbrakk>\<And>ab rset1.  rdistinct (ab # as) rset1 = rdistinct (ab # as @ [ab]) rset1\<rbrakk> \<Longrightarrow>  
rdistinct (aa # as) rset = rdistinct (aa # as @ [aa]) rset"
  apply(drule_tac x = "aa" in meta_spec)
  apply(drule_tac x = "rset" in meta_spec)
  apply simp
  done
  

lemma not_head_elem:
  shows " \<lbrakk>aa \<in> set (a # as); aa \<notin> (set as)\<rbrakk> \<Longrightarrow> a = aa"
  
  by fastforce

(*
  apply simp
  apply (metis append_Cons)
  apply(case_tac "ab \<in> rset1")
  apply (metis (no_types, opaque_lifting) Un_insert_left append_Cons insert_iff rdistinct.simps(2) sup_bot_left)
  apply(subgoal_tac "rdistinct (ab # (aa # as) @ [ab]) rset1 = 
               ab # (rdistinct ((aa # as) @ [ab]) (insert ab rset1))")
   apply(simp only:)
   apply(subgoal_tac "rdistinct (ab # aa # as) rset1 = ab # (rdistinct (aa # as) (insert ab rset1))")
  apply(simp only:)
    apply(subgoal_tac "rdistinct ((aa # as) @ [ab]) (insert ab rset1) = rdistinct (aa # as) (insert ab rset1)")
  apply blast
*)
  

lemma flts_identity1:
  shows  "rflts (rs @ [RONE]) = rflts rs @ [RONE] "
  apply(induct rs)
   apply simp+
  apply(case_tac a)
       apply simp
      apply simp+
  done

lemma flts_identity10:
  shows " rflts (rs @ [RCHAR c]) = rflts rs @ [RCHAR c]"
  apply(induct rs)
   apply simp+
  apply(case_tac a)
       apply simp+
  done

lemma flts_identity11:
  shows " rflts (rs @ [RSEQ r1 r2]) = rflts rs @ [RSEQ r1 r2]"
  apply(induct rs)
   apply simp+
  apply(case_tac a)
       apply simp+
  done

lemma flts_identity12:
  shows " rflts (rs @ [RSTAR r0]) = rflts rs @ [RSTAR r0]"
  apply(induct rs)
   apply simp+
  apply(case_tac a)
       apply simp+
  done

lemma flts_identity2:
  shows "a \<noteq> RZERO \<and> (\<forall>rs. a \<noteq> RALTS rs) \<Longrightarrow>  rflts (rs @ [a]) = rflts rs @ [a]"
  apply(case_tac a)
       apply simp
  using flts_identity1 apply auto[1]
  using flts_identity10 apply blast
  using flts_identity11 apply auto[1]
   apply blast
  using flts_identity12 by presburger

lemma flts_identity3:
  shows "a = RZERO  \<Longrightarrow> rflts (rs @ [a]) = rflts rs"
  apply simp
  apply(induct rs)
   apply simp+
  apply(case_tac aa)
       apply simp+
  done

lemma distinct_removes_last3:
  shows "\<lbrakk>a \<in> set as\<rbrakk>
    \<Longrightarrow> rdistinct as {} = rdistinct (as @ [a]) {}"
  by (simp add: distinct_removes_last2)

lemma set_inclusion_with_flts1:
  shows " \<lbrakk>RONE \<in> set rs\<rbrakk> \<Longrightarrow> RONE  \<in> set (rflts rs)"
  apply(induct rs)
   apply simp
  apply(case_tac " RONE \<in> set rs")
   apply simp
  apply (metis Un_upper2 insert_absorb insert_subset list.set_intros(2) rflts.simps(2) rflts.simps(3) rflts_def_idiot set_append)
  apply(case_tac "RONE = a")
   apply simp
  apply simp
  done

lemma set_inclusion_with_flts10:
  shows " \<lbrakk>RCHAR x \<in> set rs\<rbrakk> \<Longrightarrow> RCHAR x  \<in> set (rflts rs)"
  apply(induct rs)
   apply simp
  apply(case_tac " RCHAR x \<in> set rs")
   apply simp
  apply (metis Un_upper2 insert_absorb insert_subset rflts.simps(2) rflts.simps(3) rflts_def_idiot set_append set_subset_Cons)
  apply(case_tac "RCHAR x = a")
   apply simp
  apply fastforce
  apply simp
  done

lemma set_inclusion_with_flts11:
  shows " \<lbrakk>RSEQ r1 r2 \<in> set rs\<rbrakk> \<Longrightarrow> RSEQ r1 r2  \<in> set (rflts rs)"
  apply(induct rs)
   apply simp
  apply(case_tac " RSEQ r1 r2 \<in> set rs")
   apply simp
  apply (metis Un_upper2 insert_absorb insert_subset rflts.simps(2) rflts.simps(3) rflts_def_idiot set_append set_subset_Cons)
  apply(case_tac "RSEQ r1 r2 = a")
   apply simp
  apply fastforce
  apply simp
  done


lemma set_inclusion_with_flts:
  shows " \<lbrakk>a \<in> set as; rsimp a \<in> set (map rsimp as); rsimp a = RONE\<rbrakk> \<Longrightarrow> rsimp a \<in> set (rflts (map rsimp as))"
  by (simp add: set_inclusion_with_flts1)
  
lemma "\<And>x5. \<lbrakk>a \<in> set as; rsimp a \<in> set (map rsimp as); rsimp a = RALTS x5\<rbrakk>
          \<Longrightarrow> rsimp_ALTs (rdistinct (rflts (map rsimp as @ [rsimp a])) {}) = 
rsimp_ALTs (rdistinct (rflts (map rsimp as @ x5)) {})"

  sorry


lemma last_elem_dup1:
  shows " a \<in> set as \<Longrightarrow> rsimp (RALTS (as @ [a] )) = rsimp (RALTS (as ))"
  apply simp
  apply(subgoal_tac "rsimp a \<in> set (map rsimp as)")
  prefer 2
   apply simp
  apply(case_tac "rsimp a")
       apply simp
  
  using flts_identity3 apply presburger
      apply(subst flts_identity2)
  using rrexp.distinct(1) rrexp.distinct(15) apply presburger
      apply(subst distinct_removes_last3[symmetric])
  using set_inclusion_with_flts apply blast
  apply simp
  apply (metis distinct_removes_last3 flts_identity10 set_inclusion_with_flts10)
  apply (metis distinct_removes_last3 flts_identity11 set_inclusion_with_flts11)
  sorry

lemma last_elem_dup:
  shows " a \<in> set as \<Longrightarrow> rsimp (rsimp_ALTs (as @ [a] )) = rsimp (rsimp_ALTs (as ))"
  apply(induct as rule: rev_induct)
   apply simp
  apply simp
  apply(subgoal_tac "xs \<noteq> []")
  prefer 2
  

  

  sorry

lemma appeared_before_remove_later:
  shows "a \<in>  set as \<Longrightarrow> rsimp (rsimp_ALTs ( as @ a # rs)) = rsimp (rsimp_ALTs (as @ rs))"
and "a \<in> set as \<Longrightarrow> rsimp (rsimp_ALTs as ) = rsimp (rsimp_ALTs (as @ [a]))"
  apply(induct rs arbitrary: as)
   apply simp
  

  sorry

lemma distinct_remove_later:
  shows "\<lbrakk>rder x a \<in> rder x ` set rsa\<rbrakk>
       \<Longrightarrow> rsimp (rsimp_ALTs (map (rder x) rsa @ rder x a # map (rder x) (rdistinct rs (insert a (set rsa))))) =
           rsimp (rsimp_ALTs (map (rder x) rsa @ map (rder x) (rdistinct rs (set rsa))))"
  
  sorry


lemma distinct_der_general:
  shows "rsimp (rsimp_ALTs (map (rder x) (rsa @ (rdistinct rs (set rsa))))) =
 rsimp ( rsimp_ALTs ((map (rder x) rsa)@(rdistinct (map (rder x) rs) (set (map (rder x) rsa)))) )"
  apply(induct rs arbitrary: rsa)
   apply simp
  apply(case_tac "a \<in> set rsa")
   apply(subgoal_tac "rder x a \<in> set (map (rder x) rsa)")
  apply simp
   apply simp
  apply(case_tac "rder x a \<notin> set (map (rder x) rsa)")
   apply(simp)
  apply(subst map_concat_cons)+
  apply(drule_tac x = "rsa @ [a]" in meta_spec)
   apply simp
  apply(drule neg_removal_element_of)
  apply simp
  apply(subst distinct_remove_later)
   apply simp
  apply(drule_tac x = "rsa" in meta_spec)
  by blast

  


lemma distinct_der:
  shows "rsimp (rsimp_ALTs (map (rder x) (rdistinct rs {}))) = rsimp ( rsimp_ALTs (rdistinct (map (rder x) rs) {}))"
  by (metis distinct_der_general list.simps(8) self_append_conv2 set_empty)

  


lemma rders_simp_lambda:
  shows " rsimp \<circ> rder x \<circ> (\<lambda>r. rders_simp r xs) = (\<lambda>r. rders_simp r (xs @ [x]))"
  using rders_simp_append by auto

lemma rders_simp_nonempty_simped:
  shows "xs \<noteq> [] \<Longrightarrow> rsimp \<circ> (\<lambda>r. rders_simp r xs) = (\<lambda>r. rders_simp r xs)"
  using rders_simp_same_simpders rsimp_idem by auto

lemma repeated_altssimp:
  shows "\<forall>r \<in> set rs. rsimp r = r \<Longrightarrow> rsimp (rsimp_ALTs (rdistinct (rflts rs) {})) =
           rsimp_ALTs (rdistinct (rflts rs) {})"
  by (metis map_idI rsimp.simps(2) rsimp_idem)


lemma add0_isomorphic:
  shows "rsimp_ALTs (rdistinct (rflts [rsimp r, RZERO]) {}) = rsimp r"
  sorry


lemma distinct_append_simp:
  shows " rsimp (rsimp_ALTs rs1) = rsimp (rsimp_ALTs rs2) \<Longrightarrow>
           rsimp (rsimp_ALTs (f a # rs1)) =
           rsimp (rsimp_ALTs (f a # rs2))"
  apply(case_tac rs1)
   apply simp
   apply(case_tac rs2)
    apply simp
   apply simp
   prefer 2
   apply(case_tac list)
    apply(case_tac rs2)
     apply simp
  using add0_isomorphic apply blast 
    apply simp
  oops

lemma alts_closed_form: shows 
"rsimp (rders_simp (RALTS rs) s) = 
rsimp (RALTS (map (\<lambda>r. rders_simp r s) rs))"
  apply(induct s rule: rev_induct)
   apply simp
  apply simp
  apply(subst rders_simp_append)
  apply(subgoal_tac " rsimp (rders_simp (rders_simp (RALTS rs) xs) [x]) = 
 rsimp(rders_simp (rsimp_ALTs (rdistinct (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs)) {})) [x])")
   prefer 2
  apply (metis inside_simp_removal rders_simp_one_char)
  apply(simp only: )
  apply(subst rders_simp_one_char)
  apply(subst rsimp_idem)
  apply(subgoal_tac "rsimp (rder x (rsimp_ALTs (rdistinct (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs)) {}))) =
                     rsimp ((rsimp_ALTs (map (rder x) (rdistinct (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs)) {})))) ")
  prefer 2
  using rder_rsimp_ALTs_commute apply presburger
  apply(simp only:)
  apply(subgoal_tac "rsimp (rsimp_ALTs (map (rder x) (rdistinct (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs)) {})))
= rsimp (rsimp_ALTs (rdistinct (map (rder x) (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs))) {}))")
   prefer 2
  
  using distinct_der apply presburger
  apply(simp only:)
  apply(subgoal_tac " rsimp (rsimp_ALTs (rdistinct (map (rder x) (rflts (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs))) {})) =
                      rsimp (rsimp_ALTs (rdistinct ( (rflts (map (rder x) (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs)))) {}))")
   apply(simp only:)
  apply(subgoal_tac " rsimp (rsimp_ALTs (rdistinct (rflts (map (rder x) (map (rsimp \<circ> (\<lambda>r. rders_simp r xs)) rs))) {})) = 
                      rsimp (rsimp_ALTs (rdistinct (rflts ( (map (rsimp \<circ> (rder x) \<circ> (\<lambda>r. rders_simp r xs)) rs))) {}))")
    apply(simp only:)
  apply(subst rders_simp_lambda)
    apply(subst rders_simp_nonempty_simped)
     apply simp
    apply(subgoal_tac "\<forall>r \<in> set  (map (\<lambda>r. rders_simp r (xs @ [x])) rs). rsimp r = r")
  prefer 2
     apply (simp add: rders_simp_same_simpders rsimp_idem)
    apply(subst repeated_altssimp)
     apply simp
  apply fastforce
   apply (metis inside_simp_removal list.map_comp rder.simps(4) rsimp.simps(2) rsimp_idem)
  using simp_der_pierce_flts by blast

lemma alts_closed_form_variant: shows 
"s \<noteq> [] \<Longrightarrow> rders_simp (RALTS rs) s = 
rsimp (RALTS (map (\<lambda>r. rders_simp r s) rs))"
  by (metis alts_closed_form comp_apply rders_simp_nonempty_simped)
  



lemma star_closed_form:
  shows "rders_simp (RSTAR r0) (c#s) = 
rsimp ( RALTS ( (map (\<lambda>s1. RSEQ (rders_simp r0 s1) (RSTAR r0) ) (star_updates s r0 [[c]]) ) ))"
  apply(induct s)
   apply simp
  sorry



lemma seq_closed_form: shows 
"rsimp (rders_simp (RSEQ r1 r2) s) = 
rsimp ( RALTS ( (RSEQ (rders_simp r1 s) r2) # 
                (map (rders_simp r2) (vsuf s r1)) 
              )  
      )"
  apply(induct s)
  apply simp
  sorry


lemma seq_closed_form_variant: shows
"s \<noteq> [] \<Longrightarrow> (rders_simp (RSEQ r1 r2) s) = 
rsimp (RALTS ((RSEQ (rders_simp r1 s) r2) # (map (rders_simp r2) (vsuf s r1))))"
  apply(induct s rule: rev_induct)
   apply simp
  apply(subst rders_simp_append)
  apply(subst rders_simp_one_char)
  apply(subst rsimp_idem[symmetric])
  apply(subst rders_simp_one_char[symmetric])
  apply(subst rders_simp_append[symmetric])
  apply(insert seq_closed_form)
  apply(subgoal_tac "rsimp (rders_simp (RSEQ r1 r2) (xs @ [x]))
 = rsimp (RALTS (RSEQ (rders_simp r1 (xs @ [x])) r2 # map (rders_simp r2) (vsuf (xs @ [x]) r1)))")
   apply force
  by presburger

lemma simp_helps_der_pierce:
  shows " rsimp
            (rder x
              (rsimp_ALTs rs)) = 
          rsimp 
            (rsimp_ALTs 
              (map (rder x )
                rs
              )
            )"
  sorry

end