package Main

object CompoundClasses {
  trait Cloneable extends java.lang.Cloneable {
    override def clone(): Cloneable = { super.clone(); this }
  }

  trait Resetable {
    def reset: Unit
  }

  def cloneAndReset(obj: Cloneable with Resetable): Cloneable = {
    val cloned = obj.clone()
    obj.reset
    cloned
  }
}

