package greeter

object WorkSheet {
  println("Welcome to the Scala worksheet")       //> Welcome to the Scala worksheet

  val x = 5                                       //> x  : Int = 5
  def increase(i: Int) = i + 1                    //> increase: (i: Int)Int
  increase(x)                                     //> res0: Int = 6

  // Expressions And Simple Functions

  87 + 145                                        //> res1: Int(232) = 232
  5 + 2 * 3                                       //> res2: Int = 11

  "Hello" + " World!"                             //> res3: String("Hello World!") = Hello World!

  def scale = 5                                   //> scale: => Int
  7 * scale                                       //> res4: Int = 35

  def pi = 3.141592653589793                      //> pi: => Double
  def radius = 10                                 //> radius: => Int
  2 * pi * radius                                 //> res5: Double = 62.83185307179586

  // PARAMETERS

  def square(x: Double) = x * x                   //> square: (x: Double)Double
  square(2)                                       //> res6: Double = 4.0
  square(square(4))                               //> res7: Double = 256.0

  def sumOfSquares(x: Double, y: Double) = square(x) + square(y)
                                                  //> sumOfSquares: (x: Double, y: Double)Double
  sumOfSquares(3, 2 + 2)                          //> res8: Double = 25.0

  def loop: Int = loop                            //> loop: => Int
  def first(x: Int, y: Int) = x                   //> first: (x: Int, y: Int)Int
  def constOne(x: Int, y: => Int) = 1             //> constOne: (x: Int, y: => Int)Int
  constOne(1, loop)                               //> res9: Int = 1

  // 4.3 CONDITIONAL EXPRESSIONS

  def abs(x: Double) = if (x >= 5) x + 1 else x - 1
                                                  //> abs: (x: Double)Double
  abs(4)                                          //> res10: Double = 3.0

  // 4.4: Square Roots by Newton's Method

  def sqrtIter(guess: Double, x: Double): Double =
    if (isGoodEnough(guess, x)) guess
    else sqrtIter(improve(guess, x), x)           //> sqrtIter: (guess: Double, x: Double)Double

  def improve(guess: Double, x: Double) =
    (guess + x / guess) / 2                       //> improve: (guess: Double, x: Double)Double

  def isGoodEnough(guess: Double, x: Double) =
    abs(square(guess) - x) < 0.001                //> isGoodEnough: (guess: Double, x: Double)Boolean

  //def sqrt(x: Double) = sqrtIter(1.0, x)
  //sqrt(25)

  // 4.5: Nested Functions

  def sqrt(x: Double) = {
    def sqrtIter(guess: Double): Double =
      if (isGoodEnough(guess)) guess
      else sqrtIter(improve(guess))
    def improve(guess: Double) =
      (guess + x / guess) / 2
    def isGoodEnough(guess: Double) =
      abs(square(guess) - x) < 0.001
    sqrtIter(1.0)
  }                                               //> sqrt: (x: Double)Double
  sqrt(25)                                        //> res11: Double = 1.0

  // 4.6: Tail Recursion

  def gcd(a: Int, b: Int): Int = if (b == 0) a else gcd(b, a % b)
                                                  //> gcd: (a: Int, b: Int)Int

  gcd(21, 36)                                     //> res12: Int = 3

}