theory Command
imports Main
begin

ML {*
let
   val do_nothing = Scan.succeed (Local_Theory.background_theory I)
   val kind = Keyword.thy_decl
in
   Outer_Syntax.local_theory "foobar" "description of foobar" kind do_nothing
end
*}

ML {*
let
  fun trace_prop str =
     Local_Theory.background_theory (fn lthy => (tracing str; lthy))
  val trace_prop_parser = Parse.prop >> trace_prop
  val kind = Keyword.thy_decl
in
  Outer_Syntax.local_theory "foobar_trace" "traces a proposition"
    kind trace_prop_parser
end
*}

ML {*
let
   fun prove_prop str lthy =
     let
       val prop = Syntax.read_prop lthy str
     in
       Proof.theorem NONE (K I) [[(prop,[])]] lthy
     end;
   val prove_prop_parser = Parse.prop >> prove_prop
   val kind = Keyword.thy_goal
in
   Outer_Syntax.local_theory_to_proof "foobar_goal" "proving a proposition"
     kind prove_prop_parser
end
*}

ML {*
val r = Unsynchronized.ref (NONE:(unit -> term) option)
*}
ML{*
let
   fun after_qed thm_name thms lthy =
        Local_Theory.note (thm_name, (flat thms)) lthy |> snd

   fun setup_proof (thm_name, (txt, pos)) lthy =
   let
     val trm = ML_Context.evaluate lthy true ("r", r) txt
   in
     Proof.theorem NONE (after_qed thm_name) [[(trm,[])]] lthy
   end

   val parser = Parse_Spec.opt_thm_name ":" -- Parse.ML_source
 
in
   Outer_Syntax.local_theory_to_proof "foobar_prove" "proving a proposition" 
     Keyword.thy_goal (parser >> setup_proof)
end*}



end
