// for testing evaluation

import scala.util.{Try, Success, Failure}
import $file.cw034_add
import cw034_add._

val str = os.read(os.pwd / "primes.while")
val resmap = Map("end" -> 100, "n" -> 100, "f" -> 4, "tmp" -> 1)

def mapeq[A, B](m1: Map[A, B], m2: Map[A, B]) : Boolean = {
  m1.keySet.forall(k => m1(k) == m2(k))
}


Try(test_string(str)) match {
  case Success(v) if mapeq(resmap, v) => Console.println(s"   Generated the correct result $v")
  case Success(v) => Console.println(s"   Generated $v\n instead of\n $resmap\n.") ; throw new Exception("Different")
  case Failure(e) => Console.println(s"   Exception raised.") ; throw(e)
}
