// for testing compilation
import scala.util.{Try, Success, Failure}


val res = {
  if (os.exists(os.pwd / "br.class")) 
    os.proc("java", "br").call(cwd = os.pwd)
  else if (os.exists(os.pwd / "br" / "br.class")) 
    os.proc("java", "br.br").call(cwd = os.pwd)
  else throw new Exception("No CLASS file found")
}

if (res.exitCode != 0) {
  throw new Exception("Unsuccessful call")
}

Try(res.out.text().replace("\n", "") == "23467") match {
  case Success(v) => Console.println(s"   Success. Printed ${res.out.text().replace("\n", "")}.")
  case Failure(e) => Console.println(s"   Fail. Printed ${res.out.text()} instead of \"2,3,4,6,7\"\n") ; throw(e)
}

