extern crate regex;

use regex::Regex;
use std::time::Instant;

// bounded regular expression example

fn main() {
   println!("GENERATING DFA");
   
   println!("START MATCHING");
   for bound in (10000..=40000).step_by(5000) {
   
        let re = Regex::new(&format!("(abcdef){{{}}}", bound)).unwrap();
        let text = "abcdef".repeat(bound);
	
	let start_time = Instant::now();
   	let is_match = re.is_match(&text);
   	let elapsed_time = start_time.elapsed().as_secs_f64();

   	println!("Bound: {}, Match: {}, Time: {} seconds", bound, is_match, elapsed_time);
   }
}

