#!/usr/bin/env amm

val files = List("cw01.tex",
	         "cw02.tex",
	         "cw03.tex",
	         "cw04.tex",
	         "cw05.tex")




@main
def make() = {
  for (f <- files) {
    println(s"Processing $f ...")
    os.proc("xelatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
    os.proc("xelatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
  }
}


@main
def hg() = {
  os.proc("hg", "commit", "-m texupdate", files.mkString(" ")).call()
}
