// for testing tokenisation

import scala.util.{Try, Success, Failure}
import $file.cw023_add
import cw023_add._

// programs to test (and number of toplevel definitions)
val uprogs = List("collatz.while", 
                  "collatz2.while", 
		  "factors.while",  
		  "fib.while",      
                  "loops.while",    
                  "primes.while") 

for (file <- uprogs) {

  print(s"  Testing lexing with ${file.padTo(16, ' ')} ")
  val str = os.read(os.pwd / file)
  
  Try(test_string(str)) match {
    case Success(v) => println(s"--> Success. Generated ${v.toString.take(30)}...")
    case Failure(e) => println(s"--> FAIL. Exception raised.") ; throw(e)
  }
}
