#!/usr/bin/env amm

val files = Seq("cw01.tex",
	        "cw02.tex",
	        "cw03.tex",
	        "cw04.tex",
	        "cw05.tex")

val pdf_files = files.map(s => s.stripSuffix("tex") ++ "pdf")


@main
def make() = {
  for (f <- files) {
    println(s"Processing $f ...")
    os.proc("lualatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
    os.proc("lualatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
  }
}


@main
def hg() = {
  println(os.proc("hg", "commit", "-m texupdate", files ++ pdf_files).call())
  println(os.proc("hg", "push").call())
}
