#!/usr/bin/env -S scala-cli shebang -no-indent
//> using scala "3.3.1"
//> using toolkit latest

// course work directories
val cws = List("cw1", "cw2", "cw3", "cw4", "cw5")

// main files that need testing
val files = Map("cw1" -> "cw1.sc", 
                "cw2" -> "lexer.sc",
		 		"cw3" -> "parser.sc",
		 		"cw4" -> "compiler.sc",
		 		"cw5" -> "fun_llvm.sc"
		)

// test files used as input
val test_files = Map(
    "cw1" -> Nil,
    "cw2" -> List("collatz.while",
		  "collatz2.while",
		  "factors.while",
		  "fib.while",
		  "loops.while",
		  "primes.while"),
    "cw3" -> List("collatz.while",
		  "collatz2.while",
		  "factors.while",
		  "fib.while",
		  "loops.while",
		  "primes.while"),
    "cw4" -> List("collatz2.while",
		  "fib.while",
		  "forloop.while",
		  "forloop2.while"),
    "cw5" -> List("fact.fun",
		  	"hanoi.fun",
		    "mand.fun",
			"mand2.fun")
)   


for (cw <- cws) {
	val main_file = files(cw)
	for (arg <- test_files(cw)) {
		println(s"Testing $cw/$main_file with $arg")
		val subdir = os.pwd / cw
		os.proc("amm", main_file, "test", arg).call(cwd = subdir)
	}
}
