// for testing tokenisation

import scala.util.{Try, Success, Failure}
import $file.cw05_add
import cw05_add._

// programs to tokenise (and how many tokens) 
val uprogs = List(("fact.fun",  113), 
                  ("hanoi.fun", 92),
		  ("mand.fun",  226),
		  ("mand2.fun", 245),
		  ("sqr.fun",   78))

for ((file, no) <- uprogs) {

  print(s"Testing tokenisation of $file ")
  val str = os.read(os.pwd / file)

  Try(test_string(str)) match {
    case Success(v) => println(s"--> Success. Lexed tokens.")
    //case Success(v) => println(s"--> Success? Lexed ${v.length} tokens (should be $no).\n $v") ; throw new Exception("Different")
    case Failure(e) => println(s"--> FAIL. Exception raised.") ; throw(e)
  }
}
