#!/usr/bin/env amm

val files = Seq("slides01.tex",
	        "slides02.tex",
	        "slides03.tex",
	        "slides04.tex",
	        "slides05.tex",
                "slides06.tex",
	        "slides07.tex",
	        "slides08.tex",
	        "slides09.tex",
	        "slides10.tex")

val pdf_files = files.map(s => s.stripSuffix("tex") ++ "pdf")


@main
def make() = {
  for (f <- files) {
    println(s"Processing $f ...")
    os.proc("xelatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
  }
}

@main
def hg() = {
  println(os.proc("hg", "commit", "-m texupdate", files ++ pdf_files).call())
  println(os.proc("hg", "push").call())
}
