// This version of the crawler also
// harvests emails from webpages

import io.Source
import scala.util.matching.Regex
import scala.util._

// gets the first ~10K of a page
def get_page(url: String) : String = {
  Try(Source.fromURL(url).take(10000).mkString) getOrElse 
    { println(s"  Problem with: $url"); ""}
}

// staring URL for the crawler
val startURL = """http://www.inf.kcl.ac.uk/staff/urbanc/"""

// regex for URLs
val http_pattern = """\"https?://[^\"]*\"""".r
val my_urls = """urbanc""".r
val email_pattern = """([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z\.]{2,6})""".r

// The regular expression for emails comes from: 
//    http://net.tutsplus.com/tutorials/other/8-regular-expressions-you-should-know/

def unquote(s: String) = s.drop(1).dropRight(1)

def get_all_URLs(page: String) : Set[String] = {
  http_pattern.findAllIn(page).map(unquote).toSet
}

// naive version - seraches until a given depth
// visits pages potentially more than once
def crawl(url: String, n: Int) : Unit = {
  if (n == 0) ()
  //else if (my_urls.findFirstIn(url) == None) ()
  else {
    println(s"Visiting: $n $url")
    val page = get_page(url)
    println(email_pattern.findAllIn(page).mkString("\n"))
    for (u <- get_all_URLs(page)) crawl(u, n - 1)
  }
}

crawl(startURL, 3)
