def deriv (r: Rexp, c: Char) : Rexp = r match {
  case NULL => NULL
  case EMPTY => NULL
  case CHAR(d) => if (c == d) EMPTY else NULL
  case ALT(r1, r2) => ALT(deriv(r1, c), deriv(r2, c))
  case SEQ(r1, r2) => 
    if (nullable(r1)) ALT(SEQ(deriv(r1, c), r2), deriv(r2, c))
    else SEQ(deriv(r1, c), r2)
  case STAR(r) => SEQ(deriv(r, c), STAR(r))
}

