/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.Annotation;
import jas.AnnotationAttr;
import jas.CP;
import jas.ClassEnv;
import jas.ConstAttr;
import jas.DeprecatedAttr;
import jas.GenericAttr;
import jas.SignatureAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Var {
    short var_acc;
    CP name;
    CP desc;
    SignatureAttr sig;
    ConstAttr const_attr;
    DeprecatedAttr depr;
    AnnotationAttr annVis;
    AnnotationAttr annInvis;
    Vector generic;

    public Var(short vacc, CP name, CP desc, ConstAttr cattr) {
        this.var_acc = vacc;
        this.name = name;
        this.desc = desc;
        this.const_attr = cattr;
        this.sig = null;
        this.depr = null;
        this.annInvis = null;
        this.annVis = null;
        this.generic = new Vector();
    }

    public void setSignature(SignatureAttr sig) {
        this.sig = sig;
    }

    public void setDeprecated(DeprecatedAttr depr) {
        this.depr = depr;
    }

    public void addGenericAttr(GenericAttr g) {
        this.generic.addElement(g);
    }

    public Annotation addAnnotation(boolean visible, String clsname) {
        AnnotationAttr aa;
        Annotation ann = new Annotation(clsname);
        AnnotationAttr annotationAttr = aa = visible ? this.annVis : this.annInvis;
        if (aa == null) {
            aa = new AnnotationAttr(visible);
            if (visible) {
                this.annVis = aa;
            } else {
                this.annInvis = aa;
            }
        }
        aa.add(ann);
        return ann;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.name);
        e.addCPItem(this.desc);
        if (this.const_attr != null) {
            this.const_attr.resolve(e);
        }
        if (this.sig != null) {
            this.sig.resolve(e);
        }
        if (this.depr != null) {
            this.depr.resolve(e);
        }
        if (this.annVis != null) {
            this.annVis.resolve(e);
        }
        if (this.annInvis != null) {
            this.annInvis.resolve(e);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.resolve(e);
        }
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        out.writeShort(this.var_acc);
        out.writeShort(e.getCPIndex(this.name));
        out.writeShort(e.getCPIndex(this.desc));
        short nb = (short)this.generic.size();
        if (this.const_attr != null) {
            nb = (short)(nb + 1);
        }
        if (this.sig != null) {
            nb = (short)(nb + 1);
        }
        if (this.depr != null) {
            nb = (short)(nb + 1);
        }
        if (this.annVis != null) {
            nb = (short)(nb + 1);
        }
        if (this.annInvis != null) {
            nb = (short)(nb + 1);
        }
        out.writeShort(nb);
        if (this.const_attr != null) {
            this.const_attr.write(e, out);
        }
        if (this.sig != null) {
            this.sig.write(e, out);
        }
        if (this.depr != null) {
            this.depr.write(e, out);
        }
        if (this.annVis != null) {
            this.annVis.write(e, out);
        }
        if (this.annInvis != null) {
            this.annInvis.write(e, out);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.write(e, out);
        }
    }
}

