/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AnnotDefAttr;
import jas.AnnotParamAttr;
import jas.Annotation;
import jas.AnnotationAttr;
import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.DeprecatedAttr;
import jas.ExceptAttr;
import jas.GenericAttr;
import jas.SignatureAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Method {
    short acc;
    CP name;
    CP desc;
    CodeAttr code;
    ExceptAttr excepts;
    SignatureAttr sig;
    DeprecatedAttr depr;
    AnnotationAttr annVis;
    AnnotationAttr annInvis;
    AnnotParamAttr annParamVis;
    AnnotParamAttr annParamInvis;
    AnnotDefAttr annDef;
    Vector generic;

    public Method(short macc, AsciiCP name, AsciiCP desc) {
        this.acc = macc;
        this.name = name;
        this.desc = desc;
        this.sig = null;
        this.code = null;
        this.excepts = null;
        this.depr = null;
        this.annInvis = null;
        this.annVis = null;
        this.annParamInvis = null;
        this.annParamVis = null;
        this.annDef = null;
        this.generic = new Vector();
    }

    public void setCode(CodeAttr cd, ExceptAttr ex) {
        this.code = cd;
        this.excepts = ex;
    }

    public void setSignature(SignatureAttr sig) {
        this.sig = sig;
    }

    public void setDeprecated(DeprecatedAttr depr) {
        this.depr = depr;
    }

    public void addGenericAttr(GenericAttr g) {
        this.generic.addElement(g);
    }

    public Annotation addAnnotation(boolean visible, String clsname) {
        AnnotationAttr aa;
        Annotation ann = new Annotation(clsname);
        AnnotationAttr annotationAttr = aa = visible ? this.annVis : this.annInvis;
        if (aa == null) {
            aa = new AnnotationAttr(visible);
            if (visible) {
                this.annVis = aa;
            } else {
                this.annInvis = aa;
            }
        }
        aa.add(ann);
        return ann;
    }

    public Annotation addAnnotation(boolean visible, String clsname, int paramnum) throws jasError {
        AnnotParamAttr aa;
        if (paramnum <= 0 || paramnum >= 256) {
            throw new jasError("annotation parameter number can be in range 1-256", true);
        }
        Annotation ann = new Annotation(clsname);
        AnnotParamAttr annotParamAttr = aa = visible ? this.annParamVis : this.annParamInvis;
        if (aa == null) {
            aa = new AnnotParamAttr(visible);
            if (visible) {
                this.annParamVis = aa;
            } else {
                this.annParamInvis = aa;
            }
        }
        aa.add(ann, paramnum - 1);
        return ann;
    }

    public Annotation addAnnotation() throws jasError {
        if (this.annDef != null) {
            Annotation.ParserError();
        }
        this.annDef = new AnnotDefAttr();
        return this.annDef.get();
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.name);
        e.addCPItem(this.desc);
        if (this.code != null) {
            this.code.resolve(e);
        }
        if (this.excepts != null) {
            this.excepts.resolve(e);
        }
        if (this.sig != null) {
            this.sig.resolve(e);
        }
        if (this.depr != null) {
            this.depr.resolve(e);
        }
        if (this.annVis != null) {
            this.annVis.resolve(e);
        }
        if (this.annInvis != null) {
            this.annInvis.resolve(e);
        }
        if (this.annParamVis != null) {
            this.annParamVis.resolve(e);
        }
        if (this.annParamInvis != null) {
            this.annParamInvis.resolve(e);
        }
        if (this.annDef != null) {
            this.annDef.resolve(e);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.resolve(e);
        }
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        short cnt = (short)this.generic.size();
        out.writeShort(this.acc);
        out.writeShort(e.getCPIndex(this.name));
        out.writeShort(e.getCPIndex(this.desc));
        if (this.code != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.excepts != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.sig != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.depr != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.annVis != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.annInvis != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.annParamVis != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.annParamInvis != null) {
            cnt = (short)(cnt + 1);
        }
        if (this.annDef != null) {
            cnt = (short)(cnt + 1);
        }
        out.writeShort(cnt);
        if (this.code != null) {
            this.code.write(e, out);
        }
        if (this.excepts != null) {
            this.excepts.write(e, out);
        }
        if (this.sig != null) {
            this.sig.write(e, out);
        }
        if (this.depr != null) {
            this.depr.write(e, out);
        }
        if (this.annVis != null) {
            this.annVis.write(e, out);
        }
        if (this.annInvis != null) {
            this.annInvis.write(e, out);
        }
        if (this.annParamVis != null) {
            this.annParamVis.write(e, out);
        }
        if (this.annParamInvis != null) {
            this.annParamInvis.write(e, out);
        }
        if (this.annDef != null) {
            this.annDef.write(e, out);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.write(e, out);
        }
    }
}

