/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVarEntry {
    Label start;
    Label end;
    CP name;
    CP sig;
    int slot;
    int starto;
    int endo;

    public LocalVarEntry(Label startLabel, Label endLabel, String name, String sig, int slot) {
        this.start = startLabel;
        this.end = endLabel;
        this.name = new AsciiCP(name);
        this.sig = new AsciiCP(sig);
        this.slot = slot;
    }

    public LocalVarEntry(int startOffset, int endOffset, String name, String sig, int slot) {
        this.starto = startOffset;
        this.endo = endOffset;
        this.name = new AsciiCP(name);
        this.sig = new AsciiCP(sig);
        this.slot = slot;
    }

    public LocalVarEntry(Label startLabel, Label endLabel, CP name, CP sig, int slot) {
        this.start = startLabel;
        this.end = endLabel;
        this.name = name;
        this.sig = sig;
        this.slot = slot;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.name);
        e.addCPItem(this.sig);
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        if (this.start != null && this.end != null) {
            this.start.writeOffset(ce, null, out);
            this.end.writeOffset(ce, this.start, out);
        } else {
            out.writeShort(this.starto);
            out.writeShort(this.endo - this.starto);
        }
        out.writeShort(e.getCPIndex(this.name));
        out.writeShort(e.getCPIndex(this.sig));
        out.writeShort((short)this.slot);
    }
}

