/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.Annotation;
import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.DoubleCP;
import jas.FloatCP;
import jas.IntegerCP;
import jas.LongCP;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AnnotationElement {
    private boolean array;
    private char sign;
    private CP name = null;
    private CP exttype;
    private Vector values;
    private static final char type_int = 'I';
    private static final char type_byte = 'B';
    private static final char type_char = 'C';
    private static final char type_short = 'S';
    private static final char type_bool = 'Z';
    private static final char type_float = 'F';
    private static final char type_double = 'D';
    private static final char type_long = 'J';
    private static final char type_array = '[';
    private static final char type_string = 's';
    private static final char type_class = 'c';
    private static final char type_enum = 'e';
    private static final char type_annot = '@';

    private static void badsignature() throws jasError {
        throw new jasError("invalid type signature for annotation field");
    }

    public AnnotationElement(String name, String type, String exttype) throws jasError {
        if (name != null) {
            this.name = new AsciiCP(name);
        }
        this.values = new Vector();
        this.array = false;
        this.sign = type.charAt(0);
        if (this.sign != '[') {
            if (type.length() != 1) {
                AnnotationElement.badsignature();
            }
        } else {
            this.array = true;
            if (type.length() != 2) {
                AnnotationElement.badsignature();
            }
            this.sign = type.charAt(1);
        }
        switch (this.sign) {
            default: {
                AnnotationElement.badsignature();
            }
            case '@': 
            case 'e': {
                if (exttype == null) {
                    AnnotationElement.badsignature();
                }
                this.exttype = new AsciiCP(exttype);
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 'c': 
            case 's': {
                if (exttype != null) {
                    AnnotationElement.badsignature();
                }
                this.exttype = null;
            }
        }
    }

    void addValue(Object value) throws jasError {
        if (value == null) {
            Annotation.ParserError();
        }
        if (!this.array && this.values.size() != 0) {
            throw new jasError("too many values for nonarray annotation field type");
        }
        CP cp = null;
        switch (this.sign) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                if (!(value instanceof Integer)) break;
                int val = (Integer)value;
                boolean badval = false;
                switch (this.sign) {
                    case 'Z': {
                        if (val >= 0 && val <= 1) break;
                        badval = true;
                        break;
                    }
                    case 'C': {
                        if (val >= 0 && val <= 65535) break;
                        badval = true;
                        break;
                    }
                    case 'B': {
                        if (val < -128 || val > 127) {
                            badval = true;
                        }
                    }
                    case 'S': {
                        if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) break;
                        badval = true;
                    }
                }
                if (badval) {
                    throw new jasError("annotation field value exceed range of type", true);
                }
                cp = new IntegerCP(val);
                break;
            }
            case 'F': {
                if (!(value instanceof Float)) break;
                cp = new FloatCP(((Float)value).floatValue());
                break;
            }
            case 'D': {
                if (value instanceof Double) {
                    cp = new DoubleCP((Double)value);
                    break;
                }
                if (!(value instanceof Float)) break;
                cp = new DoubleCP(((Float)value).floatValue());
                break;
            }
            case 'J': {
                if (value instanceof Long) {
                    cp = new LongCP((Long)value);
                    break;
                }
                if (!(value instanceof Integer)) break;
                cp = new LongCP(((Integer)value).intValue());
                break;
            }
            case 'c': 
            case 'e': 
            case 's': {
                if (!(value instanceof String)) break;
                cp = new AsciiCP((String)value);
                break;
            }
            case '@': {
                if (!(value instanceof Annotation)) break;
                cp = (Annotation)value;
            }
        }
        if (cp == null) {
            throw new jasError("incompatible value for annotation field type");
        }
        this.values.add(cp);
    }

    public AsciiCP nestType() throws jasError {
        if (this.sign != '@') {
            Annotation.ParserError();
        }
        return (AsciiCP)this.exttype;
    }

    public void done() throws jasError {
        switch (this.values.size()) {
            case 1: {
                return;
            }
            default: {
                if (!this.array) break;
                return;
            }
            case 0: 
        }
        Annotation.ParserError();
    }

    void resolve(ClassEnv e) {
        if (this.name != null) {
            e.addCPItem(this.name);
        }
        if (this.sign == 'e') {
            e.addCPItem(this.exttype);
        }
        Enumeration en = this.values.elements();
        while (en.hasMoreElements()) {
            CP cp = (CP)en.nextElement();
            if (this.sign != '@') {
                e.addCPItem(cp);
                continue;
            }
            cp.resolve(e);
        }
    }

    int size() throws jasError {
        int len;
        this.done();
        if (this.sign == '@') {
            len = this.values.size();
            Enumeration en = this.values.elements();
            while (en.hasMoreElements()) {
                len += ((Annotation)en.nextElement()).size();
            }
        } else {
            len = 3;
            if (this.sign == 'e') {
                len += 2;
            }
            len *= this.values.size();
        }
        if (this.array) {
            len += 3;
        }
        if (this.name != null) {
            len += 2;
        }
        return len;
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        this.done();
        if (this.name != null) {
            out.writeShort(e.getCPIndex(this.name));
        }
        if (this.array) {
            out.writeByte(91);
            out.writeShort((short)this.values.size());
        }
        short id = 0;
        if (this.sign == 'e') {
            id = e.getCPIndex(this.exttype);
        }
        Enumeration en = this.values.elements();
        block4: while (en.hasMoreElements()) {
            out.writeByte(this.sign);
            CP cp = (CP)en.nextElement();
            switch (this.sign) {
                case '@': {
                    ((Annotation)cp).write(e, out);
                    continue block4;
                }
                case 'e': {
                    out.writeShort(id);
                }
            }
            out.writeShort(e.getCPIndex(cp));
        }
    }
}

