abstract class Parser[I, T] {
  def parse(ts: I): Set[(T, I)]

  def parse_all(ts: I) : Set[T] =
    for ((head, tail) <- parse(ts); if (tail.isEmpty)) 
      yield head

  def || (right : => Parser[I, T]) : Parser[I, T] = 
      new AltParser(this, right)
  def ==>[S] (f: => T => S) : Parser [I, S] = 
      new FunParser(this, f)
   def ~[S] (right : => Parser[I, S]) : Parser[I, (T, S)] = 
      new SeqParser(this, right)
}


