/// A case of catastrophic backtracking in Dart
///---------------------------------------------
/// example provided by Martin Todorov
///
/// regex: (a*)*b
/// strings: aa...a
///
/// run with
///
///    dart catastrophic.dart n


main(List<String> args) {
  final n = int.parse(args[0]);
  final evilRegex = RegExp("(a*)*b");

  for(int i = 1; i <= n; i++) {
    final toMatch = "a" * i;
    final stopwatch = Stopwatch()..start();
    evilRegex.hasMatch(toMatch);
    print("$i a's matched in ${stopwatch.elapsed}");
  }
}
