// for primitive definitions
import $file.cw02
import cw02._

def sz(r: Rexp): Int = r match {
  case ZERO => 1
  case ONE => 1
  case CHAR(_) => 1
  case ALT(r1, r2) => 1 + sz(r1) + sz (r2)
  case SEQ(r1, r2) => 1 + sz(r1) + sz (r2)
  case STAR(r1) => 1 + sz(r1)
  case PLUS(r1) => 1 + sz(r1)
  case NTIMES(r1, n) => 1 + sz(r1)
  case OPTIONAL(r1) => 1 + sz(r1)
  case RECD(_, r1) => 1 + sz(r1)
  case RANGE(_) => 1
}

assert(sz(RANGE("abc")) != 1)




