/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AnnotationElement;
import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Annotation
extends CP {
    private Vector fields;
    private AsciiCP type;
    private Annotation parent;
    private AnnotationElement field;
    private boolean is_default;

    public static final void ParserError() throws jasError {
        throw new jasError("internal logic error in annotation parsing");
    }

    private Annotation(Annotation parent, AsciiCP type) {
        this.type = type;
        this.parent = parent;
        this.field = null;
        this.fields = new Vector();
    }

    public Annotation(String type) {
        this(null, new AsciiCP(type));
    }

    public Annotation() {
        this(null, null);
    }

    public Annotation nestAnnotation() throws jasError {
        if (this.field == null) {
            Annotation.ParserError();
        }
        Annotation tmp = new Annotation(this, this.field.nestType());
        this.field.addValue(tmp);
        return tmp;
    }

    public Annotation endAnnotation() throws jasError {
        if (this.field != null) {
            this.field.done();
            this.field = null;
        }
        return this.parent;
    }

    public void addField(String name, String type, String add) throws jasError {
        if (this.type == null && this.fields.size() != 0) {
            Annotation.ParserError();
        }
        if (this.field != null) {
            this.field.done();
            this.field = null;
        }
        if (name == null != (this.type == null)) {
            Annotation.ParserError();
        }
        this.field = new AnnotationElement(name, type, add);
        this.fields.add(this.field);
    }

    public void addValue(Object value) throws jasError {
        if (this.field == null) {
            Annotation.ParserError();
        }
        this.field.addValue(value);
    }

    void resolve(ClassEnv e) {
        if (this.type != null) {
            e.addCPItem(this.type);
        }
        Enumeration en = this.fields.elements();
        while (en.hasMoreElements()) {
            ((AnnotationElement)en.nextElement()).resolve(e);
        }
    }

    int size() throws jasError {
        if (this.field != null) {
            Annotation.ParserError();
        }
        int len = 4;
        if (this.type == null) {
            if (this.fields.size() != 1) {
                Annotation.ParserError();
            }
            len = 0;
        }
        Enumeration en = this.fields.elements();
        while (en.hasMoreElements()) {
            len += ((AnnotationElement)en.nextElement()).size();
        }
        return len;
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        if (this.field != null) {
            Annotation.ParserError();
        }
        if (this.type != null) {
            out.writeShort(e.getCPIndex(this.type));
            out.writeShort((short)this.fields.size());
        } else if (this.fields.size() != 1) {
            Annotation.ParserError();
        }
        Enumeration en = this.fields.elements();
        while (en.hasMoreElements()) {
            ((AnnotationElement)en.nextElement()).write(e, out);
        }
    }
}

