val http_pattern = """\"https?://[^\"]*\"""".r

def unquote(s: String) = s.drop(1).dropRight(1)

def get_all_URLs(page: String) : Set[String] = {
  (http_pattern.findAllIn(page)).map { unquote(_) }.toSet
}

def crawl(url: String, n: Int) : Unit = {
  if (n == 0) ()
  else {
    println("Visiting: " + n + " " + url)
    for (u <- get_all_URLs(get_page(url))) crawl(u, n - 1)
  }
}

