/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

import jas.jasError;
import jasmin.InsnInfo;
import jasmin.ReservedWords;
import jasmin.ScannerUtils;
import jasmin.num_token;
import jasmin.relative_num_token;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java_cup.runtime.int_token;
import java_cup.runtime.str_token;
import java_cup.runtime.token;

class Scanner {
    Reader inp;
    int next_char;
    char[] chars;
    private static int chars_size = 512;
    static final String WHITESPACE = " \n\t\r";
    static final String SEPARATORS = " \n\t\r:=";
    public int line_num;
    public int token_line_num;
    public int char_num;
    public int int_char_num;
    public int int_line_num;
    public StringBuffer line;
    public String int_line;
    public Hashtable dict = new Hashtable();

    protected static boolean whitespace(int c) {
        return WHITESPACE.indexOf(c) != -1;
    }

    protected static boolean separator(int c) {
        return c == -1 || SEPARATORS.indexOf(c) != -1;
    }

    protected void advance() throws IOException {
        this.next_char = this.inp.read();
        switch (this.next_char) {
            case -1: {
                if (this.char_num == 0) {
                    this.char_num = -1;
                    break;
                }
                this.next_char = 10;
            }
            case 10: {
                ++this.line_num;
                this.char_num = 0;
                break;
            }
            default: {
                this.line.append((char)this.next_char);
                ++this.char_num;
                return;
            }
        }
        this.line.setLength(0);
    }

    public Scanner(Reader i) throws IOException, jasError {
        this.inp = i;
        this.line_num = 1;
        this.char_num = 0;
        this.line = new StringBuffer();
        this.chars = new char[chars_size];
        this.next_char = 0;
        this.skip_empty_lines();
        if (this.next_char == -1) {
            throw new jasError("empty source file");
        }
    }

    private void chars_expand() {
        char[] temp = new char[chars_size * 2];
        System.arraycopy(this.chars, 0, temp, 0, chars_size);
        chars_size *= 2;
        this.chars = temp;
    }

    private void skip_empty_lines() throws IOException {
        while (true) {
            if (this.next_char != 59) {
                do {
                    this.advance();
                } while (Scanner.whitespace(this.next_char));
                if (this.next_char != 59) {
                    return;
                }
            }
            do {
                this.advance();
                if (this.next_char != -1) continue;
                return;
            } while (this.next_char != 10);
        }
    }

    private char uniEscape() throws IOException, jasError {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            this.advance();
            if (this.next_char == -1) {
                return '\u0000';
            }
            int tmp = Character.digit((char)this.next_char, 16);
            if (tmp == -1) {
                throw new jasError("Bad '\\u' escape sequence");
            }
            res = res << 4 | tmp;
        }
        return (char)res;
    }

    private char nameEscape() throws IOException, jasError {
        this.advance();
        if (this.next_char != 117) {
            throw new jasError("Only '\\u' escape sequence allowed in names");
        }
        char chval = this.uniEscape();
        if (this.next_char == -1) {
            throw new jasError("Left over '\\u' escape sequence");
        }
        return chval;
    }

    public token next_token() throws IOException, jasError {
        this.token_line_num = this.line_num;
        block31: while (true) {
            switch (this.next_char) {
                case 10: 
                case 59: {
                    this.skip_empty_lines();
                    this.token_line_num = this.line_num;
                    return new token(64);
                }
                case -1: {
                    this.char_num = -1;
                    return new token(0);
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    Number num;
                    int pos = 0;
                    do {
                        this.chars[pos] = (char)this.next_char;
                        if (++pos == chars_size) {
                            this.chars_expand();
                        }
                        this.advance();
                    } while (!Scanner.separator(this.next_char));
                    String str = new String(this.chars, 0, pos);
                    token tok = ReservedWords.get(str);
                    if (tok != null) {
                        return tok;
                    }
                    try {
                        num = ScannerUtils.convertNumber(str);
                    }
                    catch (NumberFormatException e) {
                        if (this.chars[0] != '.') {
                            throw new jasError("Badly formatted number");
                        }
                        throw new jasError("Unknown directive or badly formed number.");
                    }
                    if (num instanceof Integer) {
                        this.int_line = this.line.toString();
                        this.int_line_num = this.token_line_num;
                        this.int_char_num = this.char_num;
                        return new int_token(69, num.intValue());
                    }
                    return new num_token(70, num);
                }
                case 34: {
                    boolean already = false;
                    int pos = 0;
                    block33: while (true) {
                        if (already) {
                            already = false;
                        } else {
                            this.advance();
                        }
                        if (this.next_char == 34) {
                            this.advance();
                            return new str_token(66, new String(this.chars, 0, pos));
                        }
                        if (this.next_char == -1) {
                            throw new jasError("Unterminated string");
                        }
                        int chval = this.next_char;
                        if (chval == 92) {
                            this.advance();
                            switch (this.next_char) {
                                case -1: {
                                    already = true;
                                    continue block33;
                                }
                                case 110: {
                                    chval = 10;
                                    break;
                                }
                                case 114: {
                                    chval = 13;
                                    break;
                                }
                                case 116: {
                                    chval = 9;
                                    break;
                                }
                                case 102: {
                                    chval = 12;
                                    break;
                                }
                                case 98: {
                                    chval = 8;
                                    break;
                                }
                                case 34: {
                                    chval = 34;
                                    break;
                                }
                                case 39: {
                                    chval = 39;
                                    break;
                                }
                                case 92: {
                                    chval = 92;
                                    break;
                                }
                                case 117: {
                                    chval = this.uniEscape();
                                    if (this.next_char != -1) break;
                                    already = true;
                                    continue block33;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    int res = this.next_char & 7;
                                    this.advance();
                                    if (this.next_char < 48 || this.next_char > 55) {
                                        already = true;
                                    } else {
                                        res = res * 8 + (this.next_char & 7);
                                        this.advance();
                                        if (this.next_char < 48 || this.next_char > 55) {
                                            already = true;
                                        } else {
                                            int val = res * 8 + (this.next_char & 7);
                                            if (val >= 256) {
                                                already = true;
                                            } else {
                                                res = val;
                                            }
                                        }
                                    }
                                    chval = (char)res;
                                    break;
                                }
                                default: {
                                    throw new jasError("Bad backslash escape sequence");
                                }
                            }
                        }
                        this.chars[pos] = chval;
                        if (++pos != chars_size) continue;
                        this.chars_expand();
                    }
                }
                case 39: {
                    int pos = 0;
                    while (true) {
                        this.advance();
                        if (Scanner.separator(this.next_char)) {
                            throw new jasError("Unterminated ''-enclosed name");
                        }
                        if (this.next_char == 39) {
                            if (pos == 0) {
                                throw new jasError("Empty ''-enclosed name");
                            }
                            this.advance();
                            if (!Scanner.separator(this.next_char)) {
                                throw new jasError("Not separator after ''-enclosed name");
                            }
                            return new str_token(67, new String(this.chars, 0, pos));
                        }
                        char chval = (char)this.next_char;
                        if (this.next_char == 92) {
                            chval = this.nameEscape();
                        }
                        this.chars[pos] = chval;
                        if (++pos != chars_size) continue;
                        this.chars_expand();
                    }
                }
                case 9: 
                case 13: 
                case 32: {
                    this.advance();
                    continue block31;
                }
                case 61: {
                    this.advance();
                    return new token(63);
                }
                case 58: {
                    this.advance();
                    return new token(65);
                }
            }
            break;
        }
        int pos = 0;
        boolean only_name = false;
        do {
            char chval = (char)this.next_char;
            if (this.next_char == 92) {
                chval = this.nameEscape();
                only_name = true;
            }
            this.chars[pos] = chval;
            if (++pos == chars_size) {
                this.chars_expand();
            }
            this.advance();
        } while (!Scanner.separator(this.next_char));
        String str = new String(this.chars, 0, pos);
        if (!only_name) {
            token tok = ReservedWords.get(str);
            if (tok != null) {
                return tok;
            }
            if (InsnInfo.contains(str)) {
                return new str_token(68, str);
            }
            if (str.charAt(0) == '$') {
                String s = str.substring(1);
                int n = 10;
                boolean neg = false;
                boolean sign = false;
                switch (s.charAt(0)) {
                    default: {
                        break;
                    }
                    case '-': {
                        neg = true;
                    }
                    case '+': {
                        s = s.substring(1);
                        if (s.startsWith("0x")) {
                            n = 16;
                            s = s.substring(2);
                        }
                        try {
                            n = Integer.parseInt(s, n);
                        }
                        catch (NumberFormatException e) {
                            throw new jasError("Badly relative offset number");
                        }
                        if (neg) {
                            n = -n;
                        }
                        return new relative_num_token(71, n);
                    }
                }
                Object v = this.dict.get(s);
                if (v != null) {
                    return (token)v;
                }
            }
        }
        return new str_token(67, str);
    }
}

