#!/bin/zsh

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo `date` | tee -a $out
echo "" >> $out
echo "Below is the feedback and provisional marks for your CW 2 submission." >> $out
echo "Please note all marks are provisional until ratified by the" >> $out
echo "assessment board -- this is not an official results transcript." >> $out
echo "" >> $out

echo "The feedback for your submission for cw02.sc" >> $out
echo "" >> $out

# marks for CW 2
marks=$(( 0.0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" amm -s "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  rm -rf /Users/cu/.ammonite/cache/3.*/* 2> /dev/null ;  
  (ulimit -t 30; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1" 1>> $out 2>> $out)
}

function scala_fail {
  #rm -rf /Users/cu/.ammonite/cache/3.0.0-M2/* 2> /dev/null ;  
  (ulimit -t 30; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1") # 1>> $out 2>> $out)
}



### compilation test

echo -e "0) cw02.sc compiles?\n" | tee -a $out

if (scala_compile "c.sc")
then
    echo -e "   --> yes cw02.sc compiles\n" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "   --> AMM DID NOT compile cw02.sc\n" | tee -a $out
    cat c$out | tee -a $out
    echo -e "\n\n" >> $out
    tsts=$(( 1 ))
fi

echo >> $out

### "read n;" test
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
    echo -e "1) Tokenise string from Question 2:\n" | tee -a $out
    echo -e "   tokenise(\"read n;\") == List(T_KEYWORD(read), T_ID(n), T_SEMI) ?\n" | tee -a $out
    if (scala_assert "c1.sc")
    then
	echo -e "   --> success (+ 3.0 Marks)\n" | tee -a $out
	marks=$(( marks + 3.0 ))
    else
	echo -e "   --> FAILED\n" | tee -a $out
	echo -e "       instead it generates:\n" | tee -a $out
	(scala_fail "c1a.sc" || true) | tee -a $out
	echo -e "\n\n" >> $out
    fi
fi

### tokenise test
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
  echo -e "2) Tokenise test with example files (does it raise an exception):\n" | tee -a $out
  cat cw02.sc c3_add.sc > cw023_add.sc  
  if (scala_assert "c3.sc")
  then
      echo -e "   --> success (+ 3.0 Marks)\n" | tee -a $out
      marks=$(( marks + 3.0 ))
  else
      echo -e "   --> FAILED\n" | tee -a $out
      #cat $out | tee -a $out
  fi
fi

### tokenise test for collatz2.while
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
  echo -e "3) Check tokens for collatz2.while:\n" | tee -a $out
  cat cw02.sc c4_add.sc > cw024_add.sc  
  if (scala_assert "c4.sc")
  then
      echo -e "   --> success (+ 2.0 Marks)\n" | tee -a $out
      marks=$(( marks + 2.0 ))
  else
      echo -e "   --> FAILED\n" | tee -a $out
      #cat $out | tee -a $out
  fi
fi

### are constructors primitive
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
    echo -e "4) Are regex constructors all primitive?\n" | tee -a $out
    echo -e "   For example, RANGE.toString == \"RANGE\"\n" | tee -a $out
    if (scala_assert "c5.sc")
    then
	echo -e "   --> FAILED\n" | tee -a $out
	tail -25 $out | pr -to10
	echo -e "\n\n" >> $out
    else
	echo -e "   --> success (+ 2.0 Marks)\n" | tee -a $out
	marks=$(( marks + 2.0 ))
    fi
fi


## final marks
echo >> $out
echo "Overall mark for CW 2" | tee -a $out
printf " %0.2f\n" $marks | tee -a $out



