def concat(A: Set[String], B: Set[String]) : Set[String] =
  for (x <- A ; y <- B) yield x ++ y

def pow(A: Set[String], n: Int) : Set[String] = n match {
  case 0 => Set("")
  case n => concat(A, pow(A, n- 1))
}

val A = Set("1", "2", "3", "")
val B = Set("1", "2", "3", "4", "5", "6", "")
concat(A, B).size                     // -> 28 
pow(B, 3).size 


val A = Set("a", "b", "c", "d")
pow(A, 4).size                            // -> 256

val B = Set("a", "b", "c", "")
pow(B, 4)
pow(B, 4).size                            // -> 121
pow(B, 3).size 


val B2 = Set("a", "b", "c", "")
pow(B2, 3).size                           // -> 40

val C = Set("a", "b", "")
pow(C, 2)
pow(C, 2).size                            // -> 7

pow(C, 3)
pow(C, 3).size                            // -> 15


//val A = Set("a", "b", "c", "d")
//pow(A, 4).size   

//val A = Set("a", "b", "c")
//pow(A, 5).size   

//val A = Set("a", "b", "")
//pow(A, 5).size   


for (n <- (0 to 6).toList) 
  yield pow(B, n).size





val A = Set("a", "b", "c")
pow(A, 3)
pow(A, 3).size

val B = Set("a", "b", "")
pow(B, 4)
pow(B, 4).size
