def simp(r: Rexp): Rexp = r match {
  case ALT(r1, r2) => {
    val r1s = simp(r1)
    val r2s = simp(r2)
    (r1s, r2s) match {
      case (NULL, _) => r2s
      case (_, NULL) => r1s
      case _ => if (r1s == r2s) r1s else ALT(r1s, r2s)
    }
  }
  case SEQ(r1, r2) => {
    val r1s = simp(r1)
    val r2s = simp(r2)
    (r1s, r2s) match {
      case (NULL, _) => NULL
      case (_, NULL) => NULL
      case (EMPTY, _) => r2s
      case (_, EMPTY) => r1s
      case _ => SEQ(r1s, r2s)
    }
  }
  case NTIMES(r, n) => NTIMES(simp(r), n)    
  case r => r
}

def ders (s: List[Char], r: Rexp) : Rexp = s match {
  case Nil => r
  case c::s => ders(s, simp(der(c, r)))
}

