class AltParser[I, T](p: => Parser[I, T], 
                      q: => Parser[I, T]) 
                          extends Parser[I, T] {
  def parse(sb: I) = p.parse(sb) ++ q.parse(sb)   
}

class SeqParser[I, T, S](p: => Parser[I, T], 
                         q: => Parser[I, S]) 
                             extends Parser[I, (T, S)] {
  def parse(sb: I) = 
    for ((head1, tail1) <- p.parse(sb); 
         (head2, tail2) <- q.parse(tail1)) 
            yield ((head1, head2), tail2)
}

class FunParser[I, T, S](p: => Parser[I, T], f: T => S) 
                                  extends Parser[I, S] {
  def parse(sb: I) = 
    for ((head, tail) <- p.parse(sb)) 
      yield (f(head), tail)
}


